/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.concepts.db.creators;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import de.julielab.concepts.db.core.services.FacetCreationService;
import de.julielab.concepts.db.core.spi.ConceptCreator;
import de.julielab.concepts.util.ConceptCreationException;
import de.julielab.concepts.util.FacetCreationException;
import de.julielab.java.utilities.ConfigurationUtilities;
import de.julielab.java.utilities.FileUtilities;
import de.julielab.neo4j.plugins.datarepresentation.ConceptCoordinates;
import de.julielab.neo4j.plugins.datarepresentation.ImportConcept;
import de.julielab.neo4j.plugins.datarepresentation.ImportConcepts;
import de.julielab.neo4j.plugins.datarepresentation.ImportFacet;
import de.julielab.neo4j.plugins.datarepresentation.ImportOptions;
import de.julielab.semedico.resources.ResourceTermLabels;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NCBIGeneConceptCreator
implements ConceptCreator {
    public static final String SEMEDICO_RESOURCE_MANAGEMENT_SOURCE = "Semedico Resource Management";
    public static final String NCBI_GENE_SOURCE = "NCBI Gene";
    public static final String BASEPATH = "basepath";
    public static final String GENE_INFO = "gene_info";
    public static final String GENEDESCRIPTIONS = "genedescriptions";
    public static final String ORGANISMLIST = "organismlist";
    public static final String ORGANISMNAMES = "organismnames";
    public static final String HOMOLOGENE = "homologene";
    public static final String GENE_GROUP = "gene_group";
    public static final String HOMOLOGENE_PREFIX = "homologene";
    public static final String GENE_GROUP_PREFIX = "genegroup";
    public static final String TOP_ORTHOLOGY_PREFIX = "toporthology";
    public static final String TOP_HOMOLOGY_PREFIX = "tophomology";
    private int homologeneAggregateCounter;
    private int orthologAggregateCounter;
    private int topOrthologAggregateCounter;
    private int topHomologyAggregateCounter;
    private Logger log = LoggerFactory.getLogger(NCBIGeneConceptCreator.class);

    public NCBIGeneConceptCreator() {
        this.resetCounters();
    }

    private void resetCounters() {
        this.homologeneAggregateCounter = 0;
        this.orthologAggregateCounter = 0;
        this.topOrthologAggregateCounter = 0;
        this.topHomologyAggregateCounter = 0;
    }

    private void createHomologyAggregates(Map<ConceptCoordinates, ImportConcept> termsByGeneId, File homologene, File geneGroup) throws IOException {
        HashMultimap genes2Aggregate = HashMultimap.create();
        List<String> aggregateCopyProperties = Arrays.asList("preferredName", "synonyms", "writingVariants", "descriptions", "facets");
        this.checkfornullparentcoords(termsByGeneId);
        this.checkfornullparentcoords(termsByGeneId);
        this.createGeneOrthologyAggregates((Multimap<String, ConceptCoordinates>)genes2Aggregate, geneGroup, termsByGeneId, aggregateCopyProperties);
        System.out.println("After ortho aggs");
        this.checkfornullparentcoords(termsByGeneId);
        this.createTopHomologyAggregates((Multimap<String, ConceptCoordinates>)genes2Aggregate, termsByGeneId, aggregateCopyProperties);
        System.out.println("After top-homologene aggs");
        this.checkfornullparentcoords(termsByGeneId);
    }

    private void checkfornullparentcoords(Map<ConceptCoordinates, ImportConcept> termsByGeneId) {
        for (ImportConcept c : termsByGeneId.values()) {
            if (c.parentCoordinates != null) continue;
            throw new IllegalArgumentException(c.coordinates.toString());
        }
    }

    private void createTopHomologyAggregates(Multimap<String, ConceptCoordinates> genes2Aggregate, Map<ConceptCoordinates, ImportConcept> termsByGeneId, List<String> aggregateCopyProperties) {
        for (String geneId : genes2Aggregate.keySet()) {
            Set<ImportConcept> topAggregates;
            ImportConcept gene = termsByGeneId.get(NCBIGeneConceptCreator.getGeneCoordinates(geneId));
            ImportConcept topHomologyAggregate = this.findTopHomologyAggregate(gene, termsByGeneId);
            if (topHomologyAggregate != null || (topAggregates = this.findTopOrthologsAndHomologyAggregates(gene, termsByGeneId, new TreeSet<ImportConcept>(Comparator.comparingLong(System::identityHashCode)))).size() <= 1) continue;
            topHomologyAggregate = new ImportConcept(topAggregates.stream().map(ic -> ic.coordinates).collect(Collectors.toList()), aggregateCopyProperties);
            topHomologyAggregate.coordinates = new ConceptCoordinates();
            topHomologyAggregate.coordinates.sourceId = TOP_HOMOLOGY_PREFIX + this.topHomologyAggregateCounter;
            topHomologyAggregate.coordinates.source = SEMEDICO_RESOURCE_MANAGEMENT_SOURCE;
            topHomologyAggregate.aggregateIncludeInHierarchy = true;
            topHomologyAggregate.generalLabels = Arrays.asList("AGGREGATE_TOP_HOMOLOGY", "NO_PROCESSING_GAZETTEER");
            ConceptCoordinates topHomologyCoordinates = topHomologyAggregate.coordinates;
            termsByGeneId.put(topHomologyAggregate.coordinates, topHomologyAggregate);
            topAggregates.forEach(agg -> agg.addParent(topHomologyCoordinates));
            ++this.topHomologyAggregateCounter;
        }
    }

    private Set<ImportConcept> findTopOrthologsAndHomologyAggregates(ImportConcept concept, Map<ConceptCoordinates, ImportConcept> termsByGeneId, Set<ImportConcept> importConcepts) {
        Predicate<ImportConcept> isSought = c -> {
            if (c.coordinates.sourceId.startsWith(GENE_GROUP_PREFIX)) {
                if (!c.parentCoordinates.stream().map(termsByGeneId::get).filter(p -> p.coordinates.sourceId.startsWith(TOP_ORTHOLOGY_PREFIX)).findAny().isPresent()) return true;
            }
            if (c.coordinates.sourceId.startsWith(TOP_ORTHOLOGY_PREFIX)) return true;
            if (!c.coordinates.sourceId.startsWith("homologene")) return false;
            return true;
        };
        if (isSought.test(concept)) {
            importConcepts.add(concept);
        }
        for (ImportConcept parent : () -> concept.parentCoordinates.stream().map(termsByGeneId::get).iterator()) {
            this.findTopOrthologsAndHomologyAggregates(parent, termsByGeneId, importConcepts);
        }
        return importConcepts;
    }

    private ImportConcept findTopHomologyAggregate(ImportConcept concept, Map<ConceptCoordinates, ImportConcept> termsByGeneId) {
        ConceptCoordinates parentCoordinates;
        ImportConcept parent;
        if (concept.coordinates.sourceId.startsWith(TOP_HOMOLOGY_PREFIX)) {
            return concept;
        }
        ImportConcept topHomologyConcept = null;
        if (concept.parentCoordinates == null) {
            throw new IllegalArgumentException("The passed concept does have null parents " + concept.coordinates);
        }
        Iterator iterator = concept.parentCoordinates.iterator();
        while (iterator.hasNext() && (topHomologyConcept = this.findTopHomologyAggregate(parent = termsByGeneId.get(parentCoordinates = (ConceptCoordinates)iterator.next()), termsByGeneId)) == null) {
        }
        return topHomologyConcept;
    }

    private void createGeneOrthologyAggregates(Multimap<String, ConceptCoordinates> genes2Aggregate, File geneGroup, Map<ConceptCoordinates, ImportConcept> termsByGeneId, List<String> aggregateCopyProperties) throws IOException {
        HashMap<String, Set> geneGroupOrthologs = new HashMap<String, Set>();
        Iterator iterator = FileUtilities.getReaderFromFile((File)geneGroup).lines().iterator();
        while (iterator.hasNext()) {
            String geneGroupLine = (String)iterator.next();
            if (geneGroupLine.startsWith("#")) continue;
            String[] geneGroupRecord = geneGroupLine.split("\t");
            if (geneGroupRecord.length < 5) {
                throw new IllegalArgumentException("The line " + geneGroupLine + " does not have at least 5 tab-separated columns.");
            }
            Object relationship = geneGroupRecord[2];
            if (!((String)relationship).equals("Ortholog")) continue;
            String gene1 = ((String)geneGroupRecord[1]).intern();
            String gene2 = ((String)geneGroupRecord[4]).intern();
            geneGroupOrthologs.compute(gene1, (gene, set) -> {
                HashSet<String> newset = set;
                if (newset == null) {
                    newset = new HashSet<String>();
                }
                newset.add(gene2);
                return newset;
            });
        }
        this.log.info("Got {} orthology groups from gene_ortholog file {}", (Object)geneGroupOrthologs.size(), (Object)geneGroup);
        HashMultimap genes2OrthoAggregate = HashMultimap.create();
        for (String geneGroupId : geneGroupOrthologs.keySet()) {
            Collection mappingTargets = (Collection)geneGroupOrthologs.get(geneGroupId);
            ArrayList<String> groupGeneIds = new ArrayList<String>(mappingTargets.size() + 1);
            ArrayList<ConceptCoordinates> groupGeneCoords = new ArrayList<ConceptCoordinates>(mappingTargets.size() + 1);
            for (String geneId : mappingTargets) {
                ConceptCoordinates geneCoords = NCBIGeneConceptCreator.getGeneCoordinates(geneId);
                if (!termsByGeneId.containsKey(geneCoords)) continue;
                groupGeneIds.add(geneId);
                groupGeneCoords.add(geneCoords);
            }
            if (termsByGeneId.containsKey(NCBIGeneConceptCreator.getGeneCoordinates(geneGroupId))) {
                groupGeneIds.add(geneGroupId);
                groupGeneCoords.add(NCBIGeneConceptCreator.getGeneCoordinates(geneGroupId));
            }
            if (groupGeneCoords.size() <= 1) continue;
            ImportConcept orthologyCluster = new ImportConcept(groupGeneCoords, aggregateCopyProperties);
            orthologyCluster.coordinates = new ConceptCoordinates();
            orthologyCluster.coordinates.sourceId = (GENE_GROUP_PREFIX + geneGroupId).intern();
            orthologyCluster.coordinates.source = "GeneOrthology";
            orthologyCluster.coordinates.originalSource = "GeneOrthology";
            orthologyCluster.coordinates.originalId = geneGroupId;
            orthologyCluster.aggregateIncludeInHierarchy = true;
            orthologyCluster.generalLabels = Arrays.asList("AGGREGATE_GENEGROUP", "NO_PROCESSING_GAZETTEER");
            termsByGeneId.put(orthologyCluster.coordinates, orthologyCluster);
            ++this.orthologAggregateCounter;
            for (String geneId : groupGeneIds) {
                ImportConcept gene2 = termsByGeneId.get(NCBIGeneConceptCreator.getGeneCoordinates(geneId));
                genes2OrthoAggregate.put((Object)geneId, (Object)orthologyCluster);
                genes2Aggregate.put((Object)geneId, (Object)new ConceptCoordinates(orthologyCluster.coordinates.sourceId, orthologyCluster.coordinates.source, true));
                gene2.addParent(orthologyCluster.coordinates);
                if (groupGeneIds.size() <= 1) continue;
                gene2.addGeneralLabel(new String[]{ResourceTermLabels.Gazetteer.NO_QUERY_DICTIONARY.name(), ResourceTermLabels.Suggestions.NO_SUGGESTIONS.name()});
            }
        }
        HashMap<ConceptCoordinates, ImportConcept> orthoAgg2TopOrtho = new HashMap<ConceptCoordinates, ImportConcept>();
        for (String geneid : genes2OrthoAggregate.keySet()) {
            ImportConcept cluster2;
            Collection clusters = genes2OrthoAggregate.get((Object)geneid);
            if (clusters.size() <= 1) continue;
            ImportConcept topOrthologyAggregate = null;
            TreeSet<ImportConcept> seenOrthologyClusters = new TreeSet<ImportConcept>(Comparator.comparingLong(System::identityHashCode));
            Iterator iterator2 = clusters.iterator();
            while (iterator2.hasNext() && (topOrthologyAggregate = this.findTopOrtholog(cluster2 = (ImportConcept)iterator2.next(), seenOrthologyClusters, (Multimap<String, ImportConcept>)genes2OrthoAggregate, orthoAgg2TopOrtho)) == null) {
            }
            if (topOrthologyAggregate == null) {
                topOrthologyAggregate = new ImportConcept(new ArrayList(), aggregateCopyProperties);
                topOrthologyAggregate.coordinates = new ConceptCoordinates();
                topOrthologyAggregate.coordinates.sourceId = TOP_ORTHOLOGY_PREFIX + this.topOrthologAggregateCounter;
                topOrthologyAggregate.coordinates.source = SEMEDICO_RESOURCE_MANAGEMENT_SOURCE;
                topOrthologyAggregate.aggregateIncludeInHierarchy = true;
                topOrthologyAggregate.generalLabels = Arrays.asList("AGGREGATE_TOP_ORTHOLOGY", "NO_PROCESSING_GAZETTEER");
                termsByGeneId.put(topOrthologyAggregate.coordinates, topOrthologyAggregate);
                ++this.topOrthologAggregateCounter;
            }
            for (ImportConcept cluster2 : clusters) {
                ConceptCoordinates clusterCoordinates = cluster2.coordinates;
                if (!topOrthologyAggregate.elementCoordinates.contains(clusterCoordinates)) {
                    topOrthologyAggregate.elementCoordinates.add(clusterCoordinates);
                }
                orthoAgg2TopOrtho.put(clusterCoordinates, topOrthologyAggregate);
                cluster2.addParent(topOrthologyAggregate.coordinates);
            }
        }
    }

    private ImportConcept findTopOrtholog(ImportConcept orthologyCluster, Set<ImportConcept> seenOrthologyClusters, Multimap<String, ImportConcept> genes2OrthoAggregate, Map<ConceptCoordinates, ImportConcept> orthoAgg2TopOrtho) {
        ImportConcept topOrtholog = orthoAgg2TopOrtho.get(orthologyCluster.coordinates);
        seenOrthologyClusters.add(orthologyCluster);
        if (topOrtholog == null) {
            for (ConceptCoordinates element : orthologyCluster.elementCoordinates) {
                Collection orthologyClustersOfElement = genes2OrthoAggregate.get((Object)element.originalId);
                for (ImportConcept orthologyClusterOfElement : orthologyClustersOfElement) {
                    if (seenOrthologyClusters.contains(orthologyClusterOfElement)) continue;
                    seenOrthologyClusters.add(orthologyClusterOfElement);
                    topOrtholog = this.findTopOrtholog(orthologyClusterOfElement, seenOrthologyClusters, genes2OrthoAggregate, orthoAgg2TopOrtho);
                    if (topOrtholog == null) continue;
                    return topOrtholog;
                }
            }
        }
        return topOrtholog;
    }

    private void createHomologeneAggregates(Multimap<String, ConceptCoordinates> genes2Aggregate, File homologene, Map<ConceptCoordinates, ImportConcept> termsByGeneId, List<String> aggregateCopyProperties) throws IOException {
        Stream<HomologeneRecord> recordStream = FileUtilities.getReaderFromFile((File)homologene).lines().map(line -> line.split("\t")).map(x$0 -> new HomologeneRecord((String[])x$0));
        ImmutableListMultimap groupId2Homolo = Multimaps.index(recordStream.iterator(), r -> r.groupId);
        this.log.info("Got {} homologene records", (Object)groupId2Homolo.size());
        HashMap<String, String> genes2HomoloGroup = new HashMap<String, String>();
        for (String groupId : groupId2Homolo.keySet()) {
            Collection group = groupId2Homolo.get((Object)groupId);
            ArrayList<String> homologuousGeneIds = new ArrayList<String>(group.size());
            ArrayList<String> homologuousGeneSources = new ArrayList<String>(group.size());
            ArrayList<ConceptCoordinates> homologuousGeneCoords = new ArrayList<ConceptCoordinates>(group.size());
            for (HomologeneRecord record : group) {
                String geneId = record.geneId;
                ConceptCoordinates geneCoords = NCBIGeneConceptCreator.getGeneCoordinates(geneId);
                if (!termsByGeneId.containsKey(geneCoords)) continue;
                homologuousGeneIds.add(geneId);
                homologuousGeneSources.add(NCBI_GENE_SOURCE);
                homologuousGeneCoords.add(geneCoords);
            }
            if (homologuousGeneCoords.size() < 1) continue;
            ImportConcept aggregate = new ImportConcept(homologuousGeneCoords, aggregateCopyProperties);
            aggregate.coordinates = new ConceptCoordinates();
            aggregate.coordinates.sourceId = ("homologene" + groupId).intern();
            aggregate.coordinates.source = "Homologene";
            aggregate.coordinates.originalSource = "Homologene";
            aggregate.coordinates.originalId = groupId;
            aggregate.aggregateIncludeInHierarchy = true;
            aggregate.generalLabels = Arrays.asList("AGGREGATE_HOMOLOGENE", "NO_PROCESSING_GAZETTEER");
            termsByGeneId.put(aggregate.coordinates, aggregate);
            ++this.homologeneAggregateCounter;
            for (ConceptCoordinates geneCoords : homologuousGeneCoords) {
                String geneId = geneCoords.originalId;
                ImportConcept gene = termsByGeneId.get(geneCoords);
                if (genes2HomoloGroup.containsKey(geneId)) {
                    throw new IllegalStateException("Gene with ID " + geneId + " is taking part in multiple homologene groups.");
                }
                genes2HomoloGroup.put(geneId, groupId);
                genes2Aggregate.put((Object)geneId, (Object)new ConceptCoordinates(aggregate.coordinates.sourceId, aggregate.coordinates.source, true));
                gene.addParent(aggregate.coordinates);
                if (homologuousGeneIds.size() <= 1) continue;
                gene.addGeneralLabel(new String[]{ResourceTermLabels.Gazetteer.NO_QUERY_DICTIONARY.name(), ResourceTermLabels.Suggestions.NO_SUGGESTIONS.name()});
            }
        }
    }

    private List<ImportConcept> makeTermList(Map<ConceptCoordinates, ImportConcept> termsByGeneId) {
        ArrayList<ImportConcept> terms = new ArrayList<ImportConcept>(termsByGeneId.size());
        for (ImportConcept term : termsByGeneId.values()) {
            terms.add(term);
        }
        return terms;
    }

    private void setSpeciesQualifier(File ncbiTaxNames, Map<String, String> geneId2Tax, Collection<ImportConcept> geneTerms) throws IOException {
        String taxId;
        HashMap<String, TaxonomyRecord> taxNameRecords = new HashMap<String, TaxonomyRecord>();
        Iterator lineIt = FileUtilities.getReaderFromFile((File)ncbiTaxNames).lines().iterator();
        while (lineIt.hasNext()) {
            String recordString = (String)lineIt.next();
            String[] split = recordString.split("(\t\\|\t)|(\t\\|)");
            taxId = split[0].intern();
            String name = split[1].intern();
            String nameClass = split[3].intern();
            TaxonomyRecord record = (TaxonomyRecord)taxNameRecords.get(taxId);
            if (null == record) {
                record = new TaxonomyRecord(taxId);
                taxNameRecords.put(taxId, record);
            }
            if (nameClass.equals("scientific name")) {
                record.scientificName = name;
                continue;
            }
            if (!nameClass.equals("genbank common name")) continue;
            record.geneBankCommonName = name;
        }
        for (ImportConcept gene : geneTerms) {
            taxId = geneId2Tax.get(gene.coordinates.originalId);
            TaxonomyRecord taxonomyRecord = (TaxonomyRecord)taxNameRecords.get(taxId);
            if (null == taxonomyRecord) {
                this.log.warn("No NCBI Taxonomy name record was found for the taxonomy ID {}", (Object)taxId);
                continue;
            }
            String speciesQualifier = taxonomyRecord.scientificName;
            if (null != taxonomyRecord.geneBankCommonName) {
                speciesQualifier = speciesQualifier + (" (" + taxonomyRecord.geneBankCommonName + ")").intern();
            }
            gene.addQualifier(speciesQualifier);
            gene.displayName = gene.prefName + " [" + taxonomyRecord.scientificName;
            if (null != taxonomyRecord.geneBankCommonName) {
                gene.displayName = gene.displayName + " (" + taxonomyRecord.geneBankCommonName + ")";
            }
            gene.displayName = gene.displayName + "]";
        }
    }

    protected void convertGeneInfoToTerms(File geneInfo, File organisms, File geneDescriptions, Map<String, String> geneId2Tax, Map<ConceptCoordinates, ImportConcept> termsByGeneId) throws IOException {
        Set organismSet = FileUtilities.getReaderFromFile((File)organisms).lines().collect(Collectors.toSet());
        Iterator lineIt = FileUtilities.getReaderFromFile((File)geneDescriptions).lines().iterator();
        HashMap<String, String> gene2Summary = new HashMap<String, String>();
        while (lineIt.hasNext()) {
            String line = (String)lineIt.next();
            String[] split = line.split("\t");
            String geneId = split[0].intern();
            String summary = split[1].intern();
            gene2Summary.put(geneId, summary);
        }
        try (BufferedReader bw = FileUtilities.getReaderFromFile((File)geneInfo);){
            Iterator it = bw.lines().filter(record -> !record.startsWith("#")).iterator();
            while (it.hasNext()) {
                String record2 = (String)it.next();
                ImportConcept term = this.createGeneTerm(record2, gene2Summary);
                String[] split = record2.split("\t", 2);
                String taxId = split[0].intern();
                if (!organismSet.contains(taxId) && !organismSet.isEmpty()) continue;
                geneId2Tax.put(term.coordinates.originalId, taxId);
                termsByGeneId.put(term.coordinates, term);
            }
        }
    }

    private ImportConcept createGeneTerm(String record, Map<String, String> gene2Summary) {
        String[] split = record.split("\t");
        ArrayList<String> synonyms = new ArrayList<String>();
        String prefName = split[2];
        String fullname = split[11];
        if (prefName.length() < 3 && fullname.length() > 2) {
            prefName = fullname;
        } else {
            synonyms.add(fullname);
        }
        String ncbiDescription = split[8];
        if (prefName.length() < 3 && ncbiDescription.length() > 2) {
            prefName = ncbiDescription;
        }
        String originalId = split[1].intern();
        String synonymString = split[4];
        String otherDesignations = split[13];
        String[] synonymSplit = synonymString.split("\\|");
        for (int i = 0; i < synonymSplit.length; ++i) {
            String synonym = synonymSplit[i].intern();
            synonyms.add(synonym);
        }
        String[] otherDesignationsSplit = otherDesignations.split("\\|");
        for (int i = 0; i < otherDesignationsSplit.length; ++i) {
            String synonym = otherDesignationsSplit[i];
            synonyms.add(synonym.intern());
        }
        String description = gene2Summary.get(originalId);
        if (description != null) {
            description = description.intern();
        }
        Iterator synonymIt = synonyms.iterator();
        while (synonymIt.hasNext()) {
            if (((String)synonymIt.next()).length() >= 2) continue;
            synonymIt.remove();
        }
        ImportConcept geneTerm = new ImportConcept(prefName, synonyms, description, NCBIGeneConceptCreator.getGeneCoordinates(originalId));
        geneTerm.addGeneralLabel(new String[]{ResourceTermLabels.Gazetteer.NO_PROCESSING_GAZETTEER.toString(), ResourceTermLabels.IdMapping.ID_MAP_NCBI_GENES.toString()});
        return geneTerm;
    }

    public static ConceptCoordinates getGeneCoordinates(String originalId) {
        return new ConceptCoordinates(originalId, NCBI_GENE_SOURCE, originalId, NCBI_GENE_SOURCE);
    }

    public void exposeParameters(String basePath, HierarchicalConfiguration<ImmutableNode> template) {
        String base = ConfigurationUtilities.slash((String[])new String[]{basePath, "concepts", "creator", "configuration"});
        template.addProperty(ConfigurationUtilities.slash((String[])new String[]{basePath, "concepts", "creator", "name"}), (Object)this.getName());
        template.addProperty(ConfigurationUtilities.slash((String[])new String[]{base, BASEPATH}), (Object)"");
        template.addProperty(ConfigurationUtilities.slash((String[])new String[]{base, GENE_INFO}), (Object)"");
        template.addProperty(ConfigurationUtilities.slash((String[])new String[]{base, GENEDESCRIPTIONS}), (Object)"");
        template.addProperty(ConfigurationUtilities.slash((String[])new String[]{base, ORGANISMLIST}), (Object)"");
        template.addProperty(ConfigurationUtilities.slash((String[])new String[]{base, ORGANISMNAMES}), (Object)"");
        template.addProperty(ConfigurationUtilities.slash((String[])new String[]{base, "homologene"}), (Object)"");
        template.addProperty(ConfigurationUtilities.slash((String[])new String[]{base, GENE_GROUP}), (Object)"");
        FacetCreationService.getInstance().exposeParameters(basePath, template);
        template.setProperty(ConfigurationUtilities.slash((String[])new String[]{basePath, "facet", "creator", "configuration", "facetgroup", "name"}), (Object)"Biology");
        template.setProperty(ConfigurationUtilities.slash((String[])new String[]{basePath, "facet", "creator", "configuration", "name"}), (Object)"Genes");
        template.setProperty(ConfigurationUtilities.slash((String[])new String[]{basePath, "facet", "creator", "configuration", "sourcetype"}), (Object)"hierarchical");
    }

    public Stream<ImportConcepts> createConcepts(HierarchicalConfiguration<ImmutableNode> importConfig) throws ConceptCreationException, FacetCreationException {
        this.resetCounters();
        String confPath = ConfigurationUtilities.slash((String[])new String[]{"concepts", "creator", "configuration"});
        try {
            ConfigurationUtilities.checkParameters(importConfig, (String[])new String[]{ConfigurationUtilities.slash((String[])new String[]{confPath, GENE_INFO}), ConfigurationUtilities.slash((String[])new String[]{confPath, GENEDESCRIPTIONS}), ConfigurationUtilities.slash((String[])new String[]{confPath, ORGANISMLIST}), ConfigurationUtilities.slash((String[])new String[]{confPath, ORGANISMNAMES}), ConfigurationUtilities.slash((String[])new String[]{confPath, "homologene"}), ConfigurationUtilities.slash((String[])new String[]{confPath, GENE_GROUP})});
        }
        catch (ConfigurationException e) {
            throw new ConceptCreationException((Throwable)e);
        }
        String basepath = importConfig.getString(ConfigurationUtilities.slash((String[])new String[]{confPath, BASEPATH}), "");
        File geneInfo = this.resolvePath(basepath, importConfig.getString(ConfigurationUtilities.slash((String[])new String[]{confPath, GENE_INFO})));
        File geneDescriptions = this.resolvePath(basepath, importConfig.getString(ConfigurationUtilities.slash((String[])new String[]{confPath, GENEDESCRIPTIONS})));
        File organisms = this.resolvePath(basepath, importConfig.getString(ConfigurationUtilities.slash((String[])new String[]{confPath, ORGANISMLIST})));
        File ncbiTaxNames = this.resolvePath(basepath, importConfig.getString(ConfigurationUtilities.slash((String[])new String[]{confPath, ORGANISMNAMES})));
        File homologene = this.resolvePath(basepath, importConfig.getString(ConfigurationUtilities.slash((String[])new String[]{confPath, "homologene"})));
        File geneGroup = this.resolvePath(basepath, importConfig.getString(ConfigurationUtilities.slash((String[])new String[]{confPath, GENE_GROUP})));
        ArrayList<File> notFound = new ArrayList<File>();
        for (File f : Arrays.asList(geneInfo, geneDescriptions, organisms, ncbiTaxNames, homologene, geneGroup)) {
            if (f.exists()) continue;
            notFound.add(f);
        }
        if (!notFound.isEmpty()) {
            throw new ConceptCreationException("The following files do not exist: " + notFound.stream().map(File::getAbsolutePath).collect(Collectors.joining(System.getProperty("line.separator"))));
        }
        try {
            this.log.info("Beginning import of NCBI Genes.");
            HashMap<String, String> geneId2Tax = new HashMap<String, String>();
            HashMap<ConceptCoordinates, ImportConcept> conceptsByGeneId = new HashMap<ConceptCoordinates, ImportConcept>();
            this.log.info("Converting NCBI Gene source files into nodes for the concept graph.");
            this.convertGeneInfoToTerms(geneInfo, organisms, geneDescriptions, geneId2Tax, conceptsByGeneId);
            this.setSpeciesQualifier(ncbiTaxNames, geneId2Tax, conceptsByGeneId.values());
            this.log.info("Got {} terms from source files..", (Object)conceptsByGeneId.values().size());
            this.log.info("Creating homology aggregates");
            this.createHomologyAggregates(conceptsByGeneId, homologene, geneGroup);
            this.log.info("Created {} homology aggregates", (Object)this.homologeneAggregateCounter);
            this.log.info("Created {} orthology aggregates", (Object)this.orthologAggregateCounter);
            this.log.info("Created {} top-homology aggregates, governing homologene and orthology aggregates", (Object)this.topHomologyAggregateCounter);
            this.log.info("Got {} terms overall (genes and homology aggregates)", (Object)conceptsByGeneId.size());
            List<ImportConcept> concepts = this.makeTermList(conceptsByGeneId);
            ImportFacet facet = FacetCreationService.getInstance().createFacet(importConfig);
            ImportOptions options = new ImportOptions();
            options.createHollowAggregateElements = true;
            options.doNotCreateHollowParents = true;
            ImportConcepts importConcepts = new ImportConcepts(concepts, facet);
            importConcepts.setImportOptions(options);
            return Stream.of(importConcepts);
        }
        catch (IOException e) {
            throw new ConceptCreationException((Throwable)e);
        }
    }

    private File resolvePath(String basepath, String filepath) {
        String delimiter = !basepath.endsWith(File.separator) && !filepath.startsWith(File.separator) ? File.separator : "";
        String path = new File(filepath).isAbsolute() ? filepath : basepath + delimiter + filepath;
        return new File(path);
    }

    public String getName() {
        return "NCBIGeneConceptCreator";
    }

    private class HomologeneRecord {
        String taxId;
        String geneId;
        String groupId;

        public HomologeneRecord(String[] record) {
            this.groupId = record[0].intern();
            this.taxId = record[1].intern();
            this.geneId = record[2].intern();
        }
    }

    private class TaxonomyRecord {
        String taxId;
        String scientificName;
        String geneBankCommonName;

        public TaxonomyRecord(String taxId) {
            this.taxId = taxId.intern();
        }
    }
}

