/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.concepts.db.creators;

import de.julielab.concepts.db.core.services.FacetCreationService;
import de.julielab.concepts.db.core.spi.ConceptCreator;
import de.julielab.concepts.util.ConceptCreationException;
import de.julielab.concepts.util.FacetCreationException;
import de.julielab.java.utilities.ConfigurationUtilities;
import de.julielab.java.utilities.FileUtilities;
import de.julielab.neo4j.plugins.datarepresentation.ConceptCoordinates;
import de.julielab.neo4j.plugins.datarepresentation.ImportConcept;
import de.julielab.neo4j.plugins.datarepresentation.ImportConcepts;
import de.julielab.neo4j.plugins.datarepresentation.ImportFacet;
import de.julielab.neo4j.plugins.datarepresentation.ImportOptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HgncGroupsConceptCreator
implements ConceptCreator {
    public static final String FAMILYFILE = "familyfile";
    public static final String FAMILYALIASFILE = "familyaliasfile";
    public static final String HIERARCHYFILE = "hierarchyfile";
    public static final String GENETOGROUPMAP = "genetogroupmap";
    public static final String HGNC_SOURCE = "HGNC";
    public static final String HGNC_GROUP_LABEL = "HGNC_GROUP";
    private static final Logger log = LoggerFactory.getLogger(HgncGroupsConceptCreator.class);

    public Stream<ImportConcepts> createConcepts(HierarchicalConfiguration<ImmutableNode> importConfig) throws ConceptCreationException, FacetCreationException {
        String confPath = ConfigurationUtilities.slash((String[])new String[]{"concepts", "creator", "configuration"});
        try {
            ConfigurationUtilities.checkParameters(importConfig, (String[])new String[]{ConfigurationUtilities.slash((String[])new String[]{confPath, FAMILYFILE}), ConfigurationUtilities.slash((String[])new String[]{confPath, FAMILYALIASFILE}), ConfigurationUtilities.slash((String[])new String[]{confPath, HIERARCHYFILE}), ConfigurationUtilities.slash((String[])new String[]{confPath, GENETOGROUPMAP})});
        }
        catch (ConfigurationException e) {
            throw new ConceptCreationException((Throwable)e);
        }
        File familyFile = new File(importConfig.getString(ConfigurationUtilities.slash((String[])new String[]{confPath, FAMILYFILE})));
        File familyAliasFile = new File(importConfig.getString(ConfigurationUtilities.slash((String[])new String[]{confPath, FAMILYALIASFILE})));
        File hierarchyFile = new File(importConfig.getString(ConfigurationUtilities.slash((String[])new String[]{confPath, HIERARCHYFILE})));
        File geneToGroupMap = new File(importConfig.getString(ConfigurationUtilities.slash((String[])new String[]{confPath, GENETOGROUPMAP})));
        HashMap<String, ImportConcept> id2groupconcept = new HashMap<String, ImportConcept>();
        HashMap<String, ImportConcept> id2geneconcept = new HashMap<String, ImportConcept>();
        try {
            this.createGroupConcepts(familyFile, id2groupconcept);
            this.addGroupAliases(familyAliasFile, id2groupconcept);
            this.addGroupHierarchyRelations(hierarchyFile, id2groupconcept);
            this.addNCBIGeneLinks(geneToGroupMap, id2groupconcept, id2geneconcept);
        }
        catch (IOException e) {
            throw new ConceptCreationException((Throwable)e);
        }
        ImportFacet facet = FacetCreationService.getInstance().createFacet(importConfig);
        ImportOptions options = new ImportOptions();
        options.createHollowAggregateElements = true;
        options.doNotCreateHollowParents = false;
        ImportConcepts importConcepts = new ImportConcepts(Stream.concat(id2groupconcept.values().stream(), id2geneconcept.values().stream()), facet);
        importConcepts.setNumConcepts((long)(id2groupconcept.size() + id2geneconcept.size()));
        log.info("Created a total of {} concepts where {} concepts are gene groups and {} are genes identified by NCBI Gene ID.", new Object[]{importConcepts.getNumConcepts(), id2groupconcept.size(), id2geneconcept.size()});
        importConcepts.setImportOptions(options);
        return Stream.of(importConcepts);
    }

    private void addNCBIGeneLinks(File geneToGroupMap, Map<String, ImportConcept> id2concept, Map<String, ImportConcept> id2geneconcept) throws IOException {
        try (BufferedReader br = FileUtilities.getReaderFromFile((File)geneToGroupMap);){
            CSVParser parse = CSVFormat.Builder.create((CSVFormat)CSVFormat.RFC4180).setHeader(new String[0]).setSkipHeaderRecord(true).setDelimiter('\t').build().parse((Reader)br);
            for (CSVRecord record : parse) {
                String finalNcbiGeneId;
                String hgncId = record.get("HGNC ID");
                String ncbiGeneIdFromNCBI = record.get("NCBI Gene ID(supplied by NCBI)");
                String ncbiGeneId = record.get("NCBI Gene ID");
                String geneGroupIds = record.get("Gene group ID");
                String string = finalNcbiGeneId = ncbiGeneId.isBlank() ? ncbiGeneIdFromNCBI : ncbiGeneId;
                if (geneGroupIds.isBlank() || finalNcbiGeneId.isBlank()) continue;
                ImportConcept concept = new ImportConcept(new ConceptCoordinates(finalNcbiGeneId, "NCBI Gene", finalNcbiGeneId, "NCBI Gene"));
                concept.additionalProperties = new HashMap();
                concept.additionalProperties.put("hgnc_id", hgncId);
                for (String geneGroupId : geneGroupIds.split("\\|")) {
                    ImportConcept groupConcept = id2concept.get(geneGroupId);
                    if (groupConcept == null) {
                        throw new IllegalStateException("Inconsistent input data: the gene to group map file defines the group ID " + geneGroupId + " but this ID is not contained in the family file.");
                    }
                    concept.addParent(groupConcept.coordinates);
                }
                id2geneconcept.put(finalNcbiGeneId, concept);
            }
        }
    }

    private void addGroupHierarchyRelations(File hierarchyFile, Map<String, ImportConcept> id2concept) throws IOException {
        try (BufferedReader br = FileUtilities.getReaderFromFile((File)hierarchyFile);){
            CSVParser parse = this.getCsvParserWithHeader(br);
            for (CSVRecord record : parse) {
                String parentFamId = record.get("parent_fam_id");
                String childId = record.get("child_fam_id");
                ImportConcept parentConcept = id2concept.get(parentFamId);
                if (parentConcept == null) {
                    throw new IllegalStateException("Inconsistent input data: the hierarchy file defines the parent group ID " + parentFamId + " but this ID is not contained in the family file.");
                }
                ImportConcept childConcept = id2concept.get(childId);
                if (childConcept == null) {
                    throw new IllegalStateException("Inconsistent input data: the hierarchy file defines the child group ID " + parentFamId + " but this ID is not contained in the family file.");
                }
                if (childConcept.parentCoordinates.isEmpty()) {
                    childConcept.parentCoordinates = new ArrayList();
                }
                childConcept.parentCoordinates.add(parentConcept.coordinates);
            }
        }
    }

    private void addGroupAliases(File familyAliasFile, Map<String, ImportConcept> id2concept) throws IOException {
        try (BufferedReader br = FileUtilities.getReaderFromFile((File)familyAliasFile);){
            CSVParser parse = this.getCsvParserWithHeader(br);
            for (CSVRecord record : parse) {
                String familyId = record.get("family_id");
                String alias = record.get("alias").trim();
                ImportConcept concept = id2concept.get(familyId);
                if (concept == null) {
                    throw new IllegalStateException("Inconsistent input data: The family alias file contains an alias for gene group " + familyId + " but this group was not contained in the family file.");
                }
                if (concept.synonyms.isEmpty()) {
                    concept.synonyms = new ArrayList();
                }
                concept.synonyms.add(alias);
            }
        }
    }

    private void createGroupConcepts(File familyFile, Map<String, ImportConcept> id2concept) throws IOException {
        try (BufferedReader br = FileUtilities.getReaderFromFile((File)familyFile);){
            CSVParser parse = this.getCsvParserWithHeader(br);
            for (CSVRecord record : parse) {
                String groupId = record.get("id");
                String abbreviation = record.get("abbreviation");
                String groupName = record.get("name");
                String externalNote = record.get("external_note");
                String descComment = record.get("desc_comment");
                ImportConcept concept = new ImportConcept(new ConceptCoordinates(groupId, HGNC_SOURCE, groupId, HGNC_SOURCE));
                concept.addGeneralLabel(new String[]{HGNC_GROUP_LABEL});
                if (abbreviation.isBlank()) {
                    concept.prefName = groupName;
                } else {
                    concept.prefName = abbreviation;
                    concept.synonyms = new ArrayList();
                    concept.synonyms.add(groupName);
                }
                concept.descriptions = new ArrayList();
                if (!externalNote.isBlank() && !"NULL".equalsIgnoreCase(externalNote)) {
                    concept.descriptions.add(externalNote);
                }
                if (!descComment.isBlank() && !"NULL".equalsIgnoreCase(descComment)) {
                    concept.descriptions.add(descComment);
                }
                id2concept.put(groupId, concept);
            }
        }
    }

    private CSVParser getCsvParserWithHeader(BufferedReader br) throws IOException {
        return CSVFormat.Builder.create((CSVFormat)CSVFormat.RFC4180).setHeader(new String[0]).setSkipHeaderRecord(true).build().parse((Reader)br);
    }

    public String getName() {
        return HgncGroupsConceptCreator.class.getSimpleName();
    }

    public void exposeParameters(String basePath, HierarchicalConfiguration<ImmutableNode> template) {
        String base = ConfigurationUtilities.slash((String[])new String[]{basePath, "concepts", "creator", "configuration"});
        template.addProperty(ConfigurationUtilities.slash((String[])new String[]{basePath, "concepts", "creator", "name"}), (Object)this.getName());
        template.addProperty(ConfigurationUtilities.slash((String[])new String[]{base, FAMILYFILE}), (Object)"");
        template.addProperty(ConfigurationUtilities.slash((String[])new String[]{base, HIERARCHYFILE}), (Object)"");
        template.addProperty(ConfigurationUtilities.slash((String[])new String[]{base, GENETOGROUPMAP}), (Object)"");
        FacetCreationService.getInstance().exposeParameters(basePath, template);
        template.setProperty(ConfigurationUtilities.slash((String[])new String[]{basePath, "facet", "creator", "configuration", "facetgroup", "name"}), (Object)"Biology");
        template.setProperty(ConfigurationUtilities.slash((String[])new String[]{basePath, "facet", "creator", "configuration", "name"}), (Object)"Protein Complexes");
        template.setProperty(ConfigurationUtilities.slash((String[])new String[]{basePath, "facet", "creator", "configuration", "sourcetype"}), (Object)"hierarchical");
    }
}

