/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.concepts.db.creators;

import de.julielab.concepts.db.core.services.FacetCreationService;
import de.julielab.concepts.db.core.spi.ConceptCreator;
import de.julielab.concepts.util.ConceptCreationException;
import de.julielab.concepts.util.FacetCreationException;
import de.julielab.java.utilities.ConfigurationUtilities;
import de.julielab.java.utilities.FileUtilities;
import de.julielab.neo4j.plugins.datarepresentation.ConceptCoordinates;
import de.julielab.neo4j.plugins.datarepresentation.ImportConcept;
import de.julielab.neo4j.plugins.datarepresentation.ImportConceptRelationship;
import de.julielab.neo4j.plugins.datarepresentation.ImportConcepts;
import de.julielab.neo4j.plugins.datarepresentation.ImportFacet;
import de.julielab.neo4j.plugins.datarepresentation.ImportOptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FamPlexConceptCreator
implements ConceptCreator {
    public static final String RELATIONSFILE = "relationsfile";
    public static final String GROUNDINGMAP = "groundingmap";
    public static final String NAMEEXTENSIONRECORDS = "nameextensionrecords";
    public static final String LABEL_FAMPLEX = "FPLX";
    private static final Logger log = LoggerFactory.getLogger(FamPlexConceptCreator.class);

    public Stream<ImportConcepts> createConcepts(HierarchicalConfiguration<ImmutableNode> importConfig) throws ConceptCreationException, FacetCreationException {
        String confPath = ConfigurationUtilities.slash((String[])new String[]{"concepts", "creator", "configuration"});
        try {
            ConfigurationUtilities.checkParameters(importConfig, (String[])new String[]{ConfigurationUtilities.slash((String[])new String[]{confPath, RELATIONSFILE}), ConfigurationUtilities.slash((String[])new String[]{confPath, GROUNDINGMAP}), ConfigurationUtilities.slash((String[])new String[]{confPath, NAMEEXTENSIONRECORDS})});
        }
        catch (ConfigurationException e) {
            throw new ConceptCreationException((Throwable)e);
        }
        File relationsFile = new File(importConfig.getString(ConfigurationUtilities.slash((String[])new String[]{confPath, RELATIONSFILE})));
        File groundingMap = new File(importConfig.getString(ConfigurationUtilities.slash((String[])new String[]{confPath, GROUNDINGMAP})));
        File nameextensionRecords = new File(importConfig.getString(ConfigurationUtilities.slash((String[])new String[]{confPath, NAMEEXTENSIONRECORDS})));
        HashMap<String, ImportConcept> conceptsById = new HashMap<String, ImportConcept>();
        try {
            this.addConceptsFromNameExtensionRecords(conceptsById, nameextensionRecords);
            this.addConceptsFromFamplexRelationsFile(conceptsById, relationsFile);
            this.addConceptsFromFamplexGroundingMap(conceptsById, groundingMap);
        }
        catch (IOException e) {
            throw new ConceptCreationException((Throwable)e);
        }
        ImportFacet facet = FacetCreationService.getInstance().createFacet(importConfig);
        ImportOptions options = new ImportOptions();
        options.createHollowAggregateElements = true;
        options.doNotCreateHollowParents = false;
        ImportConcepts importConcepts = new ImportConcepts(conceptsById.values().stream(), facet);
        importConcepts.setNumConcepts((long)conceptsById.size());
        log.info("Created a total of {} concepts.", (Object)importConcepts.getNumConcepts());
        importConcepts.setImportOptions(options);
        return Stream.of(importConcepts);
    }

    private void addConceptsFromNameExtensionRecords(Map<String, ImportConcept> conceptsById, File nameExtensionFile) throws IOException {
        try (BufferedReader br = FileUtilities.getReaderFromFile((File)nameExtensionFile);){
            String line;
            HashMap<String, String> currentRecord = new HashMap<String, String>();
            while ((line = br.readLine()) != null) {
                String[] split;
                if (line.isBlank()) {
                    if (!currentRecord.isEmpty()) {
                        this.addExtendedNamesToConcept(conceptsById, currentRecord);
                    }
                    currentRecord.clear();
                }
                if ((split = line.split("\t")).length <= 1) continue;
                currentRecord.put(split[0], split[1]);
            }
            if (!currentRecord.isEmpty()) {
                this.addExtendedNamesToConcept(conceptsById, currentRecord);
            }
        }
    }

    private void addExtendedNamesToConcept(Map<String, ImportConcept> conceptsById, Map<String, String> currentRecord) {
        List bases = null;
        List inflections = Collections.emptyList();
        List acronyms = Collections.emptyList();
        List abbreviations = Collections.emptyList();
        List spellings = Collections.emptyList();
        Optional<Object> famplexId = Optional.empty();
        for (String key : currentRecord.keySet()) {
            if (key.startsWith("bases")) {
                bases = Arrays.stream(currentRecord.get(key).split(", ")).collect(Collectors.toList());
                continue;
            }
            if (key.startsWith("inflections")) {
                inflections = Arrays.stream(currentRecord.get(key).split(", ")).collect(Collectors.toList());
                continue;
            }
            if (key.startsWith("spellings")) {
                spellings = Arrays.stream(currentRecord.get(key).split(", ")).collect(Collectors.toList());
                continue;
            }
            if (key.startsWith("acronyms")) {
                acronyms = Arrays.stream(currentRecord.get(key).split(", ")).collect(Collectors.toList());
                continue;
            }
            if (key.startsWith("abbreviations")) {
                abbreviations = Arrays.stream(currentRecord.get(key).split(", ")).collect(Collectors.toList());
                continue;
            }
            if (!key.startsWith("externalids")) continue;
            famplexId = Arrays.stream(currentRecord.get(key).split(", ")).filter(id -> id.startsWith("FPLX:")).findAny();
        }
        if (famplexId.isPresent()) {
            String id2 = ((String)famplexId.get()).split(":")[1];
            ImportConcept famplexConcept = conceptsById.compute(id2, (k, v) -> v != null ? v : new ImportConcept(new ConceptCoordinates(id2, LABEL_FAMPLEX, id2, LABEL_FAMPLEX)));
            this.addNodeLabel(famplexConcept, LABEL_FAMPLEX);
            if (famplexConcept.prefName == null) {
                famplexConcept.prefName = (String)bases.get(0);
                bases.remove(0);
            }
            if (famplexConcept.synonyms.isEmpty()) {
                famplexConcept.synonyms = new ArrayList();
            }
            famplexConcept.synonyms.addAll(bases);
            famplexConcept.synonyms.addAll(acronyms);
            famplexConcept.synonyms.addAll(abbreviations);
            famplexConcept.synonyms = famplexConcept.synonyms.stream().distinct().collect(Collectors.toList());
            if (famplexConcept.writingVariants.isEmpty()) {
                famplexConcept.writingVariants = new ArrayList();
            }
            famplexConcept.writingVariants.addAll(inflections);
            famplexConcept.writingVariants.addAll(spellings);
            famplexConcept.writingVariants = famplexConcept.writingVariants.stream().distinct().collect(Collectors.toList());
        }
    }

    private void addConceptsFromFamplexGroundingMap(Map<String, ImportConcept> conceptsById, File groundingMap) throws IOException {
        try (BufferedReader br = FileUtilities.getReaderFromFile((File)groundingMap);){
            String line;
            while ((line = br.readLine()) != null) {
                String[] split = line.split("\t");
                String fplxSource = split[1];
                if (!fplxSource.equals(LABEL_FAMPLEX)) continue;
                String synonym = split[0];
                String fplxId = split[2];
                ImportConcept famplexConcept = conceptsById.compute(fplxId, (k, v) -> v != null ? v : new ImportConcept(new ConceptCoordinates(fplxId, fplxSource, fplxId, fplxSource)));
                this.addNodeLabel(famplexConcept, LABEL_FAMPLEX);
                if (famplexConcept.synonyms.isEmpty()) {
                    famplexConcept.synonyms = new ArrayList();
                }
                famplexConcept.synonyms.add(synonym);
                if (famplexConcept.prefName != null) continue;
                famplexConcept.prefName = fplxId;
            }
        }
    }

    private void addConceptsFromFamplexRelationsFile(Map<String, ImportConcept> conceptsById, File relationsFile) throws IOException {
        try (BufferedReader br = FileUtilities.getReaderFromFile((File)relationsFile);){
            String line;
            while ((line = br.readLine()) != null) {
                String[] split = line.split("\t");
                String sourceIdSource = split[0].equals("EG") ? "NCBI Gene" : split[0];
                String sourceId = split[1];
                String relation = split[2];
                String fplxSource = split[3];
                String fplxId = split[4];
                if (!fplxSource.equals(LABEL_FAMPLEX)) {
                    log.warn("Omitting non-FamPlex ID mapping target line {}", (Object)line);
                    continue;
                }
                ImportConcept sourceConcept = conceptsById.compute(sourceId, (k, v) -> v != null ? v : new ImportConcept(new ConceptCoordinates(sourceId, sourceIdSource, sourceId, sourceIdSource)));
                if (sourceIdSource.equals(LABEL_FAMPLEX)) {
                    this.addNodeLabel(sourceConcept, LABEL_FAMPLEX);
                }
                ImportConcept famplexConcept = conceptsById.compute(fplxId, (k, v) -> v != null ? v : new ImportConcept(new ConceptCoordinates(fplxId, fplxSource, fplxId, fplxSource)));
                if (famplexConcept.prefName == null) {
                    famplexConcept.prefName = fplxId;
                }
                this.addNodeLabel(famplexConcept, LABEL_FAMPLEX);
                sourceConcept.addParent(famplexConcept.coordinates);
                sourceConcept.addRelationship(new ImportConceptRelationship(famplexConcept.coordinates, relation));
            }
        }
    }

    private void addNodeLabel(ImportConcept famplexConcept, String label) {
        if (famplexConcept.generalLabels == null || !famplexConcept.generalLabels.contains(LABEL_FAMPLEX)) {
            famplexConcept.addGeneralLabel(new String[]{LABEL_FAMPLEX});
        }
    }

    public String getName() {
        return FamPlexConceptCreator.class.getSimpleName();
    }

    public void exposeParameters(String basePath, HierarchicalConfiguration<ImmutableNode> template) {
        String base = ConfigurationUtilities.slash((String[])new String[]{basePath, "concepts", "creator", "configuration"});
        template.addProperty(ConfigurationUtilities.slash((String[])new String[]{basePath, "concepts", "creator", "name"}), (Object)this.getName());
        template.addProperty(ConfigurationUtilities.slash((String[])new String[]{base, RELATIONSFILE}), (Object)"");
        template.addProperty(ConfigurationUtilities.slash((String[])new String[]{base, GROUNDINGMAP}), (Object)"");
        template.addProperty(ConfigurationUtilities.slash((String[])new String[]{base, NAMEEXTENSIONRECORDS}), (Object)"");
        FacetCreationService.getInstance().exposeParameters(basePath, template);
        template.setProperty(ConfigurationUtilities.slash((String[])new String[]{basePath, "facet", "creator", "configuration", "facetgroup", "name"}), (Object)"Biology");
        template.setProperty(ConfigurationUtilities.slash((String[])new String[]{basePath, "facet", "creator", "configuration", "name"}), (Object)"Protein Complexes");
        template.setProperty(ConfigurationUtilities.slash((String[])new String[]{basePath, "facet", "creator", "configuration", "sourcetype"}), (Object)"hierarchical");
    }
}

