/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.concepts.db.creators;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import de.julielab.bioportal.ontologies.data.MappedClass;
import de.julielab.bioportal.ontologies.data.OntologyClassMapping;
import de.julielab.bioportal.util.BioPortalToolUtils;
import de.julielab.concepts.db.core.spi.MappingCreator;
import de.julielab.concepts.util.ConceptDBManagerRuntimeException;
import de.julielab.concepts.util.ConceptDatabaseConnectionException;
import de.julielab.concepts.util.MappingCreationException;
import de.julielab.java.utilities.ConfigurationUtilities;
import de.julielab.java.utilities.FileUtilities;
import de.julielab.neo4j.plugins.datarepresentation.ImportMapping;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JulielabBioPortalToolsMappingCreator
implements MappingCreator {
    public static final String ALLOWED_ACRONYMS = "allowedacronyms";
    private static final Logger log = LoggerFactory.getLogger(JulielabBioPortalToolsMappingCreator.class);

    public void exposeParameters(String basePath, HierarchicalConfiguration<ImmutableNode> template) {
        template.addProperty(ConfigurationUtilities.slash((String[])new String[]{basePath, "mappings", "creator", "name"}), (Object)this.getName());
        template.addProperty(ConfigurationUtilities.slash((String[])new String[]{basePath, "mappings", "creator", "configuration", "path"}), (Object)"");
        template.addProperty(ConfigurationUtilities.slash((String[])new String[]{basePath, "mappings", "creator", "configuration", ALLOWED_ACRONYMS}), (Object)"");
    }

    public Stream<ImportMapping> createMappings(HierarchicalConfiguration<ImmutableNode> importConfig) throws MappingCreationException {
        try {
            ConfigurationUtilities.checkParameters(importConfig, (String[])new String[]{ConfigurationUtilities.slash((String[])new String[]{"mappings", "creator", "configuration", "path"}), ConfigurationUtilities.slash((String[])new String[]{"mappings", "creator", "configuration", ALLOWED_ACRONYMS})});
            ConfigurationUtilities.checkFilesExist(importConfig, (String[])new String[]{ConfigurationUtilities.slash((String[])new String[]{"mappings", "creator", "configuration", "path"})});
            String pathToMappings = importConfig.getString(ConfigurationUtilities.slash((String[])new String[]{"mappings", "creator", "configuration", "path"}));
            HashSet allowedAcronyms = new HashSet(importConfig.getList(ConfigurationUtilities.slash((String[])new String[]{"mappings", "creator", "configuration", ALLOWED_ACRONYMS})));
            log.info("Importing mappings from {}{}", (Object)pathToMappings, (Object)(allowedAcronyms != null && !allowedAcronyms.isEmpty() ? " for acronyms " + allowedAcronyms : ""));
            File file = new File(pathToMappings);
            Stream<ImportMapping> mappings = Stream.empty();
            if (file.isFile()) {
                log.info("Found mapping file \"{}\", processing...", (Object)file.getAbsolutePath());
                return this.readMappingFile(file).stream();
            }
            File[] files = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".map.json") || name.endsWith(".map.json.gz");
                }
            });
            log.info("Got directory with {} mapping files.", (Object)(files != null ? files.length : 0));
            ((Stream)Stream.of(files).parallel()).filter(mappingFile -> {
                String acronym = BioPortalToolUtils.getAcronymFromFileName((File)mappingFile);
                if (null != allowedAcronyms && !allowedAcronyms.isEmpty() && !allowedAcronyms.contains(acronym)) {
                    log.debug("Skipping mappings for ontology with acronym {} because it is not contained in the set of allowed acronyms.", (Object)acronym);
                    return false;
                }
                return true;
            }).flatMap(mappingFile -> {
                log.info("Processing mapping file {}", (Object)mappingFile.getAbsolutePath());
                try {
                    return this.readMappingFile((File)mappingFile).stream();
                }
                catch (IOException e) {
                    throw new ConceptDBManagerRuntimeException((Throwable)e);
                }
            });
            return mappings;
        }
        catch (ConfigurationException e) {
            throw new MappingCreationException((Throwable)e);
        }
        catch (IOException e) {
            throw new MappingCreationException((Throwable)e);
        }
    }

    private List<ImportMapping> readMappingFile(File file) throws IOException {
        Gson gson = new Gson();
        BufferedReader reader = FileUtilities.getReaderFromFile((File)file);
        Type mappingListType = new TypeToken<List<OntologyClassMapping>>(){}.getType();
        List mappings = (List)gson.fromJson((Reader)reader, mappingListType);
        ArrayList<ImportMapping> importMappings = new ArrayList<ImportMapping>(mappings.size());
        for (OntologyClassMapping mapping : mappings) {
            String type = mapping.source;
            if (mapping.process != null) continue;
            if (null == type) {
                throw new IllegalArgumentException("Could not find the mapping type for mapping " + mapping);
            }
            if (type.equals("SAME_URI")) continue;
            if (mapping.classes.size() != 2) {
                throw new IllegalArgumentException("Mapping occurred that does not map exactly two classes " + mapping);
            }
            String id1 = ((MappedClass)mapping.classes.get((int)0)).id;
            String id2 = ((MappedClass)mapping.classes.get((int)1)).id;
            ImportMapping importMapping = new ImportMapping(id1, id2, type);
            importMappings.add(importMapping);
        }
        log.info("Importing {} mappings after filtering unwanted mapping types like SAME_URI and user-defined mappings (for the time being).", (Object)importMappings.size());
        return importMappings;
    }

    public void setConnection(HierarchicalConfiguration<ImmutableNode> connectionConfiguration) throws ConceptDatabaseConnectionException {
    }

    public String getName() {
        return "JulielabBioPortalToolsMappingCreator";
    }
}

