/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.concepts.db.creators;

import com.google.gson.Gson;
import de.julielab.bioportal.ontologies.data.OntologyClass;
import de.julielab.bioportal.util.BioPortalToolUtils;
import de.julielab.concepts.db.core.spi.ConceptCreator;
import de.julielab.concepts.util.ConceptCreationException;
import de.julielab.concepts.util.ConceptDBManagerRuntimeException;
import de.julielab.java.utilities.ConfigurationUtilities;
import de.julielab.java.utilities.FileUtilities;
import de.julielab.neo4j.plugins.datarepresentation.ConceptCoordinates;
import de.julielab.neo4j.plugins.datarepresentation.ImportConcept;
import de.julielab.neo4j.plugins.datarepresentation.ImportConcepts;
import de.julielab.neo4j.plugins.datarepresentation.ImportFacet;
import de.julielab.neo4j.plugins.datarepresentation.ImportFacetGroup;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JulielabBioPortalToolsConceptCreator
implements ConceptCreator {
    private static final Logger log = LoggerFactory.getLogger(JulielabBioPortalToolsConceptCreator.class);

    public Stream<ImportConcepts> createConcepts(HierarchicalConfiguration<ImmutableNode> config) throws ConceptCreationException {
        String facetGroupNameKey = ConfigurationUtilities.slash((String[])new String[]{"facet", "creator", "configuration", "facetgroup", "name"});
        String ontologiesPathKey = ConfigurationUtilities.slash((String[])new String[]{"concepts", "creator", "configuration", "path"});
        try {
            ConfigurationUtilities.checkParameters(config, (String[])new String[]{facetGroupNameKey, ontologiesPathKey});
            ConfigurationUtilities.checkFilesExist(config, (String[])new String[]{ontologiesPathKey});
        }
        catch (ConfigurationException e) {
            throw new ConceptCreationException((Throwable)e);
        }
        String facetGroupName = config.getString(facetGroupNameKey);
        File ontologyNamesPath = new File(config.getString(ontologiesPathKey));
        Gson gson = new Gson();
        File[] ontologyNameFiles = ontologyNamesPath.isDirectory() ? ontologyNamesPath.listFiles((f, n) -> n.endsWith(".jsonlst") || n.endsWith(".jsonlst.gz")) : new File[]{ontologyNamesPath};
        log.info("Reading {} ontology class files for concept creation.", (Object)ontologyNameFiles.length);
        return Stream.of(ontologyNameFiles).map(f -> {
            try {
                String acronym = BioPortalToolUtils.getAcronymFromFileName((File)f);
                BufferedReader br = FileUtilities.getReaderFromFile((File)f);
                Stream<OntologyClass> classStream = br.lines().map(l -> (OntologyClass)gson.fromJson(l, OntologyClass.class));
                Stream<ImportConcept> conceptStream = classStream.map(c -> {
                    List parentCoordinates = Collections.emptyList();
                    if (c.parents != null && c.parents.parents != null) {
                        parentCoordinates = c.parents.parents.stream().map(p -> new ConceptCoordinates(p, acronym, true)).collect(Collectors.toList());
                    }
                    return new ImportConcept(c.prefLabel, c.synonym.synonyms, c.definition, new ConceptCoordinates(c.id, acronym, true), parentCoordinates);
                });
                ImportFacetGroup fg = new ImportFacetGroup(facetGroupName);
                ImportFacet facet = new ImportFacet(fg, acronym, acronym, acronym, "hierarchical");
                boolean noFacet = config.getBoolean(ConfigurationUtilities.slash((String[])new String[]{"facet", "creator", "configuration", "nofacet"}), false);
                facet.setNoFacet(noFacet);
                String[] labels = config.getStringArray(ConfigurationUtilities.slash((String[])new String[]{"facet", "creator", "configuration", "labels"}));
                if (labels != null && labels.length > 0) {
                    facet.setLabels(Arrays.asList(labels));
                }
                return new ImportConcepts(conceptStream, facet);
            }
            catch (IOException e) {
                throw new ConceptDBManagerRuntimeException((Throwable)new ConceptCreationException((Throwable)e));
            }
        });
    }

    public void exposeParameters(String basePath, HierarchicalConfiguration<ImmutableNode> template) {
        template.addProperty(ConfigurationUtilities.slash((String[])new String[]{basePath, "concepts", "creator", "name"}), (Object)this.getName());
        template.addProperty(ConfigurationUtilities.slash((String[])new String[]{basePath, "concepts", "creator", "configuration", "path"}), (Object)"");
        template.setProperty(ConfigurationUtilities.slash((String[])new String[]{basePath, "facet", "creator", "configuration", "facetgroup", "name"}), (Object)"Ontologies");
        template.setProperty(ConfigurationUtilities.slash((String[])new String[]{basePath, "facet", "creator", "configuration", "labels"}), (Object)"");
    }

    public String getName() {
        return "JulielabBioPortalToolsConceptCreator";
    }
}

