/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.bioportal.ontologies;

import com.google.common.io.Files;
import de.julielab.bioportal.util.BioPortalToolUtils;
import de.julielab.java.utilities.FileUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.MissingImportListener;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.AutoIRIMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologyLoader {
    private static final Logger log = LoggerFactory.getLogger(OntologyLoader.class);
    private OWLOntologyManager ontologyManager = OWLManager.createOWLOntologyManager();

    public OntologyLoader() {
        OWLOntologyLoaderConfiguration config = new OWLOntologyLoaderConfiguration();
        config = config.setMissingImportHandlingStrategy(MissingImportHandlingStrategy.SILENT);
        this.ontologyManager.setOntologyLoaderConfiguration(config);
        this.ontologyManager.addMissingImportListener((MissingImportListener & Serializable)event -> log.warn("An exception concerning the ontology import of {} was thrown: {}; Extracted class names will not include classes from that ontology.", (Object)event.getImportedOntologyURI(), (Object)event.getCreationException().getMessage()));
    }

    public OWLOntologyManager getOntologyManager() {
        return this.ontologyManager;
    }

    public OWLOntology loadOntology(InputStream is) throws OWLOntologyCreationException {
        return this.ontologyManager.loadOntologyFromOntologyDocument(is);
    }

    public File getMainOntologyFile(File directory) throws IOException {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory.getAbsolutePath() + " is not a directory.");
        }
        File downloadFileNameFile = new File(directory.getAbsolutePath() + File.separator + "downloadFileName.txt");
        String lcdfn = Files.toString((File)downloadFileNameFile, (Charset)Charset.forName("UTF-8")).toLowerCase();
        String noextension = lcdfn.substring(0, lcdfn.indexOf(46));
        File[] files = directory.listFiles(f -> f.getName().toLowerCase().startsWith(noextension));
        if (files.length == 1) {
            if (files[0].isDirectory()) {
                files = files[0].listFiles(f -> f.getName().toLowerCase().startsWith(noextension));
                if ((files = (File[])Arrays.stream(files).filter(BioPortalToolUtils::isSupportedOntologyFile).toArray(File[]::new)).length == 1) {
                    return files[0];
                }
                throw new FileNotFoundException("The main file to load from directory " + directory.getAbsolutePath() + " could not be identified. There were " + files.length + " candidates: " + Stream.of(files).map(f -> f.getAbsolutePath()).collect(Collectors.joining(", ")));
            }
            return files[0];
        }
        throw new FileNotFoundException("The main file to load from directory " + directory.getAbsolutePath() + " could not be identified. There were " + files.length + " candidates: " + Stream.of(files).map(f -> f.getAbsolutePath()).collect(Collectors.joining(", ")));
    }

    public OWLOntology loadOntology(File file) throws OWLOntologyCreationException {
        OWLOntology o;
        if (file.isDirectory()) {
            OWLOntology o2;
            AutoIRIMapper autoIRIMapper = new AutoIRIMapper(file, true);
            this.ontologyManager.getIRIMappers().add((Serializable)autoIRIMapper);
            try {
                o2 = this.loadOntology(this.getMainOntologyFile(file));
            }
            catch (IOException e) {
                throw new OWLOntologyCreationException((Throwable)e);
            }
            finally {
                this.ontologyManager.getIRIMappers().remove((Serializable)autoIRIMapper);
            }
            return o2;
        }
        try {
            log.debug("Loading ontology file {}", (Object)file);
            o = this.loadOntology(FileUtilities.getInputStreamFromFile((File)file));
        }
        catch (IOException e) {
            throw new OWLOntologyCreationException((Throwable)e);
        }
        return o;
    }

    public void clearLoadedOntologies() {
        this.ontologyManager.clearOntologies();
    }

    public void removeOntology(OWLOntologyID ontologyID) {
        if (this.ontologyManager.getOntology(ontologyID) != null) {
            log.debug("Removing ontology with IRI {}, version {} from OWLOntologyManager.", (Object)ontologyID.getOntologyIRI().toString(), (Object)ontologyID.getOntologyIRI());
            this.ontologyManager.removeOntology(ontologyID);
        }
    }
}

