/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLClassImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryInternalsImplNoCache;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLNamedIndividualImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyImpl;

public class OWLDataFactoryInternalsImpl
extends OWLDataFactoryInternalsImplNoCache {
    private static Logger logger = LoggerFactory.getLogger(OWLDataFactoryInternalsImpl.class);
    private final AtomicInteger annotationsCount = new AtomicInteger(0);
    private final transient LoadingCache<OWLAnnotation, OWLAnnotation> annotations = OWLDataFactoryInternalsImpl.builder(key -> key);
    private final LoadingCache<IRI, OWLClass> classes = OWLDataFactoryInternalsImpl.builder(key -> new OWLClassImpl((IRI)key));
    private final LoadingCache<IRI, OWLObjectProperty> objectProperties = OWLDataFactoryInternalsImpl.builder(key -> new OWLObjectPropertyImpl((IRI)key));
    private final LoadingCache<IRI, OWLDataProperty> dataProperties = OWLDataFactoryInternalsImpl.builder(key -> new OWLDataPropertyImpl((IRI)key));
    private final LoadingCache<IRI, OWLDatatype> datatypes = OWLDataFactoryInternalsImpl.builder(key -> new OWLDatatypeImpl((IRI)key));
    private final LoadingCache<IRI, OWLNamedIndividual> individuals = OWLDataFactoryInternalsImpl.builder(key -> new OWLNamedIndividualImpl((IRI)key));
    private final LoadingCache<IRI, OWLAnnotationProperty> annotationProperties = OWLDataFactoryInternalsImpl.builder(key -> new OWLAnnotationPropertyImpl((IRI)key));

    public OWLDataFactoryInternalsImpl(boolean useCompression) {
        super(useCompression);
    }

    private static <F, T> LoadingCache<F, T> builder(CacheLoader<F, T> f) {
        Caffeine<Object, Object> builder = Caffeine.newBuilder().maximumSize(1024L).expireAfterAccess(5L, TimeUnit.MINUTES);
        if (logger.isDebugEnabled()) {
            builder.recordStats();
        }
        return builder.build(f);
    }

    @Override
    public OWLClass getOWLClass(IRI iri) {
        return this.classes.get(iri);
    }

    @Override
    public void purge() {
        this.classes.invalidateAll();
        this.objectProperties.invalidateAll();
        this.dataProperties.invalidateAll();
        this.datatypes.invalidateAll();
        this.individuals.invalidateAll();
        this.annotationProperties.invalidateAll();
        this.annotations.invalidateAll();
    }

    @Override
    public OWLObjectProperty getOWLObjectProperty(IRI iri) {
        return this.objectProperties.get(iri);
    }

    @Override
    public OWLDataProperty getOWLDataProperty(IRI iri) {
        return this.dataProperties.get(iri);
    }

    @Override
    public OWLNamedIndividual getOWLNamedIndividual(IRI iri) {
        return this.individuals.get(iri);
    }

    @Override
    public OWLDatatype getOWLDatatype(IRI iri) {
        return this.datatypes.get(iri);
    }

    @Override
    public OWLAnnotationProperty getOWLAnnotationProperty(IRI iri) {
        return this.annotationProperties.get(iri);
    }

    @Override
    public OWLLiteral getOWLLiteral(String literal, @Nullable String lang) {
        return super.getOWLLiteral(literal, lang);
    }

    @Override
    public OWLAnnotation getOWLAnnotation(OWLAnnotationProperty property, OWLAnnotationValue value, Stream<OWLAnnotation> anns) {
        int n;
        OWLAnnotation annotation = this.annotations.get(new OWLAnnotationImpl(property, value, anns));
        if (logger.isDebugEnabled() && (n = this.annotationsCount.incrementAndGet()) % 1000 == 0) {
            logger.debug("{}: Annotations Cache stats: {}", (Object)n, (Object)this.annotations.stats());
        }
        return annotation;
    }
}

