/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.reasoner;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.InferenceDepth;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.Version;

public interface OWLReasoner {
    public String getReasonerName();

    public Version getReasonerVersion();

    public BufferingMode getBufferingMode();

    public void flush();

    public List<OWLOntologyChange> getPendingChanges();

    default public Stream<OWLOntologyChange> pendingChanges() {
        return this.getPendingChanges().stream();
    }

    public Set<OWLAxiom> getPendingAxiomAdditions();

    default public Stream<OWLAxiom> pendingAxiomAdditions() {
        return this.getPendingAxiomAdditions().stream();
    }

    public Set<OWLAxiom> getPendingAxiomRemovals();

    default public Stream<OWLAxiom> pendingAxiomRemovals() {
        return this.getPendingAxiomRemovals().stream();
    }

    public OWLOntology getRootOntology();

    public void interrupt();

    public void precomputeInferences(InferenceType ... var1);

    public boolean isPrecomputed(InferenceType var1);

    public Set<InferenceType> getPrecomputableInferenceTypes();

    default public Stream<InferenceType> precomputableInferenceTypes() {
        return this.getPrecomputableInferenceTypes().stream();
    }

    public boolean isConsistent();

    public boolean isSatisfiable(OWLClassExpression var1);

    public Node<OWLClass> getUnsatisfiableClasses();

    default public Stream<OWLClass> unsatisfiableClasses() {
        return this.getUnsatisfiableClasses().entities();
    }

    public boolean isEntailed(OWLAxiom var1);

    public boolean isEntailed(Set<? extends OWLAxiom> var1);

    default public boolean isEntailed(Stream<? extends OWLAxiom> axioms) {
        return this.isEntailed(OWLAPIStreamUtils.asUnorderedSet(axioms));
    }

    default public boolean isEntailed(OWLAxiom ... axioms) {
        return this.isEntailed(Sets.newHashSet(axioms));
    }

    public boolean isEntailmentCheckingSupported(AxiomType<?> var1);

    public Node<OWLClass> getTopClassNode();

    default public Stream<OWLClass> topClassNode() {
        return this.getTopClassNode().entities();
    }

    public Node<OWLClass> getBottomClassNode();

    default public Stream<OWLClass> bottomClassNode() {
        return this.getBottomClassNode().entities();
    }

    public NodeSet<OWLClass> getSubClasses(OWLClassExpression var1, boolean var2);

    default public Stream<OWLClass> subClasses(OWLClassExpression ce, boolean direct) {
        return this.getSubClasses(ce, direct).entities();
    }

    default public NodeSet<OWLClass> getSubClasses(OWLClassExpression ce, InferenceDepth depth) {
        return this.getSubClasses(ce, depth.isDirectOnly());
    }

    default public Stream<OWLClass> subClasses(OWLClassExpression ce, InferenceDepth depth) {
        return this.getSubClasses(ce, depth).entities();
    }

    default public NodeSet<OWLClass> getSubClasses(OWLClassExpression ce) {
        return this.getSubClasses(ce, false);
    }

    default public Stream<OWLClass> subClasses(OWLClassExpression ce) {
        return this.getSubClasses(ce).entities();
    }

    public NodeSet<OWLClass> getSuperClasses(OWLClassExpression var1, boolean var2);

    default public Stream<OWLClass> superClasses(OWLClassExpression ce, boolean direct) {
        return this.getSuperClasses(ce, direct).entities();
    }

    default public NodeSet<OWLClass> getSuperClasses(OWLClassExpression ce, InferenceDepth depth) {
        return this.getSuperClasses(ce, depth.isDirectOnly());
    }

    default public Stream<OWLClass> superClasses(OWLClassExpression ce, InferenceDepth depth) {
        return this.getSuperClasses(ce, depth).entities();
    }

    default public NodeSet<OWLClass> getSuperClasses(OWLClassExpression ce) {
        return this.getSuperClasses(ce, false);
    }

    default public Stream<OWLClass> superClasses(OWLClassExpression ce) {
        return this.getSuperClasses(ce).entities();
    }

    public Node<OWLClass> getEquivalentClasses(OWLClassExpression var1);

    default public Stream<OWLClass> equivalentClasses(OWLClassExpression ce) {
        return this.getEquivalentClasses(ce).entities();
    }

    public NodeSet<OWLClass> getDisjointClasses(OWLClassExpression var1);

    default public Stream<OWLClass> disjointClasses(OWLClassExpression ce) {
        return this.getDisjointClasses(ce).entities();
    }

    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode();

    default public Stream<OWLObjectPropertyExpression> topObjectPropertyNode() {
        return this.getTopObjectPropertyNode().entities();
    }

    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode();

    default public Stream<OWLObjectPropertyExpression> bottomObjectPropertyNode() {
        return this.getBottomObjectPropertyNode().entities();
    }

    public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression var1, boolean var2);

    default public Stream<OWLObjectPropertyExpression> subObjectProperties(OWLObjectPropertyExpression pe, boolean direct) {
        return this.getSubObjectProperties(pe, direct).entities();
    }

    default public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression pe, InferenceDepth depth) {
        return this.getSubObjectProperties(pe, depth.isDirectOnly());
    }

    default public Stream<OWLObjectPropertyExpression> subObjectProperties(OWLObjectPropertyExpression pe, InferenceDepth depth) {
        return this.getSubObjectProperties(pe, depth).entities();
    }

    default public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression pe) {
        return this.getSubObjectProperties(pe, false);
    }

    default public Stream<OWLObjectPropertyExpression> subObjectProperties(OWLObjectPropertyExpression pe) {
        return this.getSubObjectProperties(pe, false).entities();
    }

    public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression var1, boolean var2);

    default public Stream<OWLObjectPropertyExpression> superObjectProperties(OWLObjectPropertyExpression pe, boolean direct) {
        return this.getSuperObjectProperties(pe, direct).entities();
    }

    default public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression pe, InferenceDepth depth) {
        return this.getSuperObjectProperties(pe, depth.isDirectOnly());
    }

    default public Stream<OWLObjectPropertyExpression> superObjectProperties(OWLObjectPropertyExpression pe, InferenceDepth depth) {
        return this.getSuperObjectProperties(pe, depth).entities();
    }

    default public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression pe) {
        return this.getSuperObjectProperties(pe, false);
    }

    default public Stream<OWLObjectPropertyExpression> superObjectProperties(OWLObjectPropertyExpression pe) {
        return this.getSuperObjectProperties(pe, false).entities();
    }

    public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression var1);

    default public Stream<OWLObjectPropertyExpression> equivalentObjectProperties(OWLObjectPropertyExpression pe) {
        return this.getEquivalentObjectProperties(pe).entities();
    }

    public NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(OWLObjectPropertyExpression var1);

    default public Stream<OWLObjectPropertyExpression> disjointObjectProperties(OWLObjectPropertyExpression pe) {
        return this.getDisjointObjectProperties(pe).entities();
    }

    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(OWLObjectPropertyExpression var1);

    default public Stream<OWLObjectPropertyExpression> inverseObjectProperties(OWLObjectPropertyExpression pe) {
        return this.getInverseObjectProperties(pe).entities();
    }

    public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression var1, boolean var2);

    default public Stream<OWLClass> objectPropertyDomains(OWLObjectPropertyExpression pe, boolean direct) {
        return this.getObjectPropertyDomains(pe, direct).entities();
    }

    default public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression pe, InferenceDepth depth) {
        return this.getObjectPropertyDomains(pe, depth.isDirectOnly());
    }

    default public Stream<OWLClass> objectPropertyDomains(OWLObjectPropertyExpression pe, InferenceDepth depth) {
        return this.getObjectPropertyDomains(pe, depth).entities();
    }

    default public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression pe) {
        return this.getObjectPropertyDomains(pe, false);
    }

    default public Stream<OWLClass> objectPropertyDomains(OWLObjectPropertyExpression pe) {
        return this.getObjectPropertyDomains(pe).entities();
    }

    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression var1, boolean var2);

    default public Stream<OWLClass> objectPropertyRanges(OWLObjectPropertyExpression pe, boolean direct) {
        return this.getObjectPropertyRanges(pe, direct).entities();
    }

    default public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression pe, InferenceDepth depth) {
        return this.getObjectPropertyRanges(pe, depth.isDirectOnly());
    }

    default public Stream<OWLClass> objectPropertyRanges(OWLObjectPropertyExpression pe, InferenceDepth depth) {
        return this.getObjectPropertyRanges(pe, depth).entities();
    }

    default public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression pe) {
        return this.getObjectPropertyRanges(pe, false);
    }

    default public Stream<OWLClass> objectPropertyRanges(OWLObjectPropertyExpression pe) {
        return this.getObjectPropertyRanges(pe, false).entities();
    }

    public Node<OWLDataProperty> getTopDataPropertyNode();

    default public Stream<OWLDataProperty> topDataPropertyNode() {
        return this.getTopDataPropertyNode().entities();
    }

    public Node<OWLDataProperty> getBottomDataPropertyNode();

    default public Stream<OWLDataProperty> bottomDataPropertyNode() {
        return this.getBottomDataPropertyNode().entities();
    }

    public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty var1, boolean var2);

    default public Stream<OWLDataProperty> subDataProperties(OWLDataProperty pe, boolean direct) {
        return this.getSubDataProperties(pe, direct).entities();
    }

    default public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty pe, InferenceDepth depth) {
        return this.getSubDataProperties(pe, depth.isDirectOnly());
    }

    default public Stream<OWLDataProperty> subDataProperties(OWLDataProperty pe, InferenceDepth depth) {
        return this.getSubDataProperties(pe, depth).entities();
    }

    default public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty pe) {
        return this.getSubDataProperties(pe, false);
    }

    default public Stream<OWLDataProperty> subDataProperties(OWLDataProperty pe) {
        return this.getSubDataProperties(pe).entities();
    }

    public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty var1, boolean var2);

    default public Stream<OWLDataProperty> superDataProperties(OWLDataProperty pe, boolean direct) {
        return this.getSuperDataProperties(pe, direct).entities();
    }

    default public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty pe, InferenceDepth depth) {
        return this.getSuperDataProperties(pe, depth.isDirectOnly());
    }

    default public Stream<OWLDataProperty> superDataProperties(OWLDataProperty pe, InferenceDepth depth) {
        return this.getSuperDataProperties(pe, depth).entities();
    }

    default public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty pe) {
        return this.getSuperDataProperties(pe, false);
    }

    default public Stream<OWLDataProperty> superDataProperties(OWLDataProperty pe) {
        return this.getSuperDataProperties(pe, false).entities();
    }

    public Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty var1);

    default public Stream<OWLDataProperty> equivalentDataProperties(OWLDataProperty pe) {
        return this.getEquivalentDataProperties(pe).entities();
    }

    public NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression var1);

    default public Stream<OWLDataProperty> disjointDataProperties(OWLDataProperty pe) {
        return this.getDisjointDataProperties(pe).entities();
    }

    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty var1, boolean var2);

    default public Stream<OWLClass> dataPropertyDomains(OWLDataProperty pe, boolean direct) {
        return this.getDataPropertyDomains(pe, direct).entities();
    }

    default public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty pe, InferenceDepth depth) {
        return this.getDataPropertyDomains(pe, depth.isDirectOnly());
    }

    default public Stream<OWLClass> dataPropertyDomains(OWLDataProperty pe, InferenceDepth depth) {
        return this.getDataPropertyDomains(pe, depth.isDirectOnly()).entities();
    }

    default public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty pe) {
        return this.getDataPropertyDomains(pe, false);
    }

    default public Stream<OWLClass> dataPropertyDomains(OWLDataProperty pe) {
        return this.getDataPropertyDomains(pe, false).entities();
    }

    public NodeSet<OWLClass> getTypes(OWLNamedIndividual var1, boolean var2);

    default public Stream<OWLClass> types(OWLNamedIndividual ind, boolean direct) {
        return this.getTypes(ind, direct).entities();
    }

    default public NodeSet<OWLClass> getTypes(OWLNamedIndividual ind, InferenceDepth depth) {
        return this.getTypes(ind, depth.isDirectOnly());
    }

    default public Stream<OWLClass> types(OWLNamedIndividual ind, InferenceDepth depth) {
        return this.getTypes(ind, depth).entities();
    }

    default public NodeSet<OWLClass> getTypes(OWLNamedIndividual ind) {
        return this.getTypes(ind, false);
    }

    default public Stream<OWLClass> types(OWLNamedIndividual ind) {
        return this.getTypes(ind, false).entities();
    }

    public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression var1, boolean var2);

    default public Stream<OWLNamedIndividual> instances(OWLClassExpression ce, boolean direct) {
        return this.getInstances(ce, direct).entities();
    }

    default public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression ce, InferenceDepth depth) {
        return this.getInstances(ce, depth.isDirectOnly());
    }

    default public Stream<OWLNamedIndividual> instances(OWLClassExpression ce, InferenceDepth depth) {
        return this.getInstances(ce, depth).entities();
    }

    default public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression ce) {
        return this.getInstances(ce, false);
    }

    default public Stream<OWLNamedIndividual> instances(OWLClassExpression ce) {
        return this.getInstances(ce, false).entities();
    }

    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual var1, OWLObjectPropertyExpression var2);

    default public Stream<OWLNamedIndividual> objectPropertyValues(OWLNamedIndividual ind, OWLObjectPropertyExpression pe) {
        return this.getObjectPropertyValues(ind, pe).entities();
    }

    public Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual var1, OWLDataProperty var2);

    default public Stream<OWLLiteral> dataPropertyValues(OWLNamedIndividual ind, OWLDataProperty pe) {
        return this.getDataPropertyValues(ind, pe).stream();
    }

    public Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual var1);

    default public Stream<OWLNamedIndividual> sameIndividuals(OWLNamedIndividual ind) {
        return this.getSameIndividuals(ind).entities();
    }

    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual var1);

    default public Stream<OWLNamedIndividual> differentIndividuals(OWLNamedIndividual ind) {
        return this.getDifferentIndividuals(ind).entities();
    }

    public long getTimeOut();

    public FreshEntityPolicy getFreshEntityPolicy();

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy();

    public void dispose();
}

