/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public final class AxiomType<C extends OWLAxiom>
implements Serializable,
Comparable<AxiomType<?>> {
    public static final AxiomType<OWLDeclarationAxiom> DECLARATION = AxiomType.getInstance(OWLDeclarationAxiom.class, 0, "Declaration", true, true, false);
    public static final AxiomType<OWLEquivalentClassesAxiom> EQUIVALENT_CLASSES = AxiomType.getInstance(OWLEquivalentClassesAxiom.class, 1, "EquivalentClasses", false, false, true);
    public static final AxiomType<OWLSubClassOfAxiom> SUBCLASS_OF = AxiomType.getInstance(OWLSubClassOfAxiom.class, 2, "SubClassOf", false, false, true);
    public static final AxiomType<OWLDisjointClassesAxiom> DISJOINT_CLASSES = AxiomType.getInstance(OWLDisjointClassesAxiom.class, 3, "DisjointClasses", false, false, true);
    public static final AxiomType<OWLDisjointUnionAxiom> DISJOINT_UNION = AxiomType.getInstance(OWLDisjointUnionAxiom.class, 4, "DisjointUnion", true, false, true);
    public static final AxiomType<OWLClassAssertionAxiom> CLASS_ASSERTION = AxiomType.getInstance(OWLClassAssertionAxiom.class, 5, "ClassAssertion", false, false, true);
    public static final AxiomType<OWLSameIndividualAxiom> SAME_INDIVIDUAL = AxiomType.getInstance(OWLSameIndividualAxiom.class, 6, "SameIndividual", false, false, true);
    public static final AxiomType<OWLDifferentIndividualsAxiom> DIFFERENT_INDIVIDUALS = AxiomType.getInstance(OWLDifferentIndividualsAxiom.class, 7, "DifferentIndividuals", false, false, true);
    public static final AxiomType<OWLObjectPropertyAssertionAxiom> OBJECT_PROPERTY_ASSERTION = AxiomType.getInstance(OWLObjectPropertyAssertionAxiom.class, 8, "ObjectPropertyAssertion", false, false, true);
    public static final AxiomType<OWLNegativeObjectPropertyAssertionAxiom> NEGATIVE_OBJECT_PROPERTY_ASSERTION = AxiomType.getInstance(OWLNegativeObjectPropertyAssertionAxiom.class, 9, "NegativeObjectPropertyAssertion", true, false, true);
    public static final AxiomType<OWLDataPropertyAssertionAxiom> DATA_PROPERTY_ASSERTION = AxiomType.getInstance(OWLDataPropertyAssertionAxiom.class, 10, "DataPropertyAssertion", false, false, true);
    public static final AxiomType<OWLNegativeDataPropertyAssertionAxiom> NEGATIVE_DATA_PROPERTY_ASSERTION = AxiomType.getInstance(OWLNegativeDataPropertyAssertionAxiom.class, 11, "NegativeDataPropertyAssertion", true, false, true);
    public static final AxiomType<OWLEquivalentObjectPropertiesAxiom> EQUIVALENT_OBJECT_PROPERTIES = AxiomType.getInstance(OWLEquivalentObjectPropertiesAxiom.class, 12, "EquivalentObjectProperties", false, false, true);
    public static final AxiomType<OWLSubObjectPropertyOfAxiom> SUB_OBJECT_PROPERTY = AxiomType.getInstance(OWLSubObjectPropertyOfAxiom.class, 13, "SubObjectPropertyOf", false, false, true);
    public static final AxiomType<OWLInverseObjectPropertiesAxiom> INVERSE_OBJECT_PROPERTIES = AxiomType.getInstance(OWLInverseObjectPropertiesAxiom.class, 14, "InverseObjectProperties", false, false, true);
    public static final AxiomType<OWLFunctionalObjectPropertyAxiom> FUNCTIONAL_OBJECT_PROPERTY = AxiomType.getInstance(OWLFunctionalObjectPropertyAxiom.class, 15, "FunctionalObjectProperty", false, false, true);
    public static final AxiomType<OWLInverseFunctionalObjectPropertyAxiom> INVERSE_FUNCTIONAL_OBJECT_PROPERTY = AxiomType.getInstance(OWLInverseFunctionalObjectPropertyAxiom.class, 16, "InverseFunctionalObjectProperty", false, false, true);
    public static final AxiomType<OWLSymmetricObjectPropertyAxiom> SYMMETRIC_OBJECT_PROPERTY = AxiomType.getInstance(OWLSymmetricObjectPropertyAxiom.class, 17, "SymmetricObjectProperty", false, false, true);
    public static final AxiomType<OWLAsymmetricObjectPropertyAxiom> ASYMMETRIC_OBJECT_PROPERTY = AxiomType.getInstance(OWLAsymmetricObjectPropertyAxiom.class, 18, "AsymmetricObjectProperty", true, true, true);
    public static final AxiomType<OWLTransitiveObjectPropertyAxiom> TRANSITIVE_OBJECT_PROPERTY = AxiomType.getInstance(OWLTransitiveObjectPropertyAxiom.class, 19, "TransitiveObjectProperty", false, false, true);
    public static final AxiomType<OWLReflexiveObjectPropertyAxiom> REFLEXIVE_OBJECT_PROPERTY = AxiomType.getInstance(OWLReflexiveObjectPropertyAxiom.class, 20, "ReflexiveObjectProperty", true, true, true);
    public static final AxiomType<OWLIrreflexiveObjectPropertyAxiom> IRREFLEXIVE_OBJECT_PROPERTY = AxiomType.getInstance(OWLIrreflexiveObjectPropertyAxiom.class, 21, "IrrefexiveObjectProperty", true, true, true);
    public static final AxiomType<OWLObjectPropertyDomainAxiom> OBJECT_PROPERTY_DOMAIN = AxiomType.getInstance(OWLObjectPropertyDomainAxiom.class, 22, "ObjectPropertyDomain", false, false, true);
    public static final AxiomType<OWLObjectPropertyRangeAxiom> OBJECT_PROPERTY_RANGE = AxiomType.getInstance(OWLObjectPropertyRangeAxiom.class, 23, "ObjectPropertyRange", false, false, true);
    public static final AxiomType<OWLDisjointObjectPropertiesAxiom> DISJOINT_OBJECT_PROPERTIES = AxiomType.getInstance(OWLDisjointObjectPropertiesAxiom.class, 24, "DisjointObjectProperties", true, true, true);
    public static final AxiomType<OWLSubPropertyChainOfAxiom> SUB_PROPERTY_CHAIN_OF = AxiomType.getInstance(OWLSubPropertyChainOfAxiom.class, 25, "SubPropertyChainOf", true, true, true);
    public static final AxiomType<OWLEquivalentDataPropertiesAxiom> EQUIVALENT_DATA_PROPERTIES = AxiomType.getInstance(OWLEquivalentDataPropertiesAxiom.class, 26, "EquivalentDataProperties", false, false, true);
    public static final AxiomType<OWLSubDataPropertyOfAxiom> SUB_DATA_PROPERTY = AxiomType.getInstance(OWLSubDataPropertyOfAxiom.class, 27, "SubDataPropertyOf", false, false, true);
    public static final AxiomType<OWLFunctionalDataPropertyAxiom> FUNCTIONAL_DATA_PROPERTY = AxiomType.getInstance(OWLFunctionalDataPropertyAxiom.class, 28, "FunctionalDataProperty", false, false, true);
    public static final AxiomType<OWLDataPropertyDomainAxiom> DATA_PROPERTY_DOMAIN = AxiomType.getInstance(OWLDataPropertyDomainAxiom.class, 29, "DataPropertyDomain", false, false, true);
    public static final AxiomType<OWLDataPropertyRangeAxiom> DATA_PROPERTY_RANGE = AxiomType.getInstance(OWLDataPropertyRangeAxiom.class, 30, "DataPropertyRange", false, false, true);
    public static final AxiomType<OWLDisjointDataPropertiesAxiom> DISJOINT_DATA_PROPERTIES = AxiomType.getInstance(OWLDisjointDataPropertiesAxiom.class, 31, "DisjointDataProperties", true, true, true);
    public static final AxiomType<OWLDatatypeDefinitionAxiom> DATATYPE_DEFINITION = AxiomType.getInstance(OWLDatatypeDefinitionAxiom.class, 38, "DatatypeDefinition", true, true, true);
    public static final AxiomType<OWLHasKeyAxiom> HAS_KEY = AxiomType.getInstance(OWLHasKeyAxiom.class, 32, "HasKey", true, true, true);
    public static final AxiomType<SWRLRule> SWRL_RULE = AxiomType.getInstance(SWRLRule.class, 33, "Rule", false, false, true);
    public static final AxiomType<OWLAnnotationAssertionAxiom> ANNOTATION_ASSERTION = AxiomType.getInstance(OWLAnnotationAssertionAxiom.class, 34, "AnnotationAssertion", false, false, false);
    public static final AxiomType<OWLSubAnnotationPropertyOfAxiom> SUB_ANNOTATION_PROPERTY_OF = AxiomType.getInstance(OWLSubAnnotationPropertyOfAxiom.class, 35, "SubAnnotationPropertyOf", true, true, false);
    public static final AxiomType<OWLAnnotationPropertyRangeAxiom> ANNOTATION_PROPERTY_RANGE = AxiomType.getInstance(OWLAnnotationPropertyRangeAxiom.class, 36, "AnnotationPropertyRangeOf", true, true, false);
    public static final AxiomType<OWLAnnotationPropertyDomainAxiom> ANNOTATION_PROPERTY_DOMAIN = AxiomType.getInstance(OWLAnnotationPropertyDomainAxiom.class, 37, "AnnotationPropertyDomain", true, true, false);
    public static final Set<AxiomType<? extends OWLAxiom>> AXIOM_TYPES = CollectionFactory.createSet(new AxiomType[]{SUBCLASS_OF, EQUIVALENT_CLASSES, DISJOINT_CLASSES, CLASS_ASSERTION, SAME_INDIVIDUAL, DIFFERENT_INDIVIDUALS, OBJECT_PROPERTY_ASSERTION, NEGATIVE_OBJECT_PROPERTY_ASSERTION, DATA_PROPERTY_ASSERTION, NEGATIVE_DATA_PROPERTY_ASSERTION, OBJECT_PROPERTY_DOMAIN, OBJECT_PROPERTY_RANGE, DISJOINT_OBJECT_PROPERTIES, SUB_OBJECT_PROPERTY, EQUIVALENT_OBJECT_PROPERTIES, INVERSE_OBJECT_PROPERTIES, SUB_PROPERTY_CHAIN_OF, FUNCTIONAL_OBJECT_PROPERTY, INVERSE_FUNCTIONAL_OBJECT_PROPERTY, SYMMETRIC_OBJECT_PROPERTY, ASYMMETRIC_OBJECT_PROPERTY, TRANSITIVE_OBJECT_PROPERTY, REFLEXIVE_OBJECT_PROPERTY, IRREFLEXIVE_OBJECT_PROPERTY, DATA_PROPERTY_DOMAIN, DATA_PROPERTY_RANGE, DISJOINT_DATA_PROPERTIES, SUB_DATA_PROPERTY, EQUIVALENT_DATA_PROPERTIES, FUNCTIONAL_DATA_PROPERTY, DATATYPE_DEFINITION, DISJOINT_UNION, DECLARATION, SWRL_RULE, ANNOTATION_ASSERTION, SUB_ANNOTATION_PROPERTY_OF, ANNOTATION_PROPERTY_DOMAIN, ANNOTATION_PROPERTY_RANGE, HAS_KEY});
    public static final Set<AxiomType<?>> LOGICAL_AXIOM_TYPES = OWLAPIStreamUtils.asSet(AXIOM_TYPES.stream().filter(AxiomType::isLogical));
    public static final Set<AxiomType<? extends OWLAxiom>> LOGICAL_AXIOMS_AND_DECLARATIONS_TYPES = OWLAPIStreamUtils.asSet(Stream.concat(LOGICAL_AXIOM_TYPES.stream(), Stream.of(DECLARATION)));
    public static final Set<AxiomType<?>> TBoxAxiomTypes = CollectionFactory.createSet(new AxiomType[]{SUBCLASS_OF, EQUIVALENT_CLASSES, DISJOINT_CLASSES, OBJECT_PROPERTY_DOMAIN, OBJECT_PROPERTY_RANGE, FUNCTIONAL_OBJECT_PROPERTY, INVERSE_FUNCTIONAL_OBJECT_PROPERTY, DATA_PROPERTY_DOMAIN, DATA_PROPERTY_RANGE, FUNCTIONAL_DATA_PROPERTY, DATATYPE_DEFINITION, DISJOINT_UNION, HAS_KEY});
    public static final Set<AxiomType<?>> ABoxAxiomTypes = CollectionFactory.createSet(new AxiomType[]{CLASS_ASSERTION, SAME_INDIVIDUAL, DIFFERENT_INDIVIDUALS, OBJECT_PROPERTY_ASSERTION, NEGATIVE_OBJECT_PROPERTY_ASSERTION, DATA_PROPERTY_ASSERTION, NEGATIVE_DATA_PROPERTY_ASSERTION});
    public static final Set<AxiomType<?>> RBoxAxiomTypes = CollectionFactory.createSet(new AxiomType[]{TRANSITIVE_OBJECT_PROPERTY, DISJOINT_DATA_PROPERTIES, SUB_DATA_PROPERTY, EQUIVALENT_DATA_PROPERTIES, DISJOINT_OBJECT_PROPERTIES, SUB_OBJECT_PROPERTY, EQUIVALENT_OBJECT_PROPERTIES, SUB_PROPERTY_CHAIN_OF, INVERSE_OBJECT_PROPERTIES, SYMMETRIC_OBJECT_PROPERTY, ASYMMETRIC_OBJECT_PROPERTY, REFLEXIVE_OBJECT_PROPERTY, IRREFLEXIVE_OBJECT_PROPERTY});
    public static final Set<AxiomType<?>> TBoxAndRBoxAxiomTypes = Sets.newHashSet(Iterables.concat(TBoxAxiomTypes, RBoxAxiomTypes));
    private static final Map<String, AxiomType<? extends OWLAxiom>> NAME_TYPE_MAP = Maps.uniqueIndex(AXIOM_TYPES, AxiomType::getName);
    private static final Map<Class<?>, AxiomType<? extends OWLAxiom>> CLASS_TYPE_MAP = Maps.uniqueIndex(AXIOM_TYPES, AxiomType::getActualClass);
    private final String name;
    private final boolean owl2Axiom;
    private final boolean nonSyntacticOWL2Axiom;
    private final boolean isLogical;
    private final int index;
    private final Class<C> actualClass;

    private AxiomType(Class<C> actualClass, int ind, String name, boolean owl2Axiom, boolean nonSyntacticOWL2Axiom, boolean isLogical) {
        this.actualClass = actualClass;
        this.name = name;
        this.owl2Axiom = owl2Axiom;
        this.nonSyntacticOWL2Axiom = nonSyntacticOWL2Axiom;
        this.isLogical = isLogical;
        this.index = ind;
    }

    private static <O extends OWLAxiom> AxiomType<O> getInstance(Class<O> c, int i, String name, boolean owl2Axiom, boolean nonSyntacticOWL2Axiom, boolean isLogical) {
        return new AxiomType<O>(c, i, name, owl2Axiom, nonSyntacticOWL2Axiom, isLogical);
    }

    public static <T extends OWLAxiom> AxiomType<T> getTypeForClass(Class<T> t) {
        AxiomType<? extends OWLAxiom> axiomType = CLASS_TYPE_MAP.get(t);
        if (axiomType == null) {
            throw new OWLRuntimeException("No known axiom type for " + t);
        }
        return axiomType;
    }

    public static Set<OWLAxiom> getAxiomsWithoutTypes(Collection<OWLAxiom> sourceAxioms, AxiomType<?> ... axiomTypes) {
        HashSet<AxiomType<?>> disallowed = Sets.newHashSet(axiomTypes);
        return OWLAPIStreamUtils.asSet(sourceAxioms.stream().filter(a -> !disallowed.contains(a.getAxiomType())));
    }

    public static Set<OWLAxiom> getAxiomsOfTypes(Collection<OWLAxiom> sourceAxioms, AxiomType<?> ... axiomTypes) {
        HashSet<AxiomType<?>> allowed = Sets.newHashSet(axiomTypes);
        return OWLAPIStreamUtils.asSet(sourceAxioms.stream().filter(a -> allowed.contains(a.getAxiomType())));
    }

    public static AxiomType<?> getAxiomType(String name) {
        return NAME_TYPE_MAP.get(name);
    }

    public static boolean isAxiomType(String _name) {
        return NAME_TYPE_MAP.containsKey(_name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof AxiomType) {
            return this.name.equals(((AxiomType)obj).name);
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    public Class<C> getActualClass() {
        return this.actualClass;
    }

    public boolean isOWL2Axiom() {
        return this.owl2Axiom;
    }

    public boolean isNonSyntacticOWL2Axiom() {
        return this.nonSyntacticOWL2Axiom;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public boolean isLogical() {
        return this.isLogical;
    }

    @Override
    public int compareTo(AxiomType<?> o) {
        return Integer.compare(this.index, o.index);
    }
}

