/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import com.google.common.io.Closeables;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.XZOutputStream;

public class XZStreamDocumentTarget
implements OWLOntologyDocumentTarget,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(XZStreamDocumentTarget.class);
    private final OutputStream outputStream;
    @Nullable
    private XZOutputStream xzOutputStream;
    private FilterOptions[] filterOptions;

    public XZStreamDocumentTarget(OutputStream os, FilterOptions ... filterOptions) {
        this.outputStream = os;
        this.filterOptions = filterOptions.length == 0 ? new FilterOptions[]{new LZMA2Options()} : filterOptions;
    }

    public XZStreamDocumentTarget(OutputStream os, int presetLevel) throws UnsupportedOptionsException {
        this(os, new LZMA2Options(presetLevel));
    }

    @Override
    public Optional<OutputStream> getOutputStream() {
        if (this.xzOutputStream == null) {
            try {
                this.xzOutputStream = new XZOutputStream(this.outputStream, this.filterOptions);
            }
            catch (IOException e) {
                LOGGER.error("Fille cannot be found or opened", e);
                return OWLAPIPreconditions.emptyOptional();
            }
        }
        return OWLAPIPreconditions.optional(OWLAPIPreconditions.verifyNotNull(this.xzOutputStream));
    }

    @Override
    public void close() throws Exception {
        XZOutputStream toReturn = this.xzOutputStream;
        this.xzOutputStream = null;
        Closeables.close(toReturn, false);
    }
}

