/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.rdf.api.Triple;
import org.semanticweb.owlapi.io.RDFLiteral;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceBlankNode;
import org.semanticweb.owlapi.io.RDFResourceIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class RDFTriple
implements Serializable,
Comparable<RDFTriple>,
Triple {
    static final TObjectIntHashMap<IRI> specialPredicateRanks = RDFTriple.initMap();
    private final RDFResource subject;
    private final RDFResourceIRI predicate;
    private final RDFNode object;

    public RDFTriple(RDFResource subject, RDFResourceIRI predicate, RDFNode object) {
        this.subject = OWLAPIPreconditions.checkNotNull(subject, "subject cannot be null");
        this.predicate = OWLAPIPreconditions.checkNotNull(predicate, "predicate cannot be null");
        this.object = OWLAPIPreconditions.checkNotNull(object, "object cannot be null");
    }

    public RDFTriple(IRI subject, boolean subjectAnon, boolean subjectAxiom, IRI predicate, IRI object, boolean objectAnon, boolean objectAxiom) {
        this(RDFTriple.getResource(subject, subjectAnon, subjectAxiom), new RDFResourceIRI(predicate), RDFTriple.getResource(object, objectAnon, objectAxiom));
    }

    public RDFTriple(IRI subject, boolean subjectAnon, boolean axiom, IRI predicate, OWLLiteral object) {
        this(RDFTriple.getResource(subject, subjectAnon, axiom), new RDFResourceIRI(predicate), new RDFLiteral(object));
    }

    private static RDFResource getResource(IRI iri, boolean anon, boolean axiom) {
        if (anon) {
            return new RDFResourceBlankNode(iri, true, true, axiom);
        }
        return new RDFResourceIRI(iri);
    }

    static TObjectIntHashMap<IRI> initMap() {
        TObjectIntHashMap<IRI> predicates = new TObjectIntHashMap<IRI>();
        AtomicInteger nextId = new AtomicInteger(1);
        List<OWLRDFVocabulary> ORDERED_URIS = Arrays.asList(OWLRDFVocabulary.RDF_TYPE, OWLRDFVocabulary.RDFS_LABEL, OWLRDFVocabulary.OWL_DEPRECATED, OWLRDFVocabulary.RDFS_COMMENT, OWLRDFVocabulary.RDFS_IS_DEFINED_BY, OWLRDFVocabulary.RDF_FIRST, OWLRDFVocabulary.RDF_REST, OWLRDFVocabulary.OWL_EQUIVALENT_CLASS, OWLRDFVocabulary.OWL_EQUIVALENT_PROPERTY, OWLRDFVocabulary.RDFS_SUBCLASS_OF, OWLRDFVocabulary.RDFS_SUB_PROPERTY_OF, OWLRDFVocabulary.RDFS_DOMAIN, OWLRDFVocabulary.RDFS_RANGE, OWLRDFVocabulary.OWL_DISJOINT_WITH, OWLRDFVocabulary.OWL_ON_PROPERTY, OWLRDFVocabulary.OWL_DATA_RANGE, OWLRDFVocabulary.OWL_ON_CLASS, OWLRDFVocabulary.OWL_ANNOTATED_SOURCE, OWLRDFVocabulary.OWL_ANNOTATED_PROPERTY, OWLRDFVocabulary.OWL_ANNOTATED_TARGET);
        ORDERED_URIS.forEach(iri -> predicates.put(iri.getIRI(), nextId.getAndIncrement()));
        Stream.of(OWLRDFVocabulary.values()).forEach(iri -> predicates.putIfAbsent(iri.getIRI(), nextId.getAndIncrement()));
        return predicates;
    }

    private static int comparePredicates(RDFResourceIRI predicate, RDFResourceIRI otherPredicate) {
        IRI predicateIRI = predicate.getIRI();
        int specialPredicateRank = specialPredicateRanks.get(predicateIRI);
        IRI otherPredicateIRI = otherPredicate.getIRI();
        int otherSpecialPredicateRank = specialPredicateRanks.get(otherPredicateIRI);
        if (specialPredicateRank != specialPredicateRanks.getNoEntryValue()) {
            if (otherSpecialPredicateRank != specialPredicateRanks.getNoEntryValue()) {
                return Integer.compare(specialPredicateRank, otherSpecialPredicateRank);
            }
            return -1;
        }
        if (otherSpecialPredicateRank != specialPredicateRanks.getNoEntryValue()) {
            return 1;
        }
        return predicateIRI.compareTo(otherPredicateIRI);
    }

    public boolean isSubjectSameAsObject() {
        return this.subject.equals(this.object);
    }

    @Override
    public RDFResource getSubject() {
        return this.subject;
    }

    @Override
    public RDFResourceIRI getPredicate() {
        return this.predicate;
    }

    @Override
    public RDFNode getObject() {
        return this.object;
    }

    @Override
    public int hashCode() {
        return this.subject.hashCode() * 37 + this.predicate.hashCode() * 17 + this.object.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RDFTriple) {
            RDFTriple other = (RDFTriple)obj;
            return this.subject.equals(other.subject) && this.predicate.equals(other.predicate) && this.object.equals(other.object);
        }
        if (obj instanceof Triple) {
            Triple triple = (Triple)obj;
            return this.getSubject().equals(triple.getSubject()) && this.getPredicate().equals(triple.getPredicate()) && this.getObject().equals(triple.getObject());
        }
        return false;
    }

    public String toString() {
        return String.format("%s %s %s.", this.subject, this.predicate, this.object);
    }

    @Override
    public int compareTo(@Nullable RDFTriple o) {
        OWLAPIPreconditions.checkNotNull(o);
        assert (o != null);
        int diff = RDFTriple.comparePredicates(this.predicate, o.predicate);
        if (diff == 0) {
            diff = this.subject.compareTo(o.subject);
        }
        if (diff == 0) {
            diff = this.object.compareTo(o.object);
        }
        return diff;
    }
}

