/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.debugging;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.OWLEntityCollector;

public class JustificationMap {
    private final Set<OWLAxiom> axioms;
    private final Set<OWLAxiom> rootAxioms = new HashSet<OWLAxiom>();
    private final Set<OWLAxiom> usedAxioms = new HashSet<OWLAxiom>();
    private final Multimap<OWLAxiom, OWLAxiom> map = MultimapBuilder.hashKeys().linkedHashSetValues().build();
    private final Multimap<OWLEntity, OWLAxiom> axiomsByLHS = MultimapBuilder.hashKeys().linkedHashSetValues().build();
    private final OWLClassExpression desc;

    public JustificationMap(OWLClassExpression desc, Set<OWLAxiom> axioms) {
        this.axioms = OWLAPIPreconditions.checkNotNull(axioms, "axioms cannot be null");
        this.desc = OWLAPIPreconditions.checkNotNull(desc, "desc cannot be null");
        this.createMap();
    }

    private void createMap() {
        for (OWLAxiom ax : this.axioms) {
            OWLAxiomPartExtractor extractor = new OWLAxiomPartExtractor();
            ax.accept(extractor);
            HashSet<OWLEntity> lhscollected = new HashSet<OWLEntity>();
            OWLEntityCollector lhsCollector = new OWLEntityCollector((Collection<OWLEntity>)lhscollected);
            extractor.getLHS().forEach(l -> l.accept(lhsCollector));
            lhscollected.forEach(l -> this.axiomsByLHS.put((OWLEntity)l, ax));
        }
        this.buildChildren(this.desc);
    }

    protected Stream<OWLAxiom> getAxiomsByLHS(OWLEntity lhs) {
        return this.axiomsByLHS.get(lhs).stream();
    }

    private void buildChildren(OWLClassExpression seed) {
        List<OWLAxiom> result = OWLAPIStreamUtils.asList(seed.signature().flatMap(this::getAxiomsByLHS));
        this.usedAxioms.addAll(result);
        this.rootAxioms.addAll(result);
        this.buildChildren(result);
    }

    private void buildChildren(Collection<OWLAxiom> axiomSet) {
        ArrayList<Set<OWLAxiom>> axiomChildren = new ArrayList<Set<OWLAxiom>>();
        for (OWLAxiom ax : axiomSet) {
            Set<OWLAxiom> children = this.build(ax);
            children.forEach(a -> this.map.put((OWLAxiom)a, ax));
            axiomChildren.add(children);
        }
        axiomChildren.forEach(this::buildChildren);
    }

    private Set<OWLAxiom> build(OWLAxiom parentAxiom) {
        this.usedAxioms.add(parentAxiom);
        OWLAxiomPartExtractor extractor = new OWLAxiomPartExtractor();
        parentAxiom.accept(extractor);
        return OWLAPIStreamUtils.asUnorderedSet(extractor.getRHS().stream().flatMap(o -> o.signature()).flatMap(this::getAxiomsByLHS).filter(this.usedAxioms::add));
    }

    public Set<OWLAxiom> getRootAxioms() {
        return this.rootAxioms;
    }

    public Collection<OWLAxiom> getChildAxioms(OWLAxiom ax) {
        return this.map.get(ax);
    }

    private static class OWLAxiomPartExtractor
    implements OWLAxiomVisitor {
        private final Set<OWLObject> rhs = new HashSet<OWLObject>();
        private final Set<OWLObject> lhs = new HashSet<OWLObject>();

        OWLAxiomPartExtractor() {
        }

        public Set<OWLObject> getRHS() {
            return this.rhs;
        }

        public Set<OWLObject> getLHS() {
            return this.lhs;
        }

        @Override
        public void visit(OWLSubClassOfAxiom axiom) {
            this.rhs.add(axiom.getSuperClass());
            this.lhs.add(axiom.getSubClass());
        }

        @Override
        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getObject());
            this.rhs.add(axiom.getProperty());
            this.lhs.add(axiom.getSubject());
        }

        @Override
        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLDisjointClassesAxiom axiom) {
            OWLAPIStreamUtils.add(this.rhs, axiom.classExpressions());
            OWLAPIStreamUtils.add(this.lhs, axiom.classExpressions());
        }

        @Override
        public void visit(OWLDataPropertyDomainAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getDomain());
            this.lhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getDomain());
            this.lhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            OWLAPIStreamUtils.add(this.rhs, axiom.properties());
            OWLAPIStreamUtils.add(this.lhs, axiom.properties());
        }

        @Override
        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            this.rhs.add(axiom.getProperty());
            this.rhs.add((OWLObject)axiom.getObject());
            this.lhs.add(axiom.getSubject());
        }

        @Override
        public void visit(OWLDifferentIndividualsAxiom axiom) {
            OWLAPIStreamUtils.add(this.rhs, axiom.individuals());
            OWLAPIStreamUtils.add(this.lhs, axiom.individuals());
        }

        @Override
        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            OWLAPIStreamUtils.add(this.rhs, axiom.properties());
            OWLAPIStreamUtils.add(this.lhs, axiom.properties());
        }

        @Override
        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            OWLAPIStreamUtils.add(this.rhs, axiom.properties());
            OWLAPIStreamUtils.add(this.lhs, axiom.properties());
        }

        @Override
        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getRange());
            this.lhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            this.rhs.add(axiom.getProperty());
            this.rhs.add((OWLObject)axiom.getObject());
            this.lhs.add(axiom.getSubject());
        }

        @Override
        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getSuperProperty());
            this.lhs.add((OWLObject)axiom.getSubProperty());
        }

        @Override
        public void visit(OWLDisjointUnionAxiom axiom) {
            OWLAPIStreamUtils.add(this.rhs, axiom.classExpressions());
            this.rhs.add(axiom.getOWLClass());
            this.lhs.add(axiom.getOWLClass());
            OWLAPIStreamUtils.add(this.lhs, axiom.classExpressions());
        }

        @Override
        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLDataPropertyRangeAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getRange());
            this.lhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            OWLAPIStreamUtils.add(this.rhs, axiom.properties());
            OWLAPIStreamUtils.add(this.lhs, axiom.properties());
        }

        @Override
        public void visit(OWLClassAssertionAxiom axiom) {
            this.rhs.add(axiom.getClassExpression());
            this.lhs.add(axiom.getIndividual());
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            OWLAPIStreamUtils.add(this.rhs, axiom.classExpressions());
            OWLAPIStreamUtils.add(this.lhs, axiom.classExpressions());
        }

        @Override
        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            this.rhs.add(axiom.getProperty());
            this.lhs.add(axiom.getSubject());
        }

        @Override
        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLSubDataPropertyOfAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getSuperProperty());
        }

        @Override
        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            this.rhs.add((OWLObject)axiom.getProperty());
        }

        @Override
        public void visit(OWLSameIndividualAxiom axiom) {
            OWLAPIStreamUtils.add(this.rhs, axiom.individuals());
            OWLAPIStreamUtils.add(this.lhs, axiom.individuals());
        }

        @Override
        public void visit(OWLSubPropertyChainOfAxiom axiom) {
            this.rhs.add(axiom.getSuperProperty());
            this.lhs.addAll(axiom.getPropertyChain());
        }

        @Override
        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            OWLAPIStreamUtils.add(this.rhs, axiom.properties());
            OWLAPIStreamUtils.add(this.lhs, axiom.properties());
        }
    }
}

