/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.structural;

import java.util.HashSet;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

class ExpressionManager {
    protected final OWLDataFactory m_factory;
    protected final DescriptionNNFVisitor m_descriptionNNFVisitor;
    protected final DataRangeNNFVisitor m_dataRangeNNFVisitor;
    protected final DescriptionComplementNNFVisitor m_descriptionComplementNNFVisitor;
    protected final DataRangeComplementNNFVisitor m_dataRangeComplementNNFVisitor;
    protected final DescriptionSimplificationVisitor m_descriptionSimplificationVisitor;
    protected final DataRangeSimplificationVisitor m_dataRangeSimplificationVisitor;

    public ExpressionManager(OWLDataFactory factory) {
        this.m_factory = factory;
        this.m_descriptionNNFVisitor = new DescriptionNNFVisitor();
        this.m_dataRangeNNFVisitor = new DataRangeNNFVisitor();
        this.m_descriptionComplementNNFVisitor = new DescriptionComplementNNFVisitor();
        this.m_dataRangeComplementNNFVisitor = new DataRangeComplementNNFVisitor();
        this.m_descriptionSimplificationVisitor = new DescriptionSimplificationVisitor();
        this.m_dataRangeSimplificationVisitor = new DataRangeSimplificationVisitor();
    }

    public OWLClassExpression getNNF(OWLClassExpression description) {
        return description.accept(this.m_descriptionNNFVisitor);
    }

    public OWLDataRange getNNF(OWLDataRange dataRange) {
        return dataRange.accept(this.m_dataRangeNNFVisitor);
    }

    public OWLClassExpression getComplementNNF(OWLClassExpression description) {
        return description.accept(this.m_descriptionComplementNNFVisitor);
    }

    public OWLDataRange getComplementNNF(OWLDataRange dataRange) {
        return dataRange.accept(this.m_dataRangeComplementNNFVisitor);
    }

    public OWLClassExpression getSimplified(OWLClassExpression description) {
        return description.accept(this.m_descriptionSimplificationVisitor);
    }

    public OWLDataRange getSimplified(OWLDataRange dataRange) {
        return dataRange.accept(this.m_dataRangeSimplificationVisitor);
    }

    protected class DataRangeSimplificationVisitor
    implements OWLDataVisitorEx<OWLDataRange> {
        protected DataRangeSimplificationVisitor() {
        }

        @Override
        public OWLDataRange visit(OWLDatatype o) {
            return o;
        }

        @Override
        public OWLDataRange visit(OWLDataComplementOf o) {
            OWLDataRange dataRangeSimplified = ExpressionManager.this.getSimplified(o.getDataRange());
            if (dataRangeSimplified instanceof OWLDataComplementOf) {
                return ((OWLDataComplementOf)dataRangeSimplified).getDataRange();
            }
            return ExpressionManager.this.m_factory.getOWLDataComplementOf(dataRangeSimplified);
        }

        @Override
        public OWLDataRange visit(OWLDataOneOf o) {
            return o;
        }

        @Override
        public OWLDataRange visit(OWLDatatypeRestriction o) {
            return o;
        }

        @Override
        public OWLDataRange visit(OWLFacetRestriction o) {
            return null;
        }

        @Override
        public OWLDataRange visit(OWLLiteral o) {
            return null;
        }

        @Override
        public OWLDataRange visit(OWLDataIntersectionOf range) {
            HashSet<OWLDataRange> newConjuncts = new HashSet<OWLDataRange>();
            for (OWLDataRange dr : OWLAPIStreamUtils.asList(range.operands())) {
                OWLDataRange drSimplified = ExpressionManager.this.getSimplified(dr);
                if (drSimplified.isTopDatatype()) continue;
                if (drSimplified instanceof OWLDataIntersectionOf) {
                    OWLAPIStreamUtils.add(newConjuncts, ((OWLDataIntersectionOf)drSimplified).operands());
                    continue;
                }
                newConjuncts.add(drSimplified);
            }
            return ExpressionManager.this.m_factory.getOWLDataIntersectionOf(newConjuncts);
        }

        @Override
        public OWLDataRange visit(OWLDataUnionOf range) {
            HashSet<OWLDataRange> newDisjuncts = new HashSet<OWLDataRange>();
            for (OWLDataRange dr : OWLAPIStreamUtils.asList(range.operands())) {
                OWLDataRange drSimplified = ExpressionManager.this.getSimplified(dr);
                if (drSimplified.isTopDatatype()) {
                    return ExpressionManager.this.m_factory.getTopDatatype();
                }
                if (drSimplified instanceof OWLDataUnionOf) {
                    OWLAPIStreamUtils.add(newDisjuncts, ((OWLDataUnionOf)drSimplified).operands());
                    continue;
                }
                newDisjuncts.add(drSimplified);
            }
            return ExpressionManager.this.m_factory.getOWLDataUnionOf(newDisjuncts);
        }
    }

    protected class DescriptionSimplificationVisitor
    implements OWLClassExpressionVisitorEx<OWLClassExpression> {
        protected DescriptionSimplificationVisitor() {
        }

        @Override
        public OWLClassExpression visit(OWLClass d) {
            return d;
        }

        @Override
        public OWLClassExpression visit(OWLObjectIntersectionOf d) {
            HashSet<OWLClassExpression> newConjuncts = new HashSet<OWLClassExpression>();
            for (OWLClassExpression description : OWLAPIStreamUtils.asList(d.operands())) {
                OWLClassExpression descriptionSimplified = ExpressionManager.this.getSimplified(description);
                if (descriptionSimplified.isOWLThing()) continue;
                if (descriptionSimplified.isOWLNothing()) {
                    return ExpressionManager.this.m_factory.getOWLNothing();
                }
                if (descriptionSimplified instanceof OWLObjectIntersectionOf) {
                    OWLAPIStreamUtils.add(newConjuncts, ((OWLObjectIntersectionOf)descriptionSimplified).operands());
                    continue;
                }
                newConjuncts.add(descriptionSimplified);
            }
            return ExpressionManager.this.m_factory.getOWLObjectIntersectionOf(newConjuncts);
        }

        @Override
        public OWLClassExpression visit(OWLObjectUnionOf d) {
            HashSet<OWLClassExpression> newDisjuncts = new HashSet<OWLClassExpression>();
            for (OWLClassExpression description : OWLAPIStreamUtils.asList(d.operands())) {
                OWLClassExpression descriptionSimplified = ExpressionManager.this.getSimplified(description);
                if (descriptionSimplified.isOWLThing()) {
                    return ExpressionManager.this.m_factory.getOWLThing();
                }
                if (descriptionSimplified.isOWLNothing()) continue;
                if (descriptionSimplified instanceof OWLObjectUnionOf) {
                    OWLAPIStreamUtils.add(newDisjuncts, ((OWLObjectUnionOf)descriptionSimplified).operands());
                    continue;
                }
                newDisjuncts.add(descriptionSimplified);
            }
            return ExpressionManager.this.m_factory.getOWLObjectUnionOf(newDisjuncts);
        }

        @Override
        public OWLClassExpression visit(OWLObjectComplementOf d) {
            OWLClassExpression operandSimplified = ExpressionManager.this.getSimplified(d.getOperand());
            if (operandSimplified.isOWLThing()) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            if (operandSimplified.isOWLNothing()) {
                return ExpressionManager.this.m_factory.getOWLThing();
            }
            if (operandSimplified instanceof OWLObjectComplementOf) {
                return ((OWLObjectComplementOf)operandSimplified).getOperand();
            }
            return ExpressionManager.this.m_factory.getOWLObjectComplementOf(operandSimplified);
        }

        @Override
        public OWLClassExpression visit(OWLObjectOneOf d) {
            return d;
        }

        @Override
        public OWLClassExpression visit(OWLObjectSomeValuesFrom d) {
            OWLClassExpression filler = ExpressionManager.this.getSimplified((OWLClassExpression)d.getFiller());
            if (filler.isOWLNothing()) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            return ExpressionManager.this.m_factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)d.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLObjectAllValuesFrom d) {
            OWLClassExpression filler = ExpressionManager.this.getSimplified((OWLClassExpression)d.getFiller());
            if (filler.isOWLThing()) {
                return ExpressionManager.this.m_factory.getOWLThing();
            }
            return ExpressionManager.this.m_factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)d.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLObjectHasValue d) {
            OWLObjectOneOf nominal = ExpressionManager.this.m_factory.getOWLObjectOneOf((OWLIndividual)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)d.getProperty(), nominal);
        }

        @Override
        public OWLClassExpression visit(OWLObjectHasSelf d) {
            return ExpressionManager.this.m_factory.getOWLObjectHasSelf((OWLObjectPropertyExpression)d.getProperty());
        }

        @Override
        public OWLClassExpression visit(OWLObjectMinCardinality d) {
            OWLClassExpression filler = ExpressionManager.this.getSimplified((OWLClassExpression)d.getFiller());
            if (d.getCardinality() <= 0) {
                return ExpressionManager.this.m_factory.getOWLThing();
            }
            if (filler.isOWLNothing()) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            if (d.getCardinality() == 1) {
                return ExpressionManager.this.m_factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)d.getProperty(), filler);
            }
            return ExpressionManager.this.m_factory.getOWLObjectMinCardinality(d.getCardinality(), (OWLObjectPropertyExpression)d.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLObjectMaxCardinality d) {
            OWLClassExpression filler = ExpressionManager.this.getSimplified((OWLClassExpression)d.getFiller());
            if (filler.isOWLNothing()) {
                return ExpressionManager.this.m_factory.getOWLThing();
            }
            if (d.getCardinality() <= 0) {
                return ExpressionManager.this.m_factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)d.getProperty(), ExpressionManager.this.m_factory.getOWLObjectComplementOf(filler));
            }
            return ExpressionManager.this.m_factory.getOWLObjectMaxCardinality(d.getCardinality(), (OWLObjectPropertyExpression)d.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLObjectExactCardinality d) {
            OWLClassExpression filler = ExpressionManager.this.getSimplified((OWLClassExpression)d.getFiller());
            if (d.getCardinality() < 0) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            if (d.getCardinality() == 0) {
                return ExpressionManager.this.m_factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)d.getProperty(), ExpressionManager.this.m_factory.getOWLObjectComplementOf(filler));
            }
            if (filler.isOWLNothing()) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            OWLObjectMinCardinality minCardinality = ExpressionManager.this.m_factory.getOWLObjectMinCardinality(d.getCardinality(), (OWLObjectPropertyExpression)d.getProperty(), filler);
            OWLObjectMaxCardinality maxCardinality = ExpressionManager.this.m_factory.getOWLObjectMaxCardinality(d.getCardinality(), (OWLObjectPropertyExpression)d.getProperty(), filler);
            return ExpressionManager.this.m_factory.getOWLObjectIntersectionOf(minCardinality, maxCardinality);
        }

        @Override
        public OWLClassExpression visit(OWLDataSomeValuesFrom d) {
            OWLDataRange filler = ExpressionManager.this.getSimplified((OWLDataRange)d.getFiller());
            if (this.isBottomDataRange(filler)) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            return ExpressionManager.this.m_factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)d.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLDataAllValuesFrom d) {
            OWLDataRange filler = ExpressionManager.this.getSimplified((OWLDataRange)d.getFiller());
            if (filler.isTopDatatype()) {
                return ExpressionManager.this.m_factory.getOWLThing();
            }
            return ExpressionManager.this.m_factory.getOWLDataAllValuesFrom((OWLDataPropertyExpression)d.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLDataHasValue d) {
            OWLDataOneOf nominal = ExpressionManager.this.m_factory.getOWLDataOneOf((OWLLiteral)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)d.getProperty(), nominal);
        }

        @Override
        public OWLClassExpression visit(OWLDataMinCardinality d) {
            OWLDataRange filler = ExpressionManager.this.getSimplified((OWLDataRange)d.getFiller());
            if (d.getCardinality() <= 0) {
                return ExpressionManager.this.m_factory.getOWLThing();
            }
            if (this.isBottomDataRange(filler)) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            if (d.getCardinality() == 1) {
                return ExpressionManager.this.m_factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)d.getProperty(), filler);
            }
            return ExpressionManager.this.m_factory.getOWLDataMinCardinality(d.getCardinality(), (OWLDataPropertyExpression)d.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLDataMaxCardinality d) {
            OWLDataRange filler = ExpressionManager.this.getSimplified((OWLDataRange)d.getFiller());
            if (this.isBottomDataRange(filler)) {
                return ExpressionManager.this.m_factory.getOWLThing();
            }
            if (d.getCardinality() <= 0) {
                return ExpressionManager.this.m_factory.getOWLDataAllValuesFrom((OWLDataPropertyExpression)d.getProperty(), ExpressionManager.this.m_factory.getOWLDataComplementOf(filler));
            }
            return ExpressionManager.this.m_factory.getOWLDataMaxCardinality(d.getCardinality(), (OWLDataPropertyExpression)d.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLDataExactCardinality d) {
            OWLDataRange filler = ExpressionManager.this.getSimplified((OWLDataRange)d.getFiller());
            if (d.getCardinality() < 0) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            if (d.getCardinality() == 0) {
                return ExpressionManager.this.m_factory.getOWLDataAllValuesFrom((OWLDataPropertyExpression)d.getProperty(), ExpressionManager.this.m_factory.getOWLDataComplementOf(filler));
            }
            if (this.isBottomDataRange(filler)) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            OWLDataMinCardinality minCardinality = ExpressionManager.this.m_factory.getOWLDataMinCardinality(d.getCardinality(), (OWLDataPropertyExpression)d.getProperty(), filler);
            OWLDataMaxCardinality maxCardinality = ExpressionManager.this.m_factory.getOWLDataMaxCardinality(d.getCardinality(), (OWLDataPropertyExpression)d.getProperty(), filler);
            return ExpressionManager.this.m_factory.getOWLObjectIntersectionOf(minCardinality, maxCardinality);
        }

        protected boolean isBottomDataRange(OWLDataRange dataRange) {
            return dataRange instanceof OWLDataComplementOf && ((OWLDataComplementOf)dataRange).getDataRange().isTopDatatype();
        }
    }

    protected class DataRangeComplementNNFVisitor
    implements OWLDataVisitorEx<OWLDataRange> {
        protected DataRangeComplementNNFVisitor() {
        }

        @Override
        public OWLDataRange visit(OWLDatatype o) {
            return ExpressionManager.this.m_factory.getOWLDataComplementOf(o);
        }

        @Override
        public OWLDataRange visit(OWLDataComplementOf o) {
            return ExpressionManager.this.getNNF(o.getDataRange());
        }

        @Override
        public OWLDataRange visit(OWLDataOneOf o) {
            return ExpressionManager.this.m_factory.getOWLDataComplementOf(o);
        }

        @Override
        public OWLDataRange visit(OWLDatatypeRestriction o) {
            return ExpressionManager.this.m_factory.getOWLDataComplementOf(o);
        }

        @Override
        public OWLDataRange visit(OWLFacetRestriction o) {
            return null;
        }

        @Override
        public OWLDataRange visit(OWLLiteral o) {
            return null;
        }

        @Override
        public OWLDataRange visit(OWLDataIntersectionOf range) {
            return ExpressionManager.this.m_factory.getOWLDataUnionOf(range.operands().map(dr -> ExpressionManager.this.getComplementNNF((OWLDataRange)dr)).distinct());
        }

        @Override
        public OWLDataRange visit(OWLDataUnionOf range) {
            return ExpressionManager.this.m_factory.getOWLDataIntersectionOf(range.operands().map(dr -> ExpressionManager.this.getComplementNNF((OWLDataRange)dr)).distinct());
        }
    }

    protected class DescriptionComplementNNFVisitor
    implements OWLClassExpressionVisitorEx<OWLClassExpression> {
        protected DescriptionComplementNNFVisitor() {
        }

        @Override
        public OWLClassExpression visit(OWLClass d) {
            if (d.isOWLThing()) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            if (d.isOWLNothing()) {
                return ExpressionManager.this.m_factory.getOWLThing();
            }
            return ExpressionManager.this.m_factory.getOWLObjectComplementOf(d);
        }

        @Override
        public OWLClassExpression visit(OWLObjectIntersectionOf d) {
            return ExpressionManager.this.m_factory.getOWLObjectUnionOf(d.operands().map(c -> ExpressionManager.this.getComplementNNF((OWLClassExpression)c)).distinct());
        }

        @Override
        public OWLClassExpression visit(OWLObjectUnionOf d) {
            return ExpressionManager.this.m_factory.getOWLObjectIntersectionOf(d.operands().map(c -> ExpressionManager.this.getComplementNNF((OWLClassExpression)c)).distinct());
        }

        @Override
        public OWLClassExpression visit(OWLObjectComplementOf d) {
            return ExpressionManager.this.getNNF(d.getOperand());
        }

        @Override
        public OWLClassExpression visit(OWLObjectOneOf d) {
            return ExpressionManager.this.m_factory.getOWLObjectComplementOf(d);
        }

        @Override
        public OWLClassExpression visit(OWLObjectSomeValuesFrom d) {
            OWLClassExpression filler = ExpressionManager.this.getComplementNNF((OWLClassExpression)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)d.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLObjectAllValuesFrom d) {
            OWLClassExpression filler = ExpressionManager.this.getComplementNNF((OWLClassExpression)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)d.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLObjectHasValue d) {
            return ExpressionManager.this.m_factory.getOWLObjectComplementOf(ExpressionManager.this.getNNF(d));
        }

        @Override
        public OWLClassExpression visit(OWLObjectHasSelf d) {
            return ExpressionManager.this.m_factory.getOWLObjectComplementOf(ExpressionManager.this.getNNF(d));
        }

        @Override
        public OWLClassExpression visit(OWLObjectMinCardinality d) {
            if (d.getCardinality() == 0) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            OWLClassExpression filler = ExpressionManager.this.getNNF((OWLClassExpression)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLObjectMaxCardinality(d.getCardinality() - 1, (OWLObjectPropertyExpression)d.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLObjectMaxCardinality d) {
            OWLClassExpression filler = ExpressionManager.this.getNNF((OWLClassExpression)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLObjectMinCardinality(d.getCardinality() + 1, (OWLObjectPropertyExpression)d.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLObjectExactCardinality d) {
            OWLClassExpression filler = ExpressionManager.this.getNNF((OWLClassExpression)d.getFiller());
            if (d.getCardinality() == 0) {
                return ExpressionManager.this.m_factory.getOWLObjectMinCardinality(1, (OWLObjectPropertyExpression)d.getProperty(), filler);
            }
            HashSet<OWLObjectCardinalityRestriction> disjuncts = new HashSet<OWLObjectCardinalityRestriction>();
            disjuncts.add(ExpressionManager.this.m_factory.getOWLObjectMaxCardinality(d.getCardinality() - 1, (OWLObjectPropertyExpression)d.getProperty(), filler));
            disjuncts.add(ExpressionManager.this.m_factory.getOWLObjectMinCardinality(d.getCardinality() + 1, (OWLObjectPropertyExpression)d.getProperty(), filler));
            return ExpressionManager.this.m_factory.getOWLObjectUnionOf(disjuncts);
        }

        @Override
        public OWLClassExpression visit(OWLDataSomeValuesFrom d) {
            OWLDataRange filler = ExpressionManager.this.getComplementNNF((OWLDataRange)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLDataAllValuesFrom((OWLDataPropertyExpression)d.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLDataAllValuesFrom d) {
            OWLDataRange filler = ExpressionManager.this.getComplementNNF((OWLDataRange)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)d.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLDataHasValue d) {
            return ExpressionManager.this.m_factory.getOWLObjectComplementOf(d);
        }

        @Override
        public OWLClassExpression visit(OWLDataMinCardinality d) {
            if (d.getCardinality() == 0) {
                return ExpressionManager.this.m_factory.getOWLNothing();
            }
            OWLDataRange filler = ExpressionManager.this.getNNF((OWLDataRange)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLDataMaxCardinality(d.getCardinality() - 1, (OWLDataPropertyExpression)d.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLDataMaxCardinality d) {
            OWLDataRange filler = ExpressionManager.this.getNNF((OWLDataRange)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLDataMinCardinality(d.getCardinality() + 1, (OWLDataPropertyExpression)d.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLDataExactCardinality d) {
            OWLDataRange filler = ExpressionManager.this.getNNF((OWLDataRange)d.getFiller());
            if (d.getCardinality() == 0) {
                return ExpressionManager.this.m_factory.getOWLDataMinCardinality(1, (OWLDataPropertyExpression)d.getProperty(), filler);
            }
            HashSet<OWLDataCardinalityRestriction> disjuncts = new HashSet<OWLDataCardinalityRestriction>();
            disjuncts.add(ExpressionManager.this.m_factory.getOWLDataMaxCardinality(d.getCardinality() - 1, (OWLDataPropertyExpression)d.getProperty(), filler));
            disjuncts.add(ExpressionManager.this.m_factory.getOWLDataMinCardinality(d.getCardinality() + 1, (OWLDataPropertyExpression)d.getProperty(), filler));
            return ExpressionManager.this.m_factory.getOWLObjectUnionOf(disjuncts);
        }
    }

    protected class DataRangeNNFVisitor
    implements OWLDataVisitorEx<OWLDataRange> {
        protected DataRangeNNFVisitor() {
        }

        @Override
        public OWLDataRange visit(OWLDatatype o) {
            return o;
        }

        @Override
        public OWLDataRange visit(OWLDataComplementOf o) {
            return ExpressionManager.this.getComplementNNF(o.getDataRange());
        }

        @Override
        public OWLDataRange visit(OWLDataOneOf o) {
            return o;
        }

        public OWLDataRange visit(OWLDataRange o) {
            return o;
        }

        @Override
        public OWLDataRange visit(OWLDatatypeRestriction o) {
            return o;
        }

        @Override
        public OWLDataRange visit(OWLFacetRestriction node) {
            return null;
        }

        @Override
        public OWLDataRange visit(OWLLiteral o) {
            return null;
        }

        @Override
        public OWLDataRange visit(OWLDataIntersectionOf range) {
            return ExpressionManager.this.m_factory.getOWLDataIntersectionOf(range.operands().map(dr -> ExpressionManager.this.getNNF((OWLDataRange)dr)).distinct());
        }

        @Override
        public OWLDataRange visit(OWLDataUnionOf range) {
            return ExpressionManager.this.m_factory.getOWLDataUnionOf(range.operands().map(dr -> ExpressionManager.this.getNNF((OWLDataRange)dr)).distinct());
        }
    }

    protected class DescriptionNNFVisitor
    implements OWLClassExpressionVisitorEx<OWLClassExpression> {
        protected DescriptionNNFVisitor() {
        }

        @Override
        public OWLClassExpression visit(OWLClass d) {
            return d;
        }

        @Override
        public OWLClassExpression visit(OWLObjectIntersectionOf d) {
            return ExpressionManager.this.m_factory.getOWLObjectIntersectionOf(d.operands().map(c -> ExpressionManager.this.getNNF((OWLClassExpression)c)).distinct());
        }

        @Override
        public OWLClassExpression visit(OWLObjectUnionOf d) {
            return ExpressionManager.this.m_factory.getOWLObjectUnionOf(d.operands().map(c -> ExpressionManager.this.getNNF((OWLClassExpression)c)).distinct());
        }

        @Override
        public OWLClassExpression visit(OWLObjectComplementOf d) {
            return ExpressionManager.this.getComplementNNF(d.getOperand());
        }

        @Override
        public OWLClassExpression visit(OWLObjectOneOf d) {
            return d;
        }

        @Override
        public OWLClassExpression visit(OWLObjectSomeValuesFrom d) {
            OWLClassExpression filler = ExpressionManager.this.getNNF((OWLClassExpression)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)d.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLObjectAllValuesFrom d) {
            OWLClassExpression filler = ExpressionManager.this.getNNF((OWLClassExpression)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)d.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLObjectHasValue d) {
            return ExpressionManager.this.m_factory.getOWLObjectHasValue((OWLObjectPropertyExpression)d.getProperty(), (OWLIndividual)d.getFiller());
        }

        @Override
        public OWLClassExpression visit(OWLObjectHasSelf d) {
            return ExpressionManager.this.m_factory.getOWLObjectHasSelf((OWLObjectPropertyExpression)d.getProperty());
        }

        @Override
        public OWLClassExpression visit(OWLObjectMinCardinality d) {
            OWLClassExpression filler = ExpressionManager.this.getNNF((OWLClassExpression)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLObjectMinCardinality(d.getCardinality(), (OWLObjectPropertyExpression)d.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLObjectMaxCardinality d) {
            OWLClassExpression filler = ExpressionManager.this.getNNF((OWLClassExpression)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLObjectMaxCardinality(d.getCardinality(), (OWLObjectPropertyExpression)d.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLObjectExactCardinality d) {
            OWLClassExpression filler = ExpressionManager.this.getNNF((OWLClassExpression)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLObjectExactCardinality(d.getCardinality(), (OWLObjectPropertyExpression)d.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLDataSomeValuesFrom d) {
            OWLDataRange filler = ExpressionManager.this.getNNF((OWLDataRange)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)d.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLDataAllValuesFrom d) {
            OWLDataRange filler = ExpressionManager.this.getNNF((OWLDataRange)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLDataAllValuesFrom((OWLDataPropertyExpression)d.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLDataHasValue d) {
            return d;
        }

        @Override
        public OWLClassExpression visit(OWLDataMinCardinality d) {
            OWLDataRange filler = ExpressionManager.this.getNNF((OWLDataRange)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLDataMinCardinality(d.getCardinality(), (OWLDataPropertyExpression)d.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLDataMaxCardinality d) {
            OWLDataRange filler = ExpressionManager.this.getNNF((OWLDataRange)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLDataMaxCardinality(d.getCardinality(), (OWLDataPropertyExpression)d.getProperty(), filler);
        }

        @Override
        public OWLClassExpression visit(OWLDataExactCardinality d) {
            OWLDataRange filler = ExpressionManager.this.getNNF((OWLDataRange)d.getFiller());
            return ExpressionManager.this.m_factory.getOWLDataExactCardinality(d.getCardinality(), (OWLDataPropertyExpression)d.getProperty(), filler);
        }
    }
}

