/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.structural;

import java.util.Arrays;
import java.util.List;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.structural.OWLAxioms;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;

public class BuiltInPropertyManager {
    protected final OWLDataFactory m_factory;
    protected final OWLObjectProperty m_topObjectProperty;
    protected final OWLObjectProperty m_bottomObjectProperty;
    protected final OWLDataProperty m_topDataProperty;
    protected final OWLDataProperty m_bottomDataProperty;

    public BuiltInPropertyManager(OWLDataFactory factory) {
        this.m_factory = factory;
        this.m_topObjectProperty = this.m_factory.getOWLObjectProperty(IRI.create(AtomicRole.TOP_OBJECT_ROLE.getIRI()));
        this.m_bottomObjectProperty = this.m_factory.getOWLObjectProperty(IRI.create(AtomicRole.BOTTOM_OBJECT_ROLE.getIRI()));
        this.m_topDataProperty = this.m_factory.getOWLDataProperty(IRI.create(AtomicRole.TOP_DATA_ROLE.getIRI()));
        this.m_bottomDataProperty = this.m_factory.getOWLDataProperty(IRI.create(AtomicRole.BOTTOM_DATA_ROLE.getIRI()));
    }

    public void axiomatizeBuiltInPropertiesAsNeeded(OWLAxioms axioms, boolean skipTopObjectProperty, boolean skipBottomObjectProperty, boolean skipTopDataProperty, boolean skipBottomDataProperty) {
        Checker checker = new Checker(axioms);
        if (checker.m_usesTopObjectProperty && !skipTopObjectProperty) {
            this.axiomatizeTopObjectProperty(axioms);
        }
        if (checker.m_usesBottomObjectProperty && !skipBottomObjectProperty) {
            this.axiomatizeBottomObjectProperty(axioms);
        }
        if (checker.m_usesTopDataProperty && !skipTopDataProperty) {
            this.axiomatizeTopDataProperty(axioms);
        }
        if (checker.m_usesBottomDataProperty && !skipBottomDataProperty) {
            this.axiomatizeBottomDataProperty(axioms);
        }
    }

    public void axiomatizeBuiltInPropertiesAsNeeded(OWLAxioms axioms) {
        this.axiomatizeBuiltInPropertiesAsNeeded(axioms, false, false, false, false);
    }

    protected void axiomatizeTopObjectProperty(OWLAxioms axioms) {
        axioms.m_complexObjectPropertyInclusions.add(new OWLAxioms.ComplexObjectPropertyInclusion(this.m_topObjectProperty));
        axioms.m_simpleObjectPropertyInclusions.add(Arrays.asList(this.m_topObjectProperty, this.m_topObjectProperty.getInverseProperty()));
        OWLNamedIndividual newIndividual = this.m_factory.getOWLNamedIndividual(IRI.create("internal:nam#topIndividual"));
        OWLObjectOneOf oneOfNewIndividual = this.m_factory.getOWLObjectOneOf(newIndividual);
        OWLObjectSomeValuesFrom hasTopNewIndividual = this.m_factory.getOWLObjectSomeValuesFrom(this.m_topObjectProperty, oneOfNewIndividual);
        axioms.m_conceptInclusions.add(Arrays.asList(hasTopNewIndividual));
    }

    protected void axiomatizeBottomObjectProperty(OWLAxioms axioms) {
        axioms.m_conceptInclusions.add(Arrays.asList(this.m_factory.getOWLObjectAllValuesFrom(this.m_bottomObjectProperty, this.m_factory.getOWLNothing())));
    }

    protected void axiomatizeTopDataProperty(OWLAxioms axioms) {
        OWLDatatype anonymousConstantsDatatype = this.m_factory.getOWLDatatype(IRI.create("internal:anonymous-constants"));
        OWLLiteral newConstant = this.m_factory.getOWLLiteral("internal:constant", anonymousConstantsDatatype);
        OWLDataOneOf oneOfNewConstant = this.m_factory.getOWLDataOneOf(newConstant);
        OWLDataSomeValuesFrom hasTopNewConstant = this.m_factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)this.m_topDataProperty, oneOfNewConstant);
        axioms.m_conceptInclusions.add(Arrays.asList(hasTopNewConstant));
    }

    protected void axiomatizeBottomDataProperty(OWLAxioms axioms) {
        axioms.m_conceptInclusions.add(Arrays.asList(this.m_factory.getOWLDataAllValuesFrom((OWLDataPropertyExpression)this.m_bottomDataProperty, this.m_factory.getOWLDataComplementOf(this.m_factory.getTopDatatype()))));
    }

    protected class Checker
    implements OWLClassExpressionVisitor {
        public boolean m_usesTopObjectProperty;
        public boolean m_usesBottomObjectProperty;
        public boolean m_usesTopDataProperty;
        public boolean m_usesBottomDataProperty;

        public Checker(OWLAxioms axioms) {
            axioms.m_conceptInclusions.forEach(c -> c.forEach(d -> d.accept(this)));
            for (List<OWLObjectPropertyExpression> list : axioms.m_simpleObjectPropertyInclusions) {
                this.visitProperty(list.get(0));
                this.visitProperty(list.get(1));
            }
            for (OWLAxioms.ComplexObjectPropertyInclusion complexObjectPropertyInclusion : axioms.m_complexObjectPropertyInclusions) {
                for (OWLObjectPropertyExpression subObjectProperty : complexObjectPropertyInclusion.m_subObjectProperties) {
                    this.visitProperty(subObjectProperty);
                }
                this.visitProperty(complexObjectPropertyInclusion.m_superObjectProperty);
            }
            axioms.m_disjointObjectProperties.forEach(c -> c.forEach(d -> this.visitProperty((OWLObjectPropertyExpression)d)));
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression : axioms.m_reflexiveObjectProperties) {
                this.visitProperty(oWLObjectPropertyExpression);
            }
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression : axioms.m_irreflexiveObjectProperties) {
                this.visitProperty(oWLObjectPropertyExpression);
            }
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression : axioms.m_asymmetricObjectProperties) {
                this.visitProperty(oWLObjectPropertyExpression);
            }
            for (List list : axioms.m_dataPropertyInclusions) {
                this.visitProperty((OWLDataPropertyExpression)list.get(0));
                this.visitProperty((OWLDataPropertyExpression)list.get(1));
            }
            for (List list : axioms.m_disjointDataProperties) {
                for (int index = 0; index < list.size(); ++index) {
                    this.visitProperty((OWLDataPropertyExpression)list.get(index));
                }
            }
            FactVisitor factVisitor = new FactVisitor();
            for (OWLIndividualAxiom fact : axioms.m_facts) {
                fact.accept(factVisitor);
            }
        }

        protected void visitProperty(OWLObjectPropertyExpression object) {
            if (object.getNamedProperty().equals(BuiltInPropertyManager.this.m_topObjectProperty)) {
                this.m_usesTopObjectProperty = true;
            } else if (object.getNamedProperty().equals(BuiltInPropertyManager.this.m_bottomObjectProperty)) {
                this.m_usesBottomObjectProperty = true;
            }
        }

        protected void visitProperty(OWLDataPropertyExpression object) {
            if (object.asOWLDataProperty().equals(BuiltInPropertyManager.this.m_topDataProperty)) {
                this.m_usesTopDataProperty = true;
            } else if (object.asOWLDataProperty().equals(BuiltInPropertyManager.this.m_bottomDataProperty)) {
                this.m_usesBottomDataProperty = true;
            }
        }

        @Override
        public void visit(OWLClass object) {
        }

        @Override
        public void visit(OWLObjectComplementOf object) {
            object.getOperand().accept(this);
        }

        @Override
        public void visit(OWLObjectIntersectionOf object) {
            object.operands().forEach(d -> d.accept(this));
        }

        @Override
        public void visit(OWLObjectUnionOf object) {
            object.operands().forEach(d -> d.accept(this));
        }

        @Override
        public void visit(OWLObjectOneOf object) {
        }

        @Override
        public void visit(OWLObjectSomeValuesFrom object) {
            this.visitProperty((OWLObjectPropertyExpression)object.getProperty());
            ((OWLClassExpression)object.getFiller()).accept(this);
        }

        @Override
        public void visit(OWLObjectHasValue object) {
            this.visitProperty((OWLObjectPropertyExpression)object.getProperty());
        }

        @Override
        public void visit(OWLObjectHasSelf object) {
            this.visitProperty((OWLObjectPropertyExpression)object.getProperty());
        }

        @Override
        public void visit(OWLObjectAllValuesFrom object) {
            this.visitProperty((OWLObjectPropertyExpression)object.getProperty());
            ((OWLClassExpression)object.getFiller()).accept(this);
        }

        @Override
        public void visit(OWLObjectMinCardinality object) {
            this.visitProperty((OWLObjectPropertyExpression)object.getProperty());
            ((OWLClassExpression)object.getFiller()).accept(this);
        }

        @Override
        public void visit(OWLObjectMaxCardinality object) {
            this.visitProperty((OWLObjectPropertyExpression)object.getProperty());
            ((OWLClassExpression)object.getFiller()).accept(this);
        }

        @Override
        public void visit(OWLObjectExactCardinality object) {
            this.visitProperty((OWLObjectPropertyExpression)object.getProperty());
            ((OWLClassExpression)object.getFiller()).accept(this);
        }

        @Override
        public void visit(OWLDataHasValue object) {
            this.visitProperty((OWLDataPropertyExpression)object.getProperty());
        }

        @Override
        public void visit(OWLDataSomeValuesFrom object) {
            this.visitProperty((OWLDataPropertyExpression)object.getProperty());
        }

        @Override
        public void visit(OWLDataAllValuesFrom object) {
            this.visitProperty((OWLDataPropertyExpression)object.getProperty());
        }

        @Override
        public void visit(OWLDataMinCardinality object) {
            this.visitProperty((OWLDataPropertyExpression)object.getProperty());
        }

        @Override
        public void visit(OWLDataMaxCardinality object) {
            this.visitProperty((OWLDataPropertyExpression)object.getProperty());
        }

        @Override
        public void visit(OWLDataExactCardinality object) {
            this.visitProperty((OWLDataPropertyExpression)object.getProperty());
        }

        protected class FactVisitor
        implements OWLAxiomVisitor {
            protected FactVisitor() {
            }

            @Override
            public void visit(OWLClassAssertionAxiom object) {
                object.getClassExpression().accept(Checker.this);
            }

            @Override
            public void visit(OWLObjectPropertyAssertionAxiom object) {
                Checker.this.visitProperty((OWLObjectPropertyExpression)object.getProperty());
            }

            @Override
            public void visit(OWLNegativeObjectPropertyAssertionAxiom object) {
                Checker.this.visitProperty((OWLObjectPropertyExpression)object.getProperty());
            }

            @Override
            public void visit(OWLDataPropertyAssertionAxiom object) {
                Checker.this.visitProperty((OWLDataPropertyExpression)object.getProperty());
            }

            @Override
            public void visit(OWLNegativeDataPropertyAssertionAxiom object) {
                Checker.this.visitProperty((OWLDataPropertyExpression)object.getProperty());
            }
        }
    }
}

