/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.rdfxml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.rdf4j.common.xml.XMLUtil;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFWriter;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.XMLWriterSettings;

public class RDFXMLWriter
extends AbstractRDFWriter
implements RDFWriter {
    protected Writer writer;
    protected String defaultNamespace;
    protected boolean writingStarted;
    protected boolean headerWritten;
    protected Resource lastWrittenSubject;

    public RDFXMLWriter(OutputStream out) {
        this(new OutputStreamWriter(out, Charset.forName("UTF-8")));
    }

    public RDFXMLWriter(Writer writer) {
        this.writer = writer;
        this.namespaceTable = new LinkedHashMap();
        this.writingStarted = false;
        this.headerWritten = false;
        this.lastWrittenSubject = null;
    }

    @Override
    public RDFFormat getRDFFormat() {
        return RDFFormat.RDFXML;
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        if (this.writingStarted) {
            throw new RDFHandlerException("Document writing has already started");
        }
        this.writingStarted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeHeader() throws IOException {
        try {
            this.setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            if (this.getWriterConfig().get(XMLWriterSettings.INCLUDE_XML_PI).booleanValue()) {
                this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            }
            if (this.getWriterConfig().get(XMLWriterSettings.INCLUDE_ROOT_RDF_TAG).booleanValue()) {
                this.writeStartOfStartTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF");
                if (this.defaultNamespace != null) {
                    this.writeNewLine();
                    this.writeIndent();
                    this.writer.write("xmlns=\"");
                    this.writer.write(XMLUtil.escapeDoubleQuotedAttValue(this.defaultNamespace));
                    this.writer.write("\"");
                }
                for (Map.Entry entry : this.namespaceTable.entrySet()) {
                    String name = (String)entry.getKey();
                    String prefix = (String)entry.getValue();
                    this.writeNewLine();
                    this.writeIndent();
                    this.writer.write("xmlns:");
                    this.writer.write(prefix);
                    this.writer.write("=\"");
                    this.writer.write(XMLUtil.escapeDoubleQuotedAttValue(name));
                    this.writer.write("\"");
                }
                this.writeEndOfStartTag();
            }
            this.writeNewLine();
        }
        finally {
            this.headerWritten = true;
        }
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RDFHandlerException("Document writing has not yet started");
        }
        try {
            if (!this.headerWritten) {
                this.writeHeader();
            }
            this.flushPendingStatements();
            this.writeNewLine();
            if (this.getWriterConfig().get(XMLWriterSettings.INCLUDE_ROOT_RDF_TAG).booleanValue()) {
                this.writeEndTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF");
            }
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
        finally {
            this.writingStarted = false;
            this.headerWritten = false;
        }
    }

    @Override
    public void handleNamespace(String prefix, String name) {
        this.setNamespace(prefix, name);
    }

    protected void setNamespace(String prefix, String name) {
        if (this.headerWritten) {
            return;
        }
        if (prefix.length() == 0) {
            this.defaultNamespace = name;
            return;
        }
        if (this.namespaceTable.containsKey(name)) {
            return;
        }
        boolean isLegalPrefix = XMLUtil.isNCName(prefix);
        if (!isLegalPrefix || this.namespaceTable.containsValue(prefix)) {
            if (!isLegalPrefix) {
                prefix = "ns";
            }
            int number = 1;
            while (this.namespaceTable.containsValue(prefix + number)) {
                ++number;
            }
            prefix = prefix + number;
        }
        this.namespaceTable.put(name, prefix);
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RDFHandlerException("Document writing has not yet been started");
        }
        Resource subj = st.getSubject();
        IRI pred = st.getPredicate();
        Value obj = st.getObject();
        String predString = pred.toString();
        int predSplitIdx = XMLUtil.findURISplitIndex(predString);
        if (predSplitIdx == -1) {
            throw new RDFHandlerException("Unable to create XML namespace-qualified name for predicate: " + predString);
        }
        String predNamespace = predString.substring(0, predSplitIdx);
        String predLocalName = predString.substring(predSplitIdx);
        try {
            if (!this.headerWritten) {
                this.writeHeader();
            }
            if (!subj.equals(this.lastWrittenSubject)) {
                this.flushPendingStatements();
                this.writeNewLine();
                this.writeStartOfStartTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
                if (subj instanceof BNode) {
                    BNode bNode = (BNode)subj;
                    this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID", this.getValidNodeId(bNode));
                } else {
                    IRI uri = (IRI)subj;
                    this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about", uri.toString());
                }
                this.writeEndOfStartTag();
                this.writeNewLine();
                this.lastWrittenSubject = subj;
            }
            this.writeIndent();
            this.writeStartOfStartTag(predNamespace, predLocalName);
            if (obj instanceof Resource) {
                Resource objRes = (Resource)obj;
                if (objRes instanceof BNode) {
                    BNode bNode = (BNode)objRes;
                    this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID", this.getValidNodeId(bNode));
                } else {
                    IRI uri = (IRI)objRes;
                    this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", uri.toString());
                }
                this.writeEndOfEmptyTag();
            } else if (obj instanceof Literal) {
                Literal objLit = (Literal)obj;
                boolean isXMLLiteral = false;
                if (Literals.isLanguageLiteral(objLit)) {
                    this.writeAttribute("xml:lang", objLit.getLanguage().get());
                } else {
                    IRI datatype = objLit.getDatatype();
                    isXMLLiteral = datatype.equals(RDF.XMLLITERAL);
                    if (isXMLLiteral) {
                        this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType", "Literal");
                    } else {
                        this.writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype", datatype.toString());
                    }
                }
                this.writeEndOfStartTag();
                if (isXMLLiteral) {
                    this.writer.write(objLit.getLabel());
                } else {
                    this.writeCharacterData(objLit.getLabel());
                }
                this.writeEndTag(predNamespace, predLocalName);
            }
            this.writeNewLine();
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
    }

    @Override
    public void handleComment(String comment) throws RDFHandlerException {
        try {
            if (!this.headerWritten) {
                this.writeHeader();
            }
            this.flushPendingStatements();
            this.writer.write("<!-- ");
            this.writer.write(comment);
            this.writer.write(" -->");
            this.writeNewLine();
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
    }

    protected void flushPendingStatements() throws IOException, RDFHandlerException {
        if (this.lastWrittenSubject != null) {
            this.writeEndTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
            this.writeNewLine();
            this.lastWrittenSubject = null;
        }
    }

    protected void writeStartOfStartTag(String namespace, String localName) throws IOException {
        if (namespace.equals(this.defaultNamespace)) {
            this.writer.write("<");
            this.writer.write(localName);
        } else {
            String prefix = (String)this.namespaceTable.get(namespace);
            if (prefix == null || !this.getWriterConfig().get(XMLWriterSettings.INCLUDE_ROOT_RDF_TAG).booleanValue()) {
                this.writer.write("<");
                this.writer.write(localName);
                this.writer.write(" xmlns=\"");
                this.writer.write(XMLUtil.escapeDoubleQuotedAttValue(namespace));
                this.writer.write("\"");
            } else {
                this.writer.write("<");
                this.writer.write(prefix);
                this.writer.write(":");
                this.writer.write(localName);
            }
        }
    }

    protected void writeAttribute(String attName, String value) throws IOException {
        this.writer.write(" ");
        this.writer.write(attName);
        this.writer.write("=\"");
        this.writer.write(XMLUtil.escapeDoubleQuotedAttValue(value));
        this.writer.write("\"");
    }

    protected void writeAttribute(String namespace, String attName, String value) throws IOException, RDFHandlerException {
        String prefix = (String)this.namespaceTable.get(namespace);
        if (prefix == null) {
            throw new RDFHandlerException("No prefix has been declared for the namespace used in this attribute: " + namespace);
        }
        this.writer.write(" ");
        this.writer.write(prefix);
        this.writer.write(":");
        this.writer.write(attName);
        this.writer.write("=\"");
        this.writer.write(XMLUtil.escapeDoubleQuotedAttValue(value));
        this.writer.write("\"");
    }

    protected void writeEndOfStartTag() throws IOException {
        this.writer.write(">");
    }

    protected void writeEndOfEmptyTag() throws IOException {
        this.writer.write("/>");
    }

    protected void writeEndTag(String namespace, String localName) throws IOException {
        if (namespace.equals(this.defaultNamespace)) {
            this.writer.write("</");
            this.writer.write(localName);
            this.writer.write(">");
        } else {
            this.writer.write("</");
            String prefix = (String)this.namespaceTable.get(namespace);
            if (prefix != null) {
                this.writer.write(prefix);
                this.writer.write(":");
            }
            this.writer.write(localName);
            this.writer.write(">");
        }
    }

    protected void writeCharacterData(String chars) throws IOException {
        this.writer.write(XMLUtil.escapeCharacterData(chars));
    }

    protected void writeIndent() throws IOException {
        this.writer.write("\t");
    }

    protected void writeNewLine() throws IOException {
        this.writer.write("\n");
    }

    protected String getValidNodeId(BNode bNode) throws IOException {
        String validNodeId = bNode.getID();
        if (!XMLUtil.isNCName(validNodeId)) {
            StringBuilder builder = new StringBuilder();
            if (validNodeId.isEmpty()) {
                if (this.getWriterConfig().get(BasicParserSettings.PRESERVE_BNODE_IDS).booleanValue()) {
                    throw new IOException("Cannot consistently write blank nodes with empty internal identifiers");
                }
                builder.append("genid-hash-");
                builder.append(Integer.toHexString(System.identityHashCode(bNode)));
            } else {
                if (!XMLUtil.isNCNameStartChar(validNodeId.charAt(0))) {
                    builder.append("genid-start-");
                    builder.append(Integer.toHexString(validNodeId.charAt(0)));
                } else {
                    builder.append(validNodeId.charAt(0));
                }
                for (int i = 1; i < validNodeId.length(); ++i) {
                    if (XMLUtil.isNCNameChar(validNodeId.charAt(i))) {
                        builder.append(validNodeId.charAt(i));
                        continue;
                    }
                    builder.append(Integer.toHexString(validNodeId.charAt(i)));
                }
            }
            validNodeId = builder.toString();
        }
        return validNodeId;
    }
}

