/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.jsonld;

import com.fasterxml.jackson.core.JsonParseException;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFParser;
import org.eclipse.rdf4j.rio.jsonld.JSONLDInternalTripleCallback;

public class JSONLDParser
extends AbstractRDFParser
implements RDFParser {
    public JSONLDParser() {
    }

    public JSONLDParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    @Override
    public RDFFormat getRDFFormat() {
        return RDFFormat.JSONLD;
    }

    @Override
    public void parse(InputStream in, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        JSONLDInternalTripleCallback callback = new JSONLDInternalTripleCallback(this.getRDFHandler(), this.valueFactory, this.getParserConfig(), this.getParseErrorListener());
        JsonLdOptions options = new JsonLdOptions(baseURI);
        options.useNamespaces = true;
        try {
            JsonLdProcessor.toRDF(JsonUtils.fromInputStream(in), callback, options);
        }
        catch (JsonLdError e) {
            throw new RDFParseException("Could not parse JSONLD", e);
        }
        catch (JsonParseException e) {
            throw new RDFParseException("Could not parse JSONLD", e);
        }
        catch (RuntimeException e) {
            if (e.getCause() != null && e.getCause() instanceof RDFParseException) {
                throw (RDFParseException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        JSONLDInternalTripleCallback callback = new JSONLDInternalTripleCallback(this.getRDFHandler(), this.valueFactory, this.getParserConfig(), this.getParseErrorListener());
        JsonLdOptions options = new JsonLdOptions(baseURI);
        options.useNamespaces = true;
        try {
            JsonLdProcessor.toRDF(JsonUtils.fromReader(reader), callback, options);
        }
        catch (JsonLdError e) {
            throw new RDFParseException("Could not parse JSONLD", e);
        }
        catch (JsonParseException e) {
            throw new RDFParseException("Could not parse JSONLD", e);
        }
        catch (RuntimeException e) {
            if (e.getCause() != null && e.getCause() instanceof RDFParseException) {
                throw (RDFParseException)e.getCause();
            }
            throw e;
        }
    }
}

