/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.binary;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.binary.BinaryRDFConstants;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFParser;

public class BinaryRDFParser
extends AbstractRDFParser {
    private Value[] declaredValues = new Value[16];
    private DataInputStream in;
    private byte[] buf = null;

    @Override
    public RDFFormat getRDFFormat() {
        return RDFFormat.BINARY;
    }

    @Override
    public void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void parse(InputStream in, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        block17: {
            if (in == null) {
                throw new IllegalArgumentException("Input stream must not be null");
            }
            this.in = new DataInputStream(new BufferedInputStream(in));
            magicNumber = IOUtil.readBytes(in, BinaryRDFConstants.MAGIC_NUMBER.length);
            if (!Arrays.equals(magicNumber, BinaryRDFConstants.MAGIC_NUMBER)) {
                this.reportFatalError("File does not contain a binary RDF document");
            }
            if ((formatVersion = this.in.readInt()) != 1) {
                this.reportFatalError("Incompatible format version: " + formatVersion);
            }
            if (this.rdfHandler != null) {
                this.rdfHandler.startRDF();
            }
            block10: while (true) {
                block11: while (true) {
                    recordType = this.in.readByte();
                    switch (recordType) {
                        case 127: {
                            ** break;
lbl18:
                            // 1 sources

                            break block17;
                        }
                        case 1: {
                            this.readStatement();
                            continue block10;
                        }
                        case 3: {
                            this.readValueDecl();
                            continue block10;
                        }
                        case 0: {
                            this.readNamespaceDecl();
                            continue block10;
                        }
                        case 2: {
                            this.readComment();
                            continue block10;
                        }
                        default: {
                            this.reportFatalError("Invalid record type: " + recordType);
                            continue block11;
                        }
                    }
                    break;
                }
                break;
            }
            finally {
                this.clear();
            }
        }
        if (this.rdfHandler != null) {
            this.rdfHandler.endRDF();
        }
    }

    private void readNamespaceDecl() throws IOException, RDFHandlerException {
        String prefix = this.readString();
        String namespace = this.readString();
        if (this.rdfHandler != null) {
            this.rdfHandler.handleNamespace(prefix, namespace);
        }
    }

    private void readComment() throws IOException, RDFHandlerException {
        String comment = this.readString();
        if (this.rdfHandler != null) {
            this.rdfHandler.handleComment(comment);
        }
    }

    private void readValueDecl() throws IOException, RDFParseException {
        int id = this.in.readInt();
        Value v = this.readValue();
        if (id >= this.declaredValues.length) {
            Value[] newArray = new Value[2 * this.declaredValues.length];
            System.arraycopy(this.declaredValues, 0, newArray, 0, this.declaredValues.length);
            this.declaredValues = newArray;
        }
        this.declaredValues[id] = v;
    }

    private void readStatement() throws RDFParseException, IOException, RDFHandlerException {
        Value v = this.readValue();
        Resource subj = null;
        if (v instanceof Resource) {
            subj = (Resource)v;
        } else {
            this.reportFatalError("Invalid subject type: " + v);
        }
        v = this.readValue();
        IRI pred = null;
        if (v instanceof IRI) {
            pred = (IRI)v;
        } else {
            this.reportFatalError("Invalid predicate type: " + v);
        }
        Value obj = this.readValue();
        if (obj == null) {
            this.reportFatalError("Invalid object type: null");
        }
        v = this.readValue();
        Resource context = null;
        if (v == null || v instanceof Resource) {
            context = (Resource)v;
        } else {
            this.reportFatalError("Invalid context type: " + v);
        }
        Statement st = this.createStatement(subj, pred, obj, context);
        if (this.rdfHandler != null) {
            this.rdfHandler.handleStatement(st);
        }
    }

    private Value readValue() throws RDFParseException, IOException {
        byte valueType = this.in.readByte();
        switch (valueType) {
            case 0: {
                return null;
            }
            case 6: {
                return this.readValueRef();
            }
            case 1: {
                return this.readURI();
            }
            case 2: {
                return this.readBNode();
            }
            case 3: {
                return this.readPlainLiteral();
            }
            case 4: {
                return this.readLangLiteral();
            }
            case 5: {
                return this.readDatatypeLiteral();
            }
        }
        this.reportFatalError("Unknown value type: " + valueType);
        return null;
    }

    private Value readValueRef() throws IOException, RDFParseException {
        int id = this.in.readInt();
        return this.declaredValues[id];
    }

    private IRI readURI() throws IOException, RDFParseException {
        String uri = this.readString();
        return this.createURI(uri);
    }

    private BNode readBNode() throws IOException, RDFParseException {
        String bnodeID = this.readString();
        return this.createBNode(bnodeID);
    }

    private Literal readPlainLiteral() throws IOException, RDFParseException {
        String label = this.readString();
        return this.createLiteral(label, null, null, -1L, -1L);
    }

    private Literal readLangLiteral() throws IOException, RDFParseException {
        String label = this.readString();
        String language = this.readString();
        return this.createLiteral(label, language, null, -1L, -1L);
    }

    private Literal readDatatypeLiteral() throws IOException, RDFParseException {
        String label = this.readString();
        String datatype = this.readString();
        IRI dtUri = this.createURI(datatype);
        return this.createLiteral(label, null, dtUri, -1L, -1L);
    }

    private String readString() throws IOException {
        int stringLength = this.in.readInt();
        int stringBytes = stringLength << 1;
        if (this.buf == null || this.buf.length < stringBytes) {
            this.buf = new byte[stringBytes << 1];
        }
        this.in.readFully(this.buf, 0, stringBytes);
        return new String(this.buf, 0, stringBytes, "UTF-16BE");
    }
}

