/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.OMConstants;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.dom.AttrImpl;
import org.apache.axiom.om.impl.dom.AttributeMap;
import org.apache.axiom.om.impl.dom.DOMConfigurationImpl;
import org.apache.axiom.om.impl.dom.DOMUtil;
import org.apache.axiom.om.impl.dom.IElement;
import org.apache.axiom.om.impl.dom.IParentNode;
import org.apache.axiom.om.impl.dom.NSDeclIterator;
import org.apache.axiom.om.impl.dom.NamedNode;
import org.apache.axiom.om.impl.dom.NamedNodeHelper;
import org.apache.axiom.om.impl.dom.NamespaceImpl;
import org.apache.axiom.om.impl.dom.NamespaceIterator;
import org.apache.axiom.om.impl.dom.NodeImpl;
import org.apache.axiom.om.impl.dom.NodeListImpl;
import org.apache.axiom.om.impl.dom.OMChildElementIterator;
import org.apache.axiom.om.impl.dom.OMContainerHelper;
import org.apache.axiom.om.impl.dom.OMElementImplUtil;
import org.apache.axiom.om.impl.dom.OMNodeHelper;
import org.apache.axiom.om.impl.dom.ParentNode;
import org.apache.axiom.om.impl.traverse.OMQNameFilterIterator;
import org.apache.axiom.om.impl.traverse.OMQualifiedNameFilterIterator;
import org.apache.axiom.om.impl.util.EmptyIterator;
import org.apache.axiom.om.impl.util.OMSerializerUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class ElementImpl
extends ParentNode
implements Element,
IElement,
NamedNode,
OMConstants {
    private static final Log log = LogFactory.getLog(ElementImpl.class);
    protected OMXMLParserWrapper builder;
    protected int state;
    private ParentNode ownerNode;
    private NodeImpl previousSibling;
    private NodeImpl nextSibling;
    private int lineNumber;
    protected OMNamespace namespace;
    protected String localName;
    private AttributeMap attributes;
    private static final EmptyIterator EMPTY_ITERATOR = new EmptyIterator();

    public ElementImpl(ParentNode parentNode, String localName, OMNamespace ns, OMXMLParserWrapper builder, OMFactory factory, boolean generateNSDecl) {
        super(factory);
        this.localName = localName;
        this.builder = builder;
        int n = this.state = builder == null ? 1 : 0;
        if (parentNode != null) {
            parentNode.addChild(this, builder != null);
        }
        this.attributes = new AttributeMap(this);
        this.namespace = generateNSDecl ? this.handleNamespace(ns) : ns;
    }

    final ParentNode internalGetOwnerNode() {
        return this.ownerNode;
    }

    final void internalSetOwnerNode(ParentNode ownerNode) {
        this.ownerNode = ownerNode;
    }

    final NodeImpl internalGetPreviousSibling() {
        return this.previousSibling;
    }

    final NodeImpl internalGetNextSibling() {
        return this.nextSibling;
    }

    final void internalSetPreviousSibling(NodeImpl previousSibling) {
        this.previousSibling = previousSibling;
    }

    final void internalSetNextSibling(NodeImpl nextSibling) {
        this.nextSibling = nextSibling;
    }

    private OMNamespace handleNamespace(OMNamespace ns) {
        String prefix;
        String namespaceURI = ns == null ? "" : ns.getNamespaceURI();
        String string = prefix = ns == null ? "" : ns.getPrefix();
        if (namespaceURI.length() == 0 && prefix != null && prefix.length() > 0) {
            throw new IllegalArgumentException("Cannot create a prefixed element with an empty namespace name");
        }
        if (namespaceURI.length() == 0) {
            if (this.getDefaultNamespace() != null) {
                this.declareDefaultNamespace("");
            }
            return null;
        }
        OMNamespace namespace = this.findNamespace(namespaceURI, prefix);
        if (namespace == null || prefix != null && !namespace.getPrefix().equals(prefix)) {
            namespace = this.declareNamespace(ns);
        }
        return namespace;
    }

    OMNamespace handleNamespace(String namespaceURI, String prefix) {
        if (prefix.length() == 0 && namespaceURI.length() == 0) {
            OMNamespace namespace = this.getDefaultNamespace();
            if (namespace != null) {
                this.declareDefaultNamespace("");
            }
            return null;
        }
        OMNamespace namespace = this.findNamespace(namespaceURI, prefix);
        if (namespace == null) {
            namespace = this.declareNamespace(namespaceURI, prefix.length() > 0 ? prefix : null);
        }
        return namespace;
    }

    public short getNodeType() {
        return 1;
    }

    public String getNodeName() {
        if (this.namespace != null) {
            if (this.namespace.getPrefix() == null || "".equals(this.namespace.getPrefix())) {
                return this.localName;
            }
            return this.namespace.getPrefix() + ":" + this.localName;
        }
        return this.localName;
    }

    public String getNamespaceURI() {
        if (this.namespace == null) {
            return null;
        }
        String uri = this.namespace.getNamespaceURI();
        return uri.length() == 0 ? null : uri.intern();
    }

    public int getType() throws OMException {
        return 1;
    }

    public String getTagName() {
        return this.getNodeName();
    }

    public void removeAttribute(String name) throws DOMException {
        if (this.attributes != null) {
            this.attributes.removeNamedItem(name);
        }
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        if (this.attributes != null) {
            this.attributes.removeNamedItemNS(namespaceURI, localName);
        }
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        if (oldAttr.getOwnerElement() != this) {
            throw DOMUtil.newDOMException((short)8);
        }
        this.attributes.remove((AttrImpl)oldAttr, true);
        return oldAttr;
    }

    public boolean hasAttribute(String name) {
        return this.getAttributeNode(name) != null;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.getAttributeNodeNS(namespaceURI, localName) != null;
    }

    public String getAttribute(String name) {
        if (this.attributes == null) {
            return "";
        }
        Attr attr = (Attr)this.attributes.getNamedItem(name);
        return attr != null ? attr.getValue() : "";
    }

    public Attr getAttributeNode(String name) {
        return this.attributes == null ? null : (AttrImpl)this.attributes.getNamedItem(name);
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        if (this.attributes == null) {
            return "";
        }
        Attr attributeNodeNS = this.getAttributeNodeNS(namespaceURI, localName);
        return attributeNodeNS == null ? "" : attributeNodeNS.getValue();
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return this.attributes == null ? null : (Attr)this.attributes.getNamedItemNS(namespaceURI, localName);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        AttrImpl attrImpl = (AttrImpl)attr;
        this.checkSameOwnerDocument(attr);
        attrImpl.checkInUse();
        if (attr.getNodeName().startsWith("xmlns:")) {
            this.declareNamespace(attr.getNodeValue(), DOMUtil.getLocalName(attr.getName()));
            return attr;
        }
        if (attr.getNodeName().equals("xmlns")) {
            this.declareDefaultNamespace(attr.getValue());
            return attr;
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this);
        }
        return (Attr)this.attributes.setNamedItem(attr);
    }

    public void setAttribute(String name, String value) throws DOMException {
        if (!DOMUtil.isQualifiedName(name)) {
            throw DOMUtil.newDOMException((short)5);
        }
        if (name.startsWith("xmlns:")) {
            this.declareNamespace(value, DOMUtil.getLocalName(name));
        } else if (name.equals("xmlns")) {
            this.declareDefaultNamespace(value);
        } else {
            this.setAttributeNode(new AttrImpl(this.ownerDocument(), name, value, this.factory));
        }
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        return this.setAttributeNodeNS(attr, true, false);
    }

    private Attr setAttributeNodeNS(Attr attr, boolean useDomSemantics, boolean generateNSDecl) throws DOMException {
        AttrImpl attrImpl = (AttrImpl)attr;
        if (useDomSemantics) {
            this.checkSameOwnerDocument(attr);
        }
        attrImpl.checkInUse();
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this);
        }
        if (generateNSDecl && attr.getNamespaceURI() != null && this.findNamespace(attr.getNamespaceURI(), attr.getPrefix()) == null) {
            this.declareNamespace(new NamespaceImpl(attr.getNamespaceURI(), attr.getPrefix()));
        }
        return (Attr)this.attributes.setAttribute(attr, useDomSemantics);
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        if (namespaceURI != null && namespaceURI.length() == 0) {
            namespaceURI = null;
        }
        String localName = DOMUtil.getLocalName(qualifiedName);
        String prefix = DOMUtil.getPrefix(qualifiedName);
        DOMUtil.validateAttrNamespace(namespaceURI, localName, prefix);
        AttrImpl attr = (AttrImpl)this.getAttributeNodeNS(namespaceURI, localName);
        if (attr != null) {
            attr.setPrefix(prefix);
            attr.setValue(value);
        } else if (namespaceURI != null) {
            attr = new AttrImpl(this.ownerDocument(), localName, value, this.factory);
            attr.setOMNamespace(new NamespaceImpl(namespaceURI, prefix));
            this.setAttributeNodeNS(attr);
        } else {
            this.setAttribute(localName, value);
        }
    }

    public boolean hasAttributes() {
        return this.attributes != null && this.attributes.getLength() > 0;
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        final QName qname = new QName(namespaceURI, localName);
        return new NodeListImpl(){

            protected Iterator getIterator() {
                return new OMQNameFilterIterator(ElementImpl.this.getDescendants(false), qname);
            }
        };
    }

    public NodeList getElementsByTagName(final String name) {
        if (name.equals("*")) {
            return new NodeListImpl(){

                protected Iterator getIterator() {
                    return ElementImpl.this.getDescendants(false);
                }
            };
        }
        return new NodeListImpl(){

            protected Iterator getIterator() {
                return new OMQualifiedNameFilterIterator(ElementImpl.this.getDescendants(false), name);
            }
        };
    }

    public OMAttribute addAttribute(OMAttribute attr) {
        String prefix;
        OMNamespace ns2;
        String uri;
        OMNamespace namespace;
        OMElement owner = attr.getOwner();
        if (owner != null) {
            if (owner == this) {
                return attr;
            }
            attr = new AttrImpl(null, attr.getLocalName(), attr.getNamespace(), attr.getAttributeValue(), attr.getOMFactory());
        }
        if (!((namespace = attr.getNamespace()) == null || (uri = namespace.getNamespaceURI()).length() <= 0 || (ns2 = this.findNamespaceURI(prefix = namespace.getPrefix())) != null && uri.equals(ns2.getNamespaceURI()))) {
            this.declareNamespace(uri, prefix);
        }
        this.setAttributeNodeNS((Attr)((Object)attr), false, true);
        return attr;
    }

    public OMAttribute addAttribute(String localName, String value, OMNamespace ns) {
        String prefix;
        OMNamespace ns2;
        String uri;
        if (!(ns == null || (uri = ns.getNamespaceURI()).length() <= 0 || (ns2 = this.findNamespaceURI(prefix = ns.getPrefix())) != null && uri.equals(ns2.getNamespaceURI()))) {
            this.declareNamespace(uri, prefix);
        }
        return this.addAttribute(new AttrImpl(null, localName, ns, value, this.factory));
    }

    public OMNamespace addNamespaceDeclaration(String uri, String prefix) {
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", prefix.length() == 0 ? "xmlns" : "xmlns:" + prefix, uri);
        return new NamespaceImpl(uri, prefix);
    }

    public OMNamespace declareNamespace(OMNamespace namespace) {
        if (namespace != null) {
            String prefix = namespace.getPrefix();
            if (prefix == null) {
                prefix = OMSerializerUtil.getNextNSPrefix();
                namespace = new NamespaceImpl(namespace.getNamespaceURI(), prefix);
            }
            if (prefix.length() > 0 && namespace.getNamespaceURI().length() == 0) {
                throw new IllegalArgumentException("Cannot bind a prefix to the empty namespace name");
            }
            if (!namespace.getPrefix().startsWith("xmlns")) {
                this.setAttributeNS("http://www.w3.org/2000/xmlns/", prefix.length() == 0 ? "xmlns" : "xmlns:" + prefix, namespace.getNamespaceURI());
            }
        }
        return namespace;
    }

    public void undeclarePrefix(String prefix) {
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", prefix.length() == 0 ? "xmlns" : "xmlns:" + prefix, "");
    }

    public OMNamespace declareNamespace(String uri, String prefix) {
        if ("".equals(prefix)) {
            log.warn("Deprecated usage of OMElement#declareNamespace(String,String) with empty prefix");
            prefix = OMSerializerUtil.getNextNSPrefix();
        }
        NamespaceImpl ns = new NamespaceImpl(uri, prefix);
        return this.declareNamespace(ns);
    }

    public OMNamespace declareDefaultNamespace(String uri) {
        if (this.namespace == null && uri.length() > 0 || this.namespace != null && this.namespace.getPrefix().length() == 0 && !this.namespace.getNamespaceURI().equals(uri)) {
            throw new OMException("Attempt to add a namespace declaration that conflicts with the namespace information of the element");
        }
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", uri);
        return new NamespaceImpl(uri, "");
    }

    public OMNamespace getDefaultNamespace() {
        Attr decl = (Attr)this.attributes.getNamedItemNS("http://www.w3.org/2000/xmlns/", "xmlns");
        if (decl != null) {
            String uri = decl.getValue();
            return uri.length() == 0 ? null : new NamespaceImpl(uri, "");
        }
        ParentNode parentNode = this.parentNode();
        if (parentNode instanceof ElementImpl) {
            ElementImpl element = (ElementImpl)parentNode;
            return element.getDefaultNamespace();
        }
        return null;
    }

    public OMNamespace findNamespace(String uri, String prefix) {
        OMNamespace namespace = this.findDeclaredNamespace(uri, prefix);
        if (namespace != null) {
            return namespace;
        }
        ParentNode parentNode = this.parentNode();
        if (parentNode != null && parentNode instanceof OMElement) {
            namespace = ((ElementImpl)parentNode).findNamespace(uri, prefix);
            if (prefix == null && namespace != null && this.findDeclaredNamespace(null, namespace.getPrefix()) != null) {
                namespace = null;
            }
        }
        if (namespace == null && uri != null && prefix != null && prefix.equals("xml") && uri.equals("http://www.w3.org/XML/1998/namespace")) {
            this.declareNamespace("http://www.w3.org/XML/1998/namespace", "xml");
            namespace = this.findNamespace(uri, prefix);
        }
        return namespace;
    }

    public OMNamespace findNamespaceURI(String prefix) {
        Attr decl;
        if (this.attributes != null && (decl = (Attr)this.attributes.getNamedItemNS("http://www.w3.org/2000/xmlns/", prefix.length() == 0 ? "xmlns" : prefix)) != null) {
            String namespaceURI = decl.getValue();
            if (prefix != null && prefix.length() > 0 && namespaceURI.length() == 0) {
                return null;
            }
            return new NamespaceImpl(namespaceURI, prefix);
        }
        ParentNode parentNode = this.parentNode();
        if (parentNode instanceof OMElement) {
            return ((OMElement)((Object)parentNode)).findNamespaceURI(prefix);
        }
        return null;
    }

    private OMNamespace findDeclaredNamespace(String uri, String prefix) {
        if (uri == null) {
            Attr decl = (Attr)this.attributes.getNamedItemNS("http://www.w3.org/2000/xmlns/", prefix.length() == 0 ? "xmlns" : prefix);
            return decl == null ? null : new NamespaceImpl(decl.getValue(), prefix);
        }
        if (prefix != null && prefix.equals("xml") && uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return new NamespaceImpl(uri, prefix);
        }
        if (prefix == null || "".equals(prefix)) {
            for (int i = 0; i < this.attributes.getLength(); ++i) {
                String declaredUri;
                Attr attr = (Attr)this.attributes.item(i);
                if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) || !(declaredUri = attr.getValue()).equals(uri)) continue;
                return new NamespaceImpl(uri, attr.getPrefix() == null ? "" : attr.getLocalName());
            }
        } else {
            String declaredUri;
            Attr decl = (Attr)this.attributes.getNamedItemNS("http://www.w3.org/2000/xmlns/", prefix);
            if (decl != null && (declaredUri = decl.getValue()).equals(uri)) {
                return new NamespaceImpl(uri, prefix);
            }
        }
        return null;
    }

    public OMAttribute getAttribute(QName qname) {
        if (this.attributes == null) {
            return null;
        }
        if (qname.getNamespaceURI().equals("")) {
            return (AttrImpl)this.getAttributeNode(qname.getLocalPart());
        }
        return (AttrImpl)this.getAttributeNodeNS(qname.getNamespaceURI(), qname.getLocalPart());
    }

    public String getAttributeValue(QName qname) {
        OMAttribute attr = this.getAttribute(qname);
        return attr == null ? null : attr.getAttributeValue();
    }

    public OMElement getFirstElement() {
        for (OMNode node = this.getFirstOMChild(); node != null; node = node.getNextOMSibling()) {
            if (node.getType() != 1) continue;
            return (OMElement)node;
        }
        return null;
    }

    public OMNamespace getNamespace() {
        return this.namespace;
    }

    public QName getQName() {
        QName qName = this.namespace != null ? new QName(this.namespace.getNamespaceURI(), this.localName, this.namespace.getPrefix()) : new QName(this.localName);
        return qName;
    }

    public String getText() {
        return OMElementImplUtil.getText(this);
    }

    public Reader getTextAsStream(boolean cache) {
        return OMElementImplUtil.getTextAsStream(this, cache);
    }

    public QName getTextAsQName() {
        String childText = this.getText().trim();
        return childText.length() == 0 ? null : this.resolveQName(childText);
    }

    public void writeTextTo(Writer out, boolean cache) throws IOException {
        OMElementImplUtil.writeTextTo(this, out, cache);
    }

    public void removeAttribute(OMAttribute attr) {
        if (attr.getOwner() != this) {
            throw new OMException("The attribute is not owned by this element");
        }
        this.attributes.remove((AttrImpl)attr, false);
    }

    public void setBuilder(OMXMLParserWrapper wrapper) {
        this.builder = wrapper;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public void internalSetNamespace(OMNamespace namespace) {
        this.namespace = namespace;
    }

    public void setNamespace(OMNamespace namespace) {
        this.internalSetNamespace(this.handleNamespace(namespace));
    }

    public void setNamespaceWithNoFindInCurrentScope(OMNamespace namespace) {
        this.internalSetNamespace(namespace);
    }

    public void setText(String text) {
        OMNode child;
        while ((child = this.getFirstOMChild()) != null) {
            child.detach();
        }
        if (text != null && text.length() > 0) {
            this.getOMFactory().createOMText((OMContainer)this, text);
        }
    }

    public void setText(QName qname) {
        OMNode child;
        while ((child = this.getFirstOMChild()) != null) {
            child.detach();
        }
        if (qname != null) {
            this.getOMFactory().createOMText((OMContainer)this, qname);
        }
    }

    public void internalSerialize(XMLStreamWriter writer, boolean cache) throws XMLStreamException {
        if (cache || this.state == 1 || this.builder == null) {
            OMSerializerUtil.serializeStartpart(this, writer);
            OMSerializerUtil.serializeChildren(this, writer, cache);
            OMSerializerUtil.serializeEndpart(writer);
        } else {
            OMSerializerUtil.serializeByPullStream(this, writer, cache);
        }
    }

    public String toStringWithConsume() throws XMLStreamException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.serializeAndConsume(baos);
        return new String(baos.toByteArray());
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.serialize(baos);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Can not serialize OM Element " + this.getLocalName(), e);
        }
        return new String(baos.toByteArray());
    }

    public Iterator getChildElements() {
        return new OMChildElementIterator(this.getFirstElement());
    }

    public Iterator getAllDeclaredNamespaces() throws OMException {
        return new NSDeclIterator(this.attributes);
    }

    public Iterator getNamespacesInScope() {
        return new NamespaceIterator(this);
    }

    public NamespaceContext getNamespaceContext(boolean detached) {
        return OMElementImplUtil.getNamespaceContext(this, detached);
    }

    public Iterator getAllAttributes() {
        if (this.attributes == null) {
            return EMPTY_ITERATOR;
        }
        ArrayList<OMAttribute> list = new ArrayList<OMAttribute>();
        for (int i = 0; i < this.attributes.getLength(); ++i) {
            OMAttribute item = (OMAttribute)this.attributes.getItem(i);
            if (item.getNamespace() != null && item.getNamespace() != null && "http://www.w3.org/2000/xmlns/".equals(item.getNamespace().getNamespaceURI())) continue;
            list.add(item);
        }
        return list.iterator();
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getPrefix() {
        OMNamespace ns = this.getNamespace();
        if (ns == null) {
            return null;
        }
        String prefix = ns.getPrefix();
        return prefix.length() == 0 ? null : prefix;
    }

    public void setPrefix(String prefix) throws DOMException {
        NamedNodeHelper.setPrefix(this, prefix);
    }

    public QName resolveQName(String qname) {
        int idx = qname.indexOf(58);
        if (idx == -1) {
            OMNamespace ns = this.getDefaultNamespace();
            return ns == null ? new QName(qname) : new QName(ns.getNamespaceURI(), qname, "");
        }
        String prefix = qname.substring(0, idx);
        OMNamespace ns = this.findNamespace(null, prefix);
        return ns == null ? null : new QName(ns.getNamespaceURI(), qname.substring(idx + 1), prefix);
    }

    public OMElement cloneOMElement() {
        return (OMElement)this.clone(new OMCloneOptions());
    }

    final ParentNode shallowClone(OMCloneOptions options, ParentNode targetParent, boolean namespaceRepairing) {
        ElementImpl clone = options.isPreserveModel() ? (ElementImpl)this.createClone(options, targetParent, namespaceRepairing) : new ElementImpl(targetParent, this.localName, this.namespace, null, this.factory, namespaceRepairing);
        int l = this.attributes.getLength();
        for (int i = 0; i < l; ++i) {
            AttrImpl attr = (AttrImpl)this.attributes.item(i);
            AttrImpl clonedAttr = (AttrImpl)attr.clone(options, null, true, false);
            clonedAttr.isSpecified(attr.isSpecified());
            clone.setAttributeNodeNS(clonedAttr, false, namespaceRepairing && !"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()));
        }
        return clone;
    }

    protected OMElement createClone(OMCloneOptions options, ParentNode targetParent, boolean generateNSDecl) {
        return new ElementImpl(targetParent, this.localName, this.namespace, null, this.factory, generateNSDecl);
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public NamedNodeMap getAttributes() {
        return this.attributes;
    }

    public String getNamespaceURI(String prefix) {
        OMNamespace ns = this.findNamespaceURI(prefix);
        return ns != null ? ns.getNamespaceURI() : null;
    }

    public void discard() throws OMException {
        OMElementImplUtil.discard(this);
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
        AttrImpl tempAttr = (AttrImpl)this.getAttributeNode(name);
        if (tempAttr == null) {
            throw DOMUtil.newDOMException((short)8);
        }
        this.updateIsId(isId, tempAttr);
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        AttrImpl tempAttr = (AttrImpl)this.getAttributeNodeNS(namespaceURI, localName);
        if (tempAttr == null) {
            throw DOMUtil.newDOMException((short)8);
        }
        this.updateIsId(isId, tempAttr);
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        Iterator attrIter = this.getAllAttributes();
        AttrImpl tempAttr = null;
        while (attrIter.hasNext()) {
            AttrImpl attr = (AttrImpl)attrIter.next();
            if (!attr.equals(idAttr)) continue;
            tempAttr = attr;
            break;
        }
        if (tempAttr == null) {
            throw DOMUtil.newDOMException((short)8);
        }
        this.updateIsId(isId, tempAttr);
    }

    private void updateIsId(boolean isId, AttrImpl tempAttr) {
        tempAttr.isId = isId;
        if (isId) {
            this.ownerDocument().addIdAttr(tempAttr);
        } else {
            this.ownerDocument().removeIdAttr(tempAttr);
        }
    }

    public TypeInfo getSchemaTypeInfo() {
        throw new UnsupportedOperationException("TODO");
    }

    public void buildWithAttachments() {
        if (this.state == 0) {
            this.build();
        }
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            OMNode node = (OMNode)iterator.next();
            node.buildWithAttachments();
        }
    }

    void normalize(DOMConfigurationImpl config) {
        if (config.isEnabled(128)) {
            OMNamespace namespace = this.getNamespace();
            if (namespace == null) {
                if (this.getDefaultNamespace() != null) {
                    this.declareDefaultNamespace("");
                }
            } else {
                OMNamespace namespaceForPrefix = this.findNamespaceURI(namespace.getPrefix());
                if (namespaceForPrefix == null || !namespaceForPrefix.getNamespaceURI().equals(namespace.getNamespaceURI())) {
                    this.declareNamespace(namespace);
                }
            }
        }
        super.normalize(config);
    }

    public final OMXMLParserWrapper getBuilder() {
        return this.builder;
    }

    public final int getState() {
        return this.state;
    }

    public final boolean isComplete() {
        return this.state == 1;
    }

    public final void setComplete(boolean complete) {
        this.state = complete ? 1 : 0;
        ParentNode parentNode = this.parentNode();
        if (parentNode != null) {
            if (!complete) {
                parentNode.setComplete(false);
            } else {
                parentNode.notifyChildComplete();
            }
        }
    }

    public final void discarded() {
        this.state = 2;
    }

    OMNode detach(boolean useDomSemantics) {
        if (this.state == 0) {
            this.build();
        }
        return super.detach(useDomSemantics);
    }

    public final void build() {
        OMContainerHelper.build(this);
    }

    public final OMNode getNextOMSibling() throws OMException {
        return OMNodeHelper.getNextOMSibling(this);
    }

    public final Node getNextSibling() {
        return (Node)((Object)this.getNextOMSibling());
    }

    public final IParentNode getIParentNode() {
        return this.parentNode();
    }

    public final void removeChildren() {
        OMContainerHelper.removeChildren(this);
    }

    public final String lookupNamespaceURI(String specifiedPrefix) {
        ParentNode parent;
        String namespace = this.getNamespaceURI();
        String prefix = this.getPrefix();
        if (namespace != null && (prefix == null && specifiedPrefix == null || prefix != null && prefix.equals(specifiedPrefix))) {
            return namespace;
        }
        if (this.hasAttributes()) {
            NamedNodeMap map = this.getAttributes();
            int length = map.getLength();
            for (int i = 0; i < length; ++i) {
                Node attr = map.item(i);
                namespace = attr.getNamespaceURI();
                if (namespace == null || !namespace.equals("http://www.w3.org/2000/xmlns/")) continue;
                String attrPrefix = attr.getPrefix();
                if ((specifiedPrefix != null || attrPrefix != null) && (specifiedPrefix == null || attrPrefix == null || !attr.getLocalName().equals(specifiedPrefix))) continue;
                String value = attr.getNodeValue();
                return value.length() > 0 ? value : null;
            }
        }
        return (parent = this.parentNode()) == null || parent instanceof Document ? null : parent.lookupNamespaceURI(specifiedPrefix);
    }
}

