/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.java.utilities;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class FileUtilities {
    public static BufferedInputStream getInputStreamFromFile(File file) throws IOException {
        InputStream is = new FileInputStream(file);
        String lcfn = file.getName().toLowerCase();
        if (lcfn.contains(".gz") || lcfn.contains(".gzip")) {
            is = new GZIPInputStream(is);
        }
        return new BufferedInputStream(is);
    }

    public static BufferedOutputStream getOutputStreamToFile(File file) throws IOException {
        OutputStream os = new FileOutputStream(file);
        String lcfn = file.getName().toLowerCase();
        if (lcfn.contains(".gz") || lcfn.contains(".gzip")) {
            os = new GZIPOutputStream(os);
        }
        return new BufferedOutputStream(os);
    }

    public static BufferedReader getReaderFromFile(File file) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)FileUtilities.getInputStreamFromFile(file), "UTF-8"));
    }

    public static BufferedWriter getWriterToFile(File file) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)FileUtilities.getOutputStreamToFile(file), "UTF-8"));
    }
}

