/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.java.utilities;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class CLIInteractionUtilities {
    public static String readLineFromStdIn() throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        return br.readLine();
    }

    public static String readLineFromStdInWithMessage(String message) throws IOException {
        System.out.println(message);
        return CLIInteractionUtilities.readLineFromStdIn();
    }

    public static String readLineFromStdInWithMessage(String message, String defaultResponse) throws IOException {
        System.out.println(message + "(" + defaultResponse + ")");
        String input = CLIInteractionUtilities.readLineFromStdIn();
        if (input.trim().length() == 0) {
            return defaultResponse;
        }
        return input;
    }

    public static boolean readYesNoFromStdInWithMessage(String message) throws IOException {
        String response = "";
        while (!(response.equals("y") || response.equals("yes") || response.equals("n") || response.equals("no"))) {
            response = CLIInteractionUtilities.readLineFromStdInWithMessage(message + " (y/n)");
            response = response.toLowerCase();
        }
        return response.equals("y") || response.equals("yes");
    }

    public static boolean readYesNoFromStdInWithMessage(String message, boolean defaultResponse) throws IOException {
        String response = "";
        String defaultMarker = defaultResponse ? "y" : "n";
        do {
            response = CLIInteractionUtilities.readLineFromStdInWithMessage(message + " (y/n)[" + defaultMarker + "]");
        } while (!(response = response.toLowerCase()).equals("y") && !response.equals("yes") && !response.equals("n") && !response.equals("no") && response.trim().length() > 0);
        return response.equals("y") || response.equals("yes") || response.trim().length() == 0;
    }
}

