/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.core;

import com.github.jsonldjava.core.Context;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.utils.JsonLdUrl;
import com.github.jsonldjava.utils.Obj;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class JsonLdUtils {
    private static final int MAX_CONTEXT_URLS = 10;

    static boolean isKeyword(Object key) {
        if (!JsonLdUtils.isString(key).booleanValue()) {
            return false;
        }
        return "@base".equals(key) || "@context".equals(key) || "@container".equals(key) || "@default".equals(key) || "@embed".equals(key) || "@explicit".equals(key) || "@graph".equals(key) || "@id".equals(key) || "@index".equals(key) || "@language".equals(key) || "@list".equals(key) || "@omitDefault".equals(key) || "@reverse".equals(key) || "@preserve".equals(key) || "@set".equals(key) || "@type".equals(key) || "@value".equals(key) || "@vocab".equals(key);
    }

    public static Boolean deepCompare(Object v1, Object v2, Boolean listOrderMatters) {
        if (v1 == null) {
            return v2 == null;
        }
        if (v2 == null) {
            return v1 == null;
        }
        if (v1 instanceof Map && v2 instanceof Map) {
            Map m1 = (Map)v1;
            Map m2 = (Map)v2;
            if (m1.size() != m2.size()) {
                return false;
            }
            for (String key : m1.keySet()) {
                if (m2.containsKey(key) && JsonLdUtils.deepCompare(m1.get(key), m2.get(key), listOrderMatters).booleanValue()) continue;
                return false;
            }
            return true;
        }
        if (v1 instanceof List && v2 instanceof List) {
            List l1 = (List)v1;
            List l2 = (List)v2;
            if (l1.size() != l2.size()) {
                return false;
            }
            boolean[] alreadyMatched = new boolean[l2.size()];
            for (int i = 0; i < l1.size(); ++i) {
                Object o1 = l1.get(i);
                Boolean gotmatch = false;
                if (listOrderMatters.booleanValue()) {
                    gotmatch = JsonLdUtils.deepCompare(o1, l2.get(i), listOrderMatters);
                } else {
                    for (int j = 0; j < l2.size(); ++j) {
                        if (alreadyMatched[j] || !JsonLdUtils.deepCompare(o1, l2.get(j), listOrderMatters).booleanValue()) continue;
                        alreadyMatched[j] = true;
                        gotmatch = true;
                        break;
                    }
                }
                if (gotmatch.booleanValue()) continue;
                return false;
            }
            return true;
        }
        return v1.equals(v2);
    }

    public static Boolean deepCompare(Object v1, Object v2) {
        return JsonLdUtils.deepCompare(v1, v2, false);
    }

    public static boolean deepContains(List<Object> values, Object value) {
        for (Object item : values) {
            if (!JsonLdUtils.deepCompare(item, value, false).booleanValue()) continue;
            return true;
        }
        return false;
    }

    static void mergeValue(Map<String, Object> obj, String key, Object value) {
        if (obj == null) {
            return;
        }
        ArrayList<Object> values = (ArrayList<Object>)obj.get(key);
        if (values == null) {
            values = new ArrayList<Object>();
            obj.put(key, values);
        }
        if ("@list".equals(key) || value instanceof Map && ((Map)value).containsKey("@list") || !JsonLdUtils.deepContains(values, value)) {
            values.add(value);
        }
    }

    static void laxMergeValue(Map<String, Object> obj, String key, Object value) {
        if (obj == null) {
            return;
        }
        ArrayList<Object> values = (ArrayList<Object>)obj.get(key);
        if (values == null) {
            values = new ArrayList<Object>();
            obj.put(key, values);
        }
        values.add(value);
    }

    static void mergeCompactedValue(Map<String, Object> obj, String key, Object value) {
        if (obj == null) {
            return;
        }
        Object prop = obj.get(key);
        if (prop == null) {
            obj.put(key, value);
            return;
        }
        if (!(prop instanceof List)) {
            ArrayList<Object> tmp = new ArrayList<Object>();
            tmp.add(prop);
        }
        if (value instanceof List) {
            ((List)prop).addAll((List)value);
        } else {
            ((List)prop).add(value);
        }
    }

    public static boolean isAbsoluteIri(String value) {
        return value.contains(":");
    }

    static boolean isNode(Object v) {
        if (v instanceof Map && !((Map)v).containsKey("@value") && !((Map)v).containsKey("@set") && !((Map)v).containsKey("@list")) {
            return ((Map)v).size() > 1 || !((Map)v).containsKey("@id");
        }
        return false;
    }

    static boolean isNodeReference(Object v) {
        return v instanceof Map && ((Map)v).size() == 1 && ((Map)v).containsKey("@id");
    }

    public static boolean isRelativeIri(String value) {
        return !JsonLdUtils.isKeyword(value) && !JsonLdUtils.isAbsoluteIri(value);
    }

    static void addValue(Map<String, Object> subject, String property, Object value, boolean propertyIsArray, boolean allowDuplicate) {
        if (JsonLdUtils.isArray(value).booleanValue()) {
            if (((List)value).size() == 0 && propertyIsArray && !subject.containsKey(property)) {
                subject.put(property, new ArrayList());
            }
            for (Object val : (List)value) {
                JsonLdUtils.addValue(subject, property, val, propertyIsArray, allowDuplicate);
            }
        } else if (subject.containsKey(property)) {
            boolean hasValue;
            boolean bl = hasValue = !allowDuplicate && JsonLdUtils.hasValue(subject, property, value);
            if (!(JsonLdUtils.isArray(subject.get(property)).booleanValue() || hasValue && !propertyIsArray)) {
                ArrayList<Object> tmp = new ArrayList<Object>();
                tmp.add(subject.get(property));
                subject.put(property, tmp);
            }
            if (!hasValue) {
                ((List)subject.get(property)).add(value);
            }
        } else {
            ArrayList tmp;
            if (propertyIsArray) {
                tmp = new ArrayList();
                ((List)tmp).add(value);
            } else {
                tmp = value;
            }
            subject.put(property, tmp);
        }
    }

    static void addValue(Map<String, Object> subject, String property, Object value, boolean propertyIsArray) {
        JsonLdUtils.addValue(subject, property, value, propertyIsArray, true);
    }

    static void addValue(Map<String, Object> subject, String property, Object value) {
        JsonLdUtils.addValue(subject, property, value, false, true);
    }

    private static String prependBase(Object baseobj, String iri) {
        String rval;
        String path;
        if (iri.indexOf(":") != -1) {
            return iri;
        }
        JsonLdUrl base = JsonLdUtils.isString(baseobj) != false ? JsonLdUrl.parse((String)baseobj) : (JsonLdUrl)baseobj;
        JsonLdUrl rel = JsonLdUrl.parse(iri);
        String hierPart = base.protocol;
        if (!"".equals(rel.authority)) {
            hierPart = hierPart + "//" + rel.authority;
        } else if (!"".equals(base.href)) {
            hierPart = hierPart + "//" + base.authority;
        }
        if (rel.pathname.indexOf("/") == 0) {
            path = rel.pathname;
        } else {
            path = base.pathname;
            if (!"".equals(rel.pathname)) {
                if ((path = path.substring(0, path.lastIndexOf("/") + 1)).length() > 0 && !path.endsWith("/")) {
                    path = path + "/";
                }
                path = path + rel.pathname;
            }
        }
        path = JsonLdUrl.removeDotSegments(path, !"".equals(hierPart));
        if (!"".equals(rel.query)) {
            path = path + "?" + rel.query;
        }
        if (!"".equals(rel.hash)) {
            path = path + rel.hash;
        }
        if ("".equals(rval = hierPart + path)) {
            return "./";
        }
        return rval;
    }

    static List<Object> expandLanguageMap(Map<String, Object> languageMap) throws JsonLdError {
        ArrayList<Object> rval = new ArrayList<Object>();
        ArrayList<String> keys = new ArrayList<String>(languageMap.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            List val;
            if (!JsonLdUtils.isArray(languageMap.get(key)).booleanValue()) {
                val = new ArrayList<Object>();
                val.add(languageMap.get(key));
            } else {
                val = (List)languageMap.get(key);
            }
            for (Object item : val) {
                if (!JsonLdUtils.isString(item).booleanValue()) {
                    throw new JsonLdError(JsonLdError.Error.SYNTAX_ERROR);
                }
                Map<String, Object> tmp = Obj.newMap();
                tmp.put("@value", item);
                tmp.put("@language", key.toLowerCase());
                rval.add(tmp);
            }
        }
        return rval;
    }

    static boolean validateTypeValue(Object v) throws JsonLdError {
        if (v == null) {
            throw new NullPointerException("\"@type\" value cannot be null");
        }
        if (v instanceof String || v instanceof Map && (((Map)v).containsKey("@id") || ((Map)v).size() == 0)) {
            return true;
        }
        boolean isValid = false;
        if (v instanceof List) {
            isValid = true;
            for (Object i : (List)v) {
                if (i instanceof String || i instanceof Map && ((Map)i).containsKey("@id")) continue;
                isValid = false;
                break;
            }
        }
        if (!isValid) {
            throw new JsonLdError(JsonLdError.Error.SYNTAX_ERROR);
        }
        return true;
    }

    private static String removeBase(Object baseobj, String iri) {
        JsonLdUrl base = JsonLdUtils.isString(baseobj) != false ? JsonLdUrl.parse((String)baseobj) : (JsonLdUrl)baseobj;
        String root = "";
        if (!"".equals(base.href)) {
            root = root + base.protocol + "//" + base.authority;
        } else if (iri.indexOf("//") != 0) {
            root = root + "//";
        }
        if (iri.indexOf(root) != 0) {
            return iri;
        }
        JsonLdUrl rel = JsonLdUrl.parse(iri.substring(root.length()));
        List<String> baseSegments = JsonLdUtils._split(base.normalizedPath, "/");
        List<String> iriSegments = JsonLdUtils._split(rel.normalizedPath, "/");
        while (baseSegments.size() > 0 && iriSegments.size() > 0 && baseSegments.get(0).equals(iriSegments.get(0))) {
            if (baseSegments.size() > 0) {
                baseSegments.remove(0);
            }
            if (iriSegments.size() <= 0) continue;
            iriSegments.remove(0);
        }
        String rval = "";
        if (baseSegments.size() > 0) {
            if (!base.normalizedPath.endsWith("/") || "".equals(baseSegments.get(0))) {
                baseSegments.remove(baseSegments.size() - 1);
            }
            for (int i = 0; i < baseSegments.size(); ++i) {
                rval = rval + "../";
            }
        }
        rval = rval + JsonLdUtils._join(iriSegments, "/");
        if (!"".equals(rel.query)) {
            rval = rval + "?" + rel.query;
        }
        if (!"".equals(rel.hash)) {
            rval = rval + rel.hash;
        }
        if ("".equals(rval)) {
            rval = "./";
        }
        return rval;
    }

    static Object removePreserve(Context ctx, Object input, JsonLdOptions opts) throws JsonLdError {
        if (JsonLdUtils.isArray(input).booleanValue()) {
            ArrayList<Object> output = new ArrayList<Object>();
            for (Object i : (List)input) {
                Object result = JsonLdUtils.removePreserve(ctx, i, opts);
                if (result == null) continue;
                output.add(result);
            }
            input = output;
        } else if (JsonLdUtils.isObject(input).booleanValue()) {
            if (((Map)((Object)input)).containsKey("@preserve")) {
                if ("@null".equals(((Map)((Object)input)).get("@preserve"))) {
                    return null;
                }
                return ((Map)((Object)input)).get("@preserve");
            }
            if (JsonLdUtils.isValue(input).booleanValue()) {
                return input;
            }
            if (JsonLdUtils.isList(input).booleanValue()) {
                ((Map)((Object)input)).put("@list", JsonLdUtils.removePreserve(ctx, ((Map)((Object)input)).get("@list"), opts));
                return input;
            }
            for (String prop : ((Map)((Object)input)).keySet()) {
                Object result = JsonLdUtils.removePreserve(ctx, ((Map)((Object)input)).get(prop), opts);
                String container = ctx.getContainer(prop);
                if (opts.getCompactArrays().booleanValue() && JsonLdUtils.isArray(result).booleanValue() && ((List)result).size() == 1 && container == null) {
                    result = ((List)result).get(0);
                }
                ((Map)((Object)input)).put(prop, result);
            }
        }
        return input;
    }

    private static String _join(List<String> list, String joiner) {
        String rval = "";
        if (list.size() > 0) {
            rval = rval + list.get(0);
        }
        for (int i = 1; i < list.size(); ++i) {
            rval = rval + joiner + list.get(i);
        }
        return rval;
    }

    private static List<String> _split(String string, String delim) {
        ArrayList<String> rval = new ArrayList<String>(Arrays.asList(string.split(delim)));
        if (string.endsWith("/")) {
            rval.add("");
        }
        return rval;
    }

    static int compareShortestLeast(String a, String b) {
        if (a.length() < b.length()) {
            return -1;
        }
        if (b.length() < a.length()) {
            return 1;
        }
        return Integer.signum(a.compareTo(b));
    }

    static boolean hasValue(Map<String, Object> subject, String property, Object value) {
        boolean rval = false;
        if (JsonLdUtils.hasProperty(subject, property)) {
            Object val = subject.get(property);
            boolean isList = JsonLdUtils.isList(val);
            if (isList || val instanceof List) {
                if (isList) {
                    val = ((Map)val).get("@list");
                }
                for (Object i : (List)val) {
                    if (!JsonLdUtils.compareValues(value, i)) continue;
                    rval = true;
                    break;
                }
            } else if (!(value instanceof List)) {
                rval = JsonLdUtils.compareValues(value, val);
            }
        }
        return rval;
    }

    private static boolean hasProperty(Map<String, Object> subject, String property) {
        boolean rval = false;
        if (subject.containsKey(property)) {
            Object value = subject.get(property);
            rval = !(value instanceof List) || ((List)value).size() > 0;
        }
        return rval;
    }

    static boolean compareValues(Object v1, Object v2) {
        if (v1.equals(v2)) {
            return true;
        }
        if (JsonLdUtils.isValue(v1).booleanValue() && JsonLdUtils.isValue(v2).booleanValue() && Obj.equals(((Map)v1).get("@value"), ((Map)v2).get("@value")) && Obj.equals(((Map)v1).get("@type"), ((Map)v2).get("@type")) && Obj.equals(((Map)v1).get("@language"), ((Map)v2).get("@language")) && Obj.equals(((Map)v1).get("@index"), ((Map)v2).get("@index"))) {
            return true;
        }
        return v1 instanceof Map && ((Map)v1).containsKey("@id") && v2 instanceof Map && ((Map)v2).containsKey("@id") && ((Map)v1).get("@id").equals(((Map)v2).get("@id"));
    }

    static void removeValue(Map<String, Object> subject, String property, Map<String, Object> value) {
        JsonLdUtils.removeValue(subject, property, value, false);
    }

    static void removeValue(Map<String, Object> subject, String property, Map<String, Object> value, boolean propertyIsArray) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (subject.get(property) instanceof List) {
            for (Object e : (List)subject.get(property)) {
                if (value.equals(e)) continue;
                values.add(value);
            }
        } else if (!value.equals(subject.get(property))) {
            values.add(subject.get(property));
        }
        if (values.size() == 0) {
            subject.remove(property);
        } else if (values.size() == 1 && !propertyIsArray) {
            subject.put(property, values.get(0));
        } else {
            subject.put(property, values);
        }
    }

    static boolean isBlankNode(Object v) {
        if (v instanceof Map) {
            if (((Map)v).containsKey("@id")) {
                return ((String)((Map)v).get("@id")).startsWith("_:");
            }
            return ((Map)v).size() == 0 || !((Map)v).containsKey("@value") && !((Map)v).containsKey("@set") && !((Map)v).containsKey("@list");
        }
        return false;
    }

    private static boolean findContextUrls(Object input, Map<String, Object> urls, Boolean replace) {
        int count = urls.size();
        if (input instanceof List) {
            for (Object i : (List)input) {
                JsonLdUtils.findContextUrls(i, urls, replace);
            }
            return count < urls.size();
        }
        if (input instanceof Map) {
            for (String key : ((Map)input).keySet()) {
                if (!"@context".equals(key)) {
                    JsonLdUtils.findContextUrls(((Map)input).get(key), urls, replace);
                    continue;
                }
                Object ctx = ((Map)input).get(key);
                if (ctx instanceof List) {
                    int length = ((List)ctx).size();
                    for (int i = 0; i < length; ++i) {
                        Object _ctx = ((List)ctx).get(i);
                        if (!(_ctx instanceof String)) continue;
                        if (replace.booleanValue()) {
                            if ((_ctx = urls.get(_ctx)) instanceof List) {
                                ((List)ctx).remove(i);
                                ((List)ctx).addAll((Collection)_ctx);
                                i += ((List)_ctx).size();
                                length += ((List)_ctx).size();
                                continue;
                            }
                            ((List)ctx).set(i, _ctx);
                            continue;
                        }
                        if (urls.containsKey(_ctx)) continue;
                        urls.put((String)_ctx, Boolean.FALSE);
                    }
                    continue;
                }
                if (!(ctx instanceof String)) continue;
                if (replace.booleanValue()) {
                    ((Map)input).put(key, urls.get(ctx));
                    continue;
                }
                if (urls.containsKey(ctx)) continue;
                urls.put((String)ctx, Boolean.FALSE);
            }
            return count < urls.size();
        }
        return false;
    }

    static Object clone(Object value) {
        Object rval = null;
        if (value instanceof Cloneable) {
            try {
                rval = value.getClass().getMethod("clone", new Class[0]).invoke(value, new Object[0]);
            }
            catch (Exception e) {
                rval = e;
            }
        }
        if (rval == null || rval instanceof Exception) {
            if (value == null || value instanceof String || value instanceof Number || value instanceof Boolean) {
                rval = value;
            } else {
                throw new RuntimeException(new CloneNotSupportedException(rval instanceof Exception ? ((Exception)rval).getMessage() : ""));
            }
        }
        return rval;
    }

    static Boolean isArray(Object v) {
        return v instanceof List;
    }

    static Boolean isList(Object v) {
        return v instanceof Map && ((Map)v).containsKey("@list");
    }

    static Boolean isObject(Object v) {
        return v instanceof Map;
    }

    static Boolean isValue(Object v) {
        return v instanceof Map && ((Map)v).containsKey("@value");
    }

    static Boolean isString(Object v) {
        return v instanceof String;
    }
}

