/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.decomposition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.semanticweb.owlapitools.decomposition.AxiomWrapper;

public class OntologyAtom {
    static Comparator<OntologyAtom> comparator = (arg0, arg1) -> arg0.getId() - arg1.getId();
    private List<AxiomWrapper> axioms = new ArrayList<AxiomWrapper>();
    private List<AxiomWrapper> module = new ArrayList<AxiomWrapper>();
    private Set<OntologyAtom> dependencies = new HashSet<OntologyAtom>();
    private Set<OntologyAtom> allDependencies = new HashSet<OntologyAtom>();
    private int id = 0;

    public void filterDep() {
        this.dependencies.removeAll(this.allDependencies);
    }

    public void buildAllDepAtoms(Set<OntologyAtom> checked) {
        for (OntologyAtom p : this.dependencies) {
            Set<OntologyAtom> dep = p.getAllDepAtoms(checked);
            this.allDependencies.addAll(dep);
        }
        this.filterDep();
        this.allDependencies.addAll(this.dependencies);
        checked.add(this);
    }

    public void addAxiom(AxiomWrapper ax) {
        this.axioms.add(ax);
        ax.setAtom(this);
    }

    public void addAxioms(Collection<AxiomWrapper> axs) {
        axs.forEach(this::addAxiom);
    }

    public void addDepAtom(@Nullable OntologyAtom atom) {
        if (atom != null && atom != this) {
            this.dependencies.add(atom);
        }
    }

    public Set<OntologyAtom> getAllDepAtoms(Set<OntologyAtom> checked) {
        if (checked.contains(this)) {
            this.buildAllDepAtoms(checked);
        }
        return this.allDependencies;
    }

    public List<AxiomWrapper> getAtomAxioms() {
        return this.axioms;
    }

    public List<AxiomWrapper> getModule() {
        return this.module;
    }

    public void setModule(Collection<AxiomWrapper> module) {
        this.module = new ArrayList<AxiomWrapper>(module);
    }

    public Set<OntologyAtom> getDependencies() {
        return this.dependencies;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }
}

