/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionFactory.class.getName());
    private static final AtomicInteger EXPECTEDTHREADS = new AtomicInteger(8);

    private CollectionFactory() {
    }

    public static <T extends OWLObject> List<T> sortOptionallyComparables(List<T> toReturn) {
        try {
            toReturn.sort(null);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Misbehaving triple comparator, leaving triples unsorted", e);
        }
        return toReturn;
    }

    public static <T extends OWLObject> List<T> sortOptionally(List<T> toReturn) {
        return CollectionFactory.sortOptionallyComparables(toReturn);
    }

    public static <T extends OWLObject> List<T> sortOptionally(List<? extends T> toReturn, Class<T> desiredType) {
        return CollectionFactory.sortOptionallyComparables(toReturn);
    }

    public static <T extends OWLObject> List<T> sortOptionallyComparables(Collection<T> toReturn) {
        return CollectionFactory.sortOptionallyComparables(new ArrayList<T>(toReturn));
    }

    public static <T extends OWLObject> List<T> sortOptionally(Collection<T> toReturn) {
        return CollectionFactory.sortOptionally(new ArrayList<T>(toReturn));
    }

    public static <T extends OWLObject> List<T> sortOptionally(Stream<T> toReturn) {
        return CollectionFactory.sortOptionally(OWLAPIStreamUtils.asList(toReturn));
    }

    public static <T extends OWLObject> List<T> sortOptionally(Stream<? extends T> toReturn, Class<T> desiredType) {
        return CollectionFactory.sortOptionally(OWLAPIStreamUtils.asList(toReturn), desiredType);
    }

    public static int getExpectedThreads() {
        return EXPECTEDTHREADS.get();
    }

    public static void setExpectedThreads(int value) {
        EXPECTEDTHREADS.set(value);
    }

    public static <T> Set<T> createSet() {
        return new HashSet(0);
    }

    public static <T> Set<T> createLinkedSet() {
        return new LinkedHashSet(0);
    }

    public static <T> List<T> createList() {
        return new ArrayList();
    }

    @SafeVarargs
    public static <T> List<T> createList(T ... elements) {
        return Lists.newArrayList(elements);
    }

    public static <T> List<T> createSyncList() {
        return new CopyOnWriteArrayList();
    }

    public static <T> List<T> list(Iterable<T> i) {
        return Lists.newArrayList(i);
    }

    @SafeVarargs
    public static <T> List<T> list(T ... i) {
        return Lists.newArrayList(i);
    }

    public static <T> List<T> list(T i) {
        return Collections.singletonList(i);
    }

    public static <T> Set<T> createSet(Collection<T> c) {
        return new HashSet<T>(c);
    }

    public static <T> Set<T> createSet(int initialCapacity) {
        return new HashSet(initialCapacity);
    }

    public static <K, V> Map<K, V> createMap() {
        return new HashMap();
    }

    public static <K, V> Map<K, WeakReference<V>> createSyncWeakMap() {
        return Collections.synchronizedMap(new WeakHashMap());
    }

    @SafeVarargs
    public static <T> Set<T> createSet(T ... elements) {
        return Sets.newHashSet(elements);
    }

    public static <T> Set<T> createSet(T element) {
        Set<T> result = CollectionFactory.createSet();
        result.add(element);
        return result;
    }

    public static <T> Set<T> createSyncSet() {
        ConcurrentHashMap internalMap = CollectionFactory.createSyncMap();
        return Collections.newSetFromMap(internalMap);
    }

    public static <K, V> ConcurrentHashMap<K, V> createSyncMap() {
        return new ConcurrentHashMap(16, 0.75f, EXPECTEDTHREADS.get());
    }

    public static <T> Set<T> getCopyOnRequestSet(Collection<T> source) {
        return CollectionFactory.getCopyOnRequestSetFromMutableCollection(source);
    }

    public static <T> Set<T> getCopyOnRequestSetFromMutableCollection(@Nullable Collection<T> source) {
        if (source == null || source.isEmpty()) {
            return Collections.emptySet();
        }
        return new ConditionalCopySet<T>(source, true);
    }

    public static <T> Set<T> copy(@Nullable Collection<T> source) {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(source);
    }

    public static <T> Set<T> copyMutable(@Nullable Collection<T> source) {
        return CollectionFactory.getCopyOnRequestSetFromMutableCollection(source);
    }

    public static <T> Set<T> getCopyOnRequestSetFromImmutableCollection(@Nullable Collection<T> source) {
        if (source == null || source.isEmpty()) {
            return Collections.emptySet();
        }
        return new ConditionalCopySet<T>(source, false);
    }

    public static class ConditionalCopySet<T>
    implements Set<T> {
        private static final int MAXCONTAINS = 10;
        protected Collection<T> delegate;
        private boolean copyDone = false;
        private int containsCounter = 0;

        public ConditionalCopySet(Collection<T> source, boolean listCopy) {
            this.delegate = listCopy ? new ArrayList<T>(source) : source;
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj instanceof ConditionalCopySet) {
                return this.delegate.containsAll(((ConditionalCopySet)obj).delegate) && ((ConditionalCopySet)obj).delegate.containsAll(this.delegate);
            }
            if (obj instanceof Collection) {
                return this.delegate.containsAll((Collection)obj) && ((Collection)obj).containsAll(this.delegate);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public boolean add(@Nullable T e) {
            if (!this.copyDone) {
                this.copyDone = true;
                this.delegate = new LinkedHashSet<T>(this.delegate);
            }
            return this.delegate.add(e);
        }

        @Override
        public boolean addAll(@Nullable Collection<? extends T> c) {
            if (!this.copyDone) {
                this.copyDone = true;
                this.delegate = new LinkedHashSet<T>(this.delegate);
            }
            return this.delegate.addAll(c);
        }

        @Override
        public void clear() {
            if (!this.copyDone) {
                this.copyDone = true;
                this.delegate = new LinkedHashSet<T>();
            }
            this.delegate.clear();
        }

        @Override
        public boolean contains(@Nullable Object o) {
            ++this.containsCounter;
            if (this.containsCounter >= 10 && !this.copyDone) {
                this.checkDelegate();
            }
            return this.delegate.contains(o);
        }

        private void checkDelegate() {
            if (!(this.delegate instanceof Set)) {
                this.copyDone = true;
                this.delegate = new LinkedHashSet<T>(this.delegate);
            }
        }

        @Override
        public boolean containsAll(@Nullable Collection<?> c) {
            ++this.containsCounter;
            if (this.containsCounter >= 10 && !this.copyDone) {
                this.checkDelegate();
            }
            return this.delegate.containsAll(c);
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public boolean remove(@Nullable Object o) {
            if (!this.copyDone) {
                this.copyDone = true;
                this.delegate = new LinkedHashSet<T>(this.delegate);
            }
            return this.delegate.remove(o);
        }

        @Override
        public boolean removeAll(@Nullable Collection<?> c) {
            if (!this.copyDone) {
                this.copyDone = true;
                this.delegate = new LinkedHashSet<T>(this.delegate);
            }
            return this.delegate.removeAll(c);
        }

        @Override
        public boolean retainAll(@Nullable Collection<?> c) {
            if (!this.copyDone) {
                this.copyDone = true;
                this.delegate = new LinkedHashSet<T>(this.delegate);
            }
            return this.delegate.retainAll(c);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <Q> Q[] toArray(@Nullable Q[] a) {
            return this.delegate.toArray(a);
        }
    }
}

