/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import com.google.common.base.Splitter;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.annotations.HasPriority;
import org.semanticweb.owlapi.io.DocumentSources;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.SAXParsers;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWLXMLVocabulary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@HasPriority(value=1.0)
public class AutoIRIMapper
extends DefaultHandler
implements OWLOntologyIRIMapper,
Serializable {
    static final Pattern pattern = Pattern.compile("Ontology\\(<([^>]+)>");
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoIRIMapper.class);
    private final Set<String> fileExtensions = new HashSet<String>();
    private final boolean recursive;
    private final Map<String, OntologyRootElementHandler> handlerMap = CollectionFactory.createMap();
    private final Map<IRI, IRI> ontologyIRI2PhysicalURIMap = CollectionFactory.createMap();
    private final Map<String, IRI> oboFileMap = CollectionFactory.createMap();
    private final String directoryPath;
    private boolean mapped;
    @Nullable
    private transient File currentFile;

    public AutoIRIMapper(File rootDirectory, boolean recursive) {
        this.directoryPath = OWLAPIPreconditions.checkNotNull(rootDirectory, "rootDirectory cannot be null").getAbsolutePath();
        this.recursive = recursive;
        this.fileExtensions.add(".owl");
        this.fileExtensions.add(".xml");
        this.fileExtensions.add(".rdf");
        this.fileExtensions.add(".omn");
        this.fileExtensions.add(".ofn");
        this.mapped = false;
        this.handlerMap.put((Object)((Object)Namespaces.RDF) + "RDF", attributes -> {
            String baseValue = attributes.getValue(Namespaces.XML.toString(), "base");
            if (baseValue == null) {
                return null;
            }
            return IRI.create(baseValue);
        });
        this.handlerMap.put(OWLXMLVocabulary.ONTOLOGY.toString(), attributes -> {
            String ontURI = attributes.getValue(Namespaces.OWL.toString(), "ontologyIRI");
            if (ontURI == null) {
                ontURI = attributes.getValue("ontologyIRI");
            }
            if (ontURI == null) {
                return null;
            }
            return IRI.create(ontURI);
        });
    }

    static IRI unquote(String tok) {
        String substring = tok.substring(1, tok.length() - 1);
        assert (substring != null);
        return IRI.create(substring);
    }

    protected File getDirectory() {
        return new File(this.directoryPath);
    }

    public Set<String> getFileExtensions() {
        return new HashSet<String>(this.fileExtensions);
    }

    public void setFileExtensions(Collection<String> extensions) {
        this.fileExtensions.clear();
        this.fileExtensions.addAll(extensions);
    }

    public Set<IRI> getOntologyIRIs() {
        if (!this.mapped) {
            this.mapFiles();
        }
        return new HashSet<IRI>(this.ontologyIRI2PhysicalURIMap.keySet());
    }

    public void update() {
        this.mapFiles();
    }

    @Override
    @Nullable
    public IRI getDocumentIRI(IRI ontologyIRI) {
        int lastSepIndex;
        String name;
        IRI documentIRI;
        String path;
        if (!this.mapped) {
            this.mapFiles();
        }
        if (ontologyIRI.toString().endsWith(".obo") && (path = ontologyIRI.toURI().getPath()) != null && (documentIRI = this.oboFileMap.get(name = path.substring((lastSepIndex = path.lastIndexOf(47)) + 1, path.length()))) != null) {
            return documentIRI;
        }
        return this.ontologyIRI2PhysicalURIMap.get(ontologyIRI);
    }

    private void mapFiles() {
        this.mapped = true;
        this.ontologyIRI2PhysicalURIMap.clear();
        this.processFile(this.getDirectory());
    }

    private void processFile(File f) {
        if (f.isHidden()) {
            return;
        }
        File[] files = f.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory() && this.recursive) {
                this.processFile(file);
                continue;
            }
            this.parseIfExtensionSupported(file);
        }
    }

    protected void parseIfExtensionSupported(File file) {
        String name = file.getName();
        int lastIndexOf = name.lastIndexOf(46);
        if (lastIndexOf < 0) {
            return;
        }
        String extension = name.substring(lastIndexOf);
        if (".obo".equals(extension)) {
            this.oboFileMap.put(name, IRI.create(file));
        } else if (".ofn".equals(extension)) {
            this.parseFSSFile(file);
        } else if (".omn".equals(extension)) {
            this.parseManchesterSyntaxFile(file);
        } else if (this.fileExtensions.contains(extension)) {
            this.parseFile(file);
        }
    }

    private void parseFSSFile(File file) {
        try (FileInputStream input = new FileInputStream(file);
             InputStreamReader reader = new InputStreamReader((InputStream)input, "UTF-8");
             BufferedReader br = new BufferedReader(reader);){
            String line = "";
            Matcher m = pattern.matcher(line);
            int n = 0;
            while ((line = br.readLine()) != null && n++ < 100) {
                m.reset(line);
                if (!m.matches()) continue;
                String group = m.group(1);
                assert (group != null);
                this.addMapping(IRI.create(group), file);
                break;
            }
        }
        catch (IOException e) {
            LOGGER.debug("Exception reading file", e);
        }
    }

    private void parseFile(File file) {
        try (FileInputStream in = new FileInputStream(file);
             BufferedInputStream delegate = new BufferedInputStream(in);
             InputStream is = DocumentSources.wrap(delegate);){
            this.currentFile = file;
            SAXParsers.initParserWithOWLAPIStandards(null, "64000").parse(is, (DefaultHandler)this);
        }
        catch (IOException | SAXException e) {
            LOGGER.debug("Exception reading file", e);
        }
    }

    /*
     * Loose catch block
     */
    private void parseManchesterSyntaxFile(File file) {
        try (FileInputStream input = new FileInputStream(file);
             InputStreamReader reader = new InputStreamReader((InputStream)input, StandardCharsets.UTF_8);){
            BufferedReader br = new BufferedReader(reader);
            Throwable throwable = null;
            String line = br.readLine();
            {
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (br != null) {
                            if (throwable != null) {
                                try {
                                    br.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                br.close();
                            }
                        }
                        throw throwable3;
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.debug("Exception reading file", e);
        }
    }

    @Nullable
    private IRI parseManLine(File file, String line) {
        for (String tok : Splitter.on(" ").split(line)) {
            if (!tok.startsWith("<") || !tok.endsWith(">")) continue;
            IRI iri = AutoIRIMapper.unquote(tok);
            this.addMapping(iri, file);
            return iri;
        }
        return null;
    }

    @Override
    public void startElement(@Nullable String uri, @Nullable String localName, @Nullable String qName, @Nullable Attributes attributes) throws SAXException {
        OntologyRootElementHandler handler = this.handlerMap.get(uri + localName);
        if (handler != null) {
            IRI ontologyIRI = handler.handle(OWLAPIPreconditions.checkNotNull(attributes));
            if (ontologyIRI != null && this.currentFile != null) {
                this.addMapping(ontologyIRI, OWLAPIPreconditions.verifyNotNull(this.currentFile));
            }
            throw new SAXException();
        }
    }

    protected void addMapping(IRI ontologyIRI, File file) {
        this.ontologyIRI2PhysicalURIMap.put(ontologyIRI, IRI.create(file));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AutoIRIMapper: (");
        sb.append(this.ontologyIRI2PhysicalURIMap.size()).append(" ontologies)\n");
        this.ontologyIRI2PhysicalURIMap.forEach((k, v) -> sb.append("    ").append(k.toQuotedString()).append(" -> ").append((CharSequence)v).append('\n'));
        return sb.toString();
    }

    @FunctionalInterface
    private static interface OntologyRootElementHandler
    extends Serializable {
        @Nullable
        public IRI handle(Attributes var1);
    }
}

