/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.dlsyntax.renderer;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.dlsyntax.renderer.DLSyntaxObjectRenderer;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.AbstractOWLStorer;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public abstract class DLSyntaxStorerBase
extends AbstractOWLStorer {
    private DLSyntaxObjectRenderer ren = new DLSyntaxObjectRenderer();

    @Override
    protected void storeOntology(OWLOntology o, PrintWriter printWriter, OWLDocumentFormat format) {
        OWLAPIPreconditions.checkNotNull(o, "ontology cannot be null");
        OWLAPIPreconditions.checkNotNull(printWriter, "writer cannot be null");
        HashSet printed = new HashSet();
        this.beginWritingOntology(o, printWriter);
        CollectionFactory.sortOptionally(o.objectPropertiesInSignature()).forEach(p -> this.write(o, (OWLEntity)p, o.axioms((OWLObjectPropertyExpression)p), printWriter, (Set<OWLAxiom>)printed));
        CollectionFactory.sortOptionally(o.dataPropertiesInSignature()).forEach(p -> this.write(o, (OWLEntity)p, o.axioms((OWLDataProperty)p), printWriter, (Set<OWLAxiom>)printed));
        CollectionFactory.sortOptionally(o.classesInSignature()).forEach(c -> this.write(o, (OWLEntity)c, o.axioms((OWLClass)c), printWriter, (Set<OWLAxiom>)printed));
        CollectionFactory.sortOptionally(o.individualsInSignature()).forEach(i -> this.write(o, (OWLEntity)i, o.axioms((OWLIndividual)i), printWriter, (Set<OWLAxiom>)printed));
        this.beginWritingGeneralAxioms(printWriter);
        CollectionFactory.sortOptionally(o.generalClassAxioms()).forEach(ax -> {
            if (printed.add(ax)) {
                this.beginWritingAxiom(printWriter);
                this.writeAxiom(null, (OWLAxiom)ax, printWriter);
                this.endWritingAxiom(printWriter);
            }
        });
        this.endWritingGeneralAxioms(printWriter);
        this.endWritingOntology(o, printWriter);
        printWriter.flush();
    }

    private void write(OWLOntology ont, OWLEntity entity, Collection<? extends OWLAxiom> axioms, PrintWriter writer, Set<OWLAxiom> printed) {
        this.beginWritingAxioms(entity, writer);
        for (OWLAxiom oWLAxiom : axioms) {
            if (!printed.add(oWLAxiom)) continue;
            this.beginWritingAxiom(writer);
            this.writeAxiom(entity, oWLAxiom, writer);
            this.endWritingAxiom(writer);
        }
        List<OWLAxiom> usages = CollectionFactory.sortOptionally(ont.referencingAxioms(entity));
        usages.removeAll(axioms);
        this.beginWritingUsage(usages.size(), writer);
        for (OWLAxiom usage : usages) {
            if (axioms.contains(usage) || !printed.add(usage)) continue;
            this.beginWritingAxiom(writer);
            this.writeAxiom(entity, usage, writer);
            this.endWritingAxiom(writer);
        }
        this.endWritingUsage(writer);
        this.endWritingAxioms(writer);
    }

    private void write(OWLOntology ont, OWLEntity entity, Stream<? extends OWLAxiom> axioms, PrintWriter writer, Set<OWLAxiom> printed) {
        this.write(ont, entity, OWLAPIStreamUtils.asList(axioms), writer, printed);
    }

    protected void writeAxiom(@Nullable OWLEntity subject, OWLAxiom axiom, PrintWriter writer) {
        writer.write(this.getRendering(subject, axiom));
    }

    protected String getRendering(@Nullable OWLEntity subject, OWLAxiom axiom) {
        return this.ren.render(axiom);
    }

    protected void beginWritingOntology(OWLOntology ontology, PrintWriter writer) {
    }

    protected void endWritingOntology(OWLOntology ontology, PrintWriter writer) {
    }

    protected void beginWritingAxiom(PrintWriter writer) {
    }

    protected void endWritingAxiom(PrintWriter writer) {
    }

    protected void beginWritingAxioms(OWLEntity subject, PrintWriter writer) {
    }

    protected void endWritingAxioms(PrintWriter writer) {
    }

    protected void beginWritingUsage(int size, PrintWriter writer) {
    }

    protected void endWritingUsage(PrintWriter writer) {
    }

    protected void beginWritingGeneralAxioms(PrintWriter writer) {
    }

    protected void endWritingGeneralAxioms(PrintWriter writer) {
    }
}

