/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.unsafe.impl.batchimport.cache.IntArray;
import org.neo4j.unsafe.impl.batchimport.cache.OffHeapNumberArray;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

public class OffHeapIntArray
extends OffHeapNumberArray
implements IntArray {
    private final int defaultValue;

    public OffHeapIntArray(long length, int defaultValue) {
        super(length, 2);
        this.defaultValue = defaultValue;
        this.clear();
    }

    @Override
    public int get(long index) {
        return UnsafeUtil.getInt(this.addressOf(index));
    }

    @Override
    public void set(long index, int value) {
        UnsafeUtil.putInt(this.addressOf(index), value);
    }

    @Override
    public void clear() {
        if (this.isByteUniform(this.defaultValue)) {
            UnsafeUtil.setMemory(this.address, this.length << this.shift, (byte)this.defaultValue);
        } else {
            long i = 0L;
            long adr = this.address;
            while (i < this.length) {
                UnsafeUtil.putInt(adr, this.defaultValue);
                ++i;
                adr += (long)this.stride;
            }
        }
    }

    @Override
    public void swap(long fromIndex, long toIndex, int numberOfEntries) {
        long fromAddress = this.addressOf(fromIndex);
        long toAddress = this.addressOf(toIndex);
        int i = 0;
        while (i < numberOfEntries) {
            int fromValue = UnsafeUtil.getInt(fromAddress);
            UnsafeUtil.putInt(fromAddress, UnsafeUtil.getInt(toAddress));
            UnsafeUtil.putInt(toAddress, fromValue);
            ++i;
            fromAddress += (long)this.stride;
            toAddress += (long)this.stride;
        }
    }

    @Override
    public IntArray fixate() {
        return this;
    }
}

