/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.helpers.Cancelable;
import org.neo4j.shell.CtrlCHandler;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class InterruptSignalHandler
implements SignalHandler,
CtrlCHandler {
    private static InterruptSignalHandler INSTANCE = new InterruptSignalHandler();
    private final Signal signal = new Signal("INT");
    private final AtomicReference<Runnable> actionRef = new AtomicReference();

    private InterruptSignalHandler() {
    }

    public static InterruptSignalHandler getHandler() {
        return INSTANCE;
    }

    @Override
    public Cancelable install(final Runnable action) {
        if (!this.actionRef.compareAndSet(null, action)) {
            throw new RuntimeException("An action has already been registered");
        }
        final SignalHandler oldHandler = Signal.handle(this.signal, this);
        final InterruptSignalHandler self = this;
        return new Cancelable(){

            @Override
            public void cancel() {
                SignalHandler handle = Signal.handle(InterruptSignalHandler.this.signal, oldHandler);
                if (self != handle) {
                    throw new RuntimeException("Error uninstalling ShellSignalHandler: another handler interjected in the mean time");
                }
                if (!self.actionRef.compareAndSet(action, null)) {
                    throw new RuntimeException("Popping a action that has not been pushed before");
                }
            }
        };
    }

    @Override
    public void handle(Signal signal) {
        try {
            this.actionRef.get().run();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

