/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.neo4j.function.Function;
import org.neo4j.logging.AbstractLogProvider;
import org.neo4j.logging.DuplicatingLog;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class DuplicatingLogProvider
extends AbstractLogProvider<DuplicatingLog> {
    private final CopyOnWriteArraySet<LogProvider> logProviders;
    private final Map<DuplicatingLog, Map<LogProvider, Log>> duplicatingLogCache = Collections.synchronizedMap(new WeakHashMap());

    public DuplicatingLogProvider(LogProvider ... logProviders) {
        this.logProviders = new CopyOnWriteArraySet<LogProvider>(Arrays.asList(logProviders));
    }

    public boolean remove(LogProvider logProvider) {
        if (!this.logProviders.remove(logProvider)) {
            return false;
        }
        for (DuplicatingLog duplicatingLog : this.cachedLogs()) {
            duplicatingLog.remove(this.duplicatingLogCache.get(duplicatingLog).remove(logProvider));
        }
        return true;
    }

    @Override
    protected DuplicatingLog buildLog(final Class loggingClass) {
        return this.buildLog(new Function<LogProvider, Log>(){

            @Override
            public Log apply(LogProvider logProvider) {
                return logProvider.getLog(loggingClass);
            }
        });
    }

    @Override
    protected DuplicatingLog buildLog(final String name) {
        return this.buildLog(new Function<LogProvider, Log>(){

            @Override
            public Log apply(LogProvider logProvider) {
                return logProvider.getLog(name);
            }
        });
    }

    private DuplicatingLog buildLog(Function<LogProvider, Log> logConstructor) {
        ArrayList<Log> logs = new ArrayList<Log>(this.logProviders.size());
        HashMap<LogProvider, Log> providedLogs = new HashMap<LogProvider, Log>();
        for (LogProvider logProvider : this.logProviders) {
            Log log = logConstructor.apply(logProvider);
            providedLogs.put(logProvider, log);
            logs.add(log);
        }
        DuplicatingLog duplicatingLog = new DuplicatingLog(logs);
        this.duplicatingLogCache.put(duplicatingLog, providedLogs);
        return duplicatingLog;
    }
}

