/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import org.neo4j.function.ThrowingLongFunction;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.recovery.LatestCheckPointFinder;

public class PositionToRecoverFrom
implements ThrowingLongFunction<LogPosition, IOException> {
    private final LatestCheckPointFinder checkPointFinder;

    public PositionToRecoverFrom(LatestCheckPointFinder checkPointFinder) {
        this.checkPointFinder = checkPointFinder;
    }

    @Override
    public LogPosition apply(long currentLogVersion) throws IOException {
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = this.checkPointFinder.find(currentLogVersion);
        if (!latestCheckPoint.commitsAfterCheckPoint) {
            return LogPosition.UNSPECIFIED;
        }
        if (latestCheckPoint.checkPoint != null) {
            return latestCheckPoint.checkPoint.getLogPosition();
        }
        if (latestCheckPoint.oldestLogVersionFound != 0L) {
            long fromLogVersion = Math.max(0L, latestCheckPoint.oldestLogVersionFound);
            throw new UnderlyingStorageException("No check point found in any log file from version " + fromLogVersion + " to " + currentLogVersion);
        }
        return LogPosition.start(0L);
    }
}

