/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.neo4j.function.Function;
import org.neo4j.kernel.impl.util.NumberAwareStringComparator;
import org.neo4j.kernel.impl.util.Validators;

public class Converters {
    public static final Comparator<File> BY_FILE_NAME = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    public static final Comparator<File> BY_FILE_NAME_WITH_CLEVER_NUMBERS = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            return NumberAwareStringComparator.INSTANCE.compare(o1.getAbsolutePath(), o2.getAbsolutePath());
        }
    };

    public static <T> Function<String, T> mandatory() {
        return new Function<String, T>(){

            @Override
            public T apply(String key) {
                throw new IllegalArgumentException("Missing argument '" + key + "'");
            }
        };
    }

    public static <T> Function<String, T> optional() {
        return new Function<String, T>(){

            @Override
            public T apply(String from) {
                return null;
            }
        };
    }

    public static <T> Function<String, T> withDefault(final T defaultValue) {
        return new Function<String, T>(){

            @Override
            public T apply(String from) {
                return defaultValue;
            }
        };
    }

    public static Function<String, File> toFile() {
        return new Function<String, File>(){

            @Override
            public File apply(String from) {
                return new File(from);
            }
        };
    }

    public static Function<String, File[]> regexFiles(final boolean cleverNumberRegexSort) {
        return new Function<String, File[]>(){

            @Override
            public File[] apply(String name) throws RuntimeException {
                Comparator<File> sorting = cleverNumberRegexSort ? BY_FILE_NAME_WITH_CLEVER_NUMBERS : BY_FILE_NAME;
                List<File> files = Validators.matchingFiles(new File(name));
                Collections.sort(files, sorting);
                return files.toArray(new File[files.size()]);
            }
        };
    }

    public static Function<String, File[]> toFiles(final String delimiter, final Function<String, File[]> eachFileConverter) {
        return new Function<String, File[]>(){

            @Override
            public File[] apply(String from) {
                if (from == null) {
                    return new File[0];
                }
                String[] names = from.split(delimiter);
                ArrayList<File> files = new ArrayList<File>();
                for (String name : names) {
                    for (File file : (File[])eachFileConverter.apply(name)) {
                        files.add(file);
                    }
                }
                return files.toArray(new File[files.size()]);
            }
        };
    }

    public static Function<String, Character> toCharacter() {
        return new Function<String, Character>(){

            @Override
            public Character apply(String value) {
                if (value.length() > 1) {
                    throw new IllegalArgumentException("Invalid delimiter '" + value + "', expected one character");
                }
                return Character.valueOf(value.charAt(0));
            }
        };
    }

    public static Function<String, Integer> toInt() {
        return new Function<String, Integer>(){

            @Override
            public Integer apply(String from) {
                return new Integer(from);
            }
        };
    }
}

