/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.io.fs.AbstractStoreChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;

public class BufferedFileChannel
extends AbstractStoreChannel {
    private final StoreChannel source;
    private final ByteCounterMonitor monitor;
    private final byte[] intermediaryBuffer = new byte[8192];
    private int intermediaryBufferSize;
    private int intermediaryBufferPosition;

    public BufferedFileChannel(StoreChannel source, ByteCounterMonitor monitor) throws IOException {
        this.source = source;
        this.monitor = monitor;
        this.fillUpIntermediaryBuffer();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int read = 0;
        while (read < dst.limit() && ((read += this.readAsMuchAsPossibleFromIntermediaryBuffer(dst)) >= dst.limit() || this.fillUpIntermediaryBuffer() != -1)) {
        }
        return read == 0 && dst.limit() > 0 ? -1 : read;
    }

    private int readAsMuchAsPossibleFromIntermediaryBuffer(ByteBuffer dst) {
        int howMuchToRead = Math.min(dst.remaining(), this.remainingInIntermediaryBuffer());
        dst.put(this.intermediaryBuffer, this.intermediaryBufferPosition, howMuchToRead);
        this.intermediaryBufferPosition += howMuchToRead;
        return howMuchToRead;
    }

    private int remainingInIntermediaryBuffer() {
        return this.intermediaryBufferSize - this.intermediaryBufferPosition;
    }

    private int fillUpIntermediaryBuffer() throws IOException {
        int result = this.source.read(ByteBuffer.wrap(this.intermediaryBuffer));
        this.monitor.bytesRead(result);
        this.intermediaryBufferPosition = 0;
        this.intermediaryBufferSize = result == -1 ? 0 : result;
        return result;
    }

    @Override
    public long position() throws IOException {
        return this.source.position() - (long)this.intermediaryBufferSize + (long)this.intermediaryBufferPosition;
    }

    @Override
    public BufferedFileChannel position(long newPosition) throws IOException {
        long bufferEndPosition = this.source.position();
        long bufferStartPosition = bufferEndPosition - (long)this.intermediaryBufferSize;
        if (newPosition >= bufferStartPosition && newPosition <= bufferEndPosition) {
            long diff = newPosition - this.position();
            this.intermediaryBufferPosition = (int)((long)this.intermediaryBufferPosition + diff);
        } else {
            this.source.position(newPosition);
            this.fillUpIntermediaryBuffer();
        }
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.source.size();
    }

    @Override
    public BufferedFileChannel truncate(long size) throws IOException {
        this.source.truncate(size);
        return this;
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.source.force(metaData);
    }

    public StoreChannel getSource() {
        return this.source;
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }
}

