/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongObjectVisitor;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.api.index.UpdateMode;
import org.neo4j.kernel.impl.core.IteratingPropertyReceiver;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.state.LabelChangeSummary;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;

public class LazyIndexUpdates
implements Iterable<NodePropertyUpdate> {
    private final NodeStore nodeStore;
    private final PropertyStore propertyStore;
    private final PropertyLoader propertyLoader;
    private final PrimitiveLongObjectMap<List<Command.PropertyCommand>> propCommands;
    private final PrimitiveLongObjectMap<Command.NodeCommand> nodeCommands;
    private Collection<NodePropertyUpdate> updates;

    public LazyIndexUpdates(NodeStore nodeStore, PropertyStore propertyStore, PropertyLoader propertyLoader, PrimitiveLongObjectMap<List<Command.PropertyCommand>> propCommands, PrimitiveLongObjectMap<Command.NodeCommand> nodeCommands) {
        this.nodeStore = nodeStore;
        this.propertyStore = propertyStore;
        this.propertyLoader = propertyLoader;
        this.propCommands = propCommands;
        this.nodeCommands = nodeCommands;
    }

    @Override
    public Iterator<NodePropertyUpdate> iterator() {
        if (this.updates == null) {
            this.updates = this.gatherPropertyAndLabelUpdates();
        }
        return this.updates.iterator();
    }

    private Collection<NodePropertyUpdate> gatherPropertyAndLabelUpdates() {
        HashSet<NodePropertyUpdate> propertyUpdates = new HashSet<NodePropertyUpdate>();
        HashMap<Pair<Long, Integer>, NodePropertyUpdate> propertyChanges = new HashMap<Pair<Long, Integer>, NodePropertyUpdate>();
        this.gatherUpdatesFromPropertyCommands(propertyUpdates, propertyChanges);
        this.gatherUpdatesFromNodeCommands(propertyUpdates, propertyChanges);
        return propertyUpdates;
    }

    private void gatherUpdatesFromPropertyCommands(final Collection<NodePropertyUpdate> updates, Map<Pair<Long, Integer>, NodePropertyUpdate> propertyLookup) {
        this.propCommands.visitEntries(new PrimitiveLongObjectVisitor<List<Command.PropertyCommand>, RuntimeException>(){

            @Override
            public boolean visited(long nodeId, List<Command.PropertyCommand> propertyCommands) {
                LazyIndexUpdates.this.gatherUpdatesFromPropertyCommandsForNode(nodeId, propertyCommands, updates);
                return false;
            }
        });
        for (NodePropertyUpdate update : updates) {
            if (update.getUpdateMode() != UpdateMode.CHANGED) continue;
            propertyLookup.put(Pair.of(update.getNodeId(), update.getPropertyKeyId()), update);
        }
    }

    private void gatherUpdatesFromPropertyCommandsForNode(long nodeId, List<Command.PropertyCommand> propertyCommandsForNode, Collection<NodePropertyUpdate> updates) {
        long[] nodeLabelsAfter;
        long[] nodeLabelsBefore;
        Command.NodeCommand nodeChanges = this.nodeCommands.get(nodeId);
        if (nodeChanges != null) {
            nodeLabelsBefore = NodeLabelsField.parseLabelsField(nodeChanges.getBefore()).get(this.nodeStore);
            nodeLabelsAfter = NodeLabelsField.parseLabelsField(nodeChanges.getAfter()).get(this.nodeStore);
        } else {
            NodeRecord nodeRecord = this.nodeStore.getRecord(nodeId);
            nodeLabelsBefore = nodeLabelsAfter = NodeLabelsField.parseLabelsField(nodeRecord).get(this.nodeStore);
        }
        this.propertyStore.toLogicalUpdates(updates, Iterables.cast(propertyCommandsForNode), nodeLabelsBefore, nodeLabelsAfter);
    }

    private void gatherUpdatesFromNodeCommands(final Collection<NodePropertyUpdate> propertyUpdates, final Map<Pair<Long, Integer>, NodePropertyUpdate> propertyLookup) {
        this.nodeCommands.visitEntries(new PrimitiveLongObjectVisitor<Command.NodeCommand, RuntimeException>(){

            @Override
            public boolean visited(long key, Command.NodeCommand nodeCommand) {
                LazyIndexUpdates.this.gatherUpdatesFromNodeCommand(nodeCommand, propertyUpdates, propertyLookup);
                return false;
            }
        });
    }

    private void gatherUpdatesFromNodeCommand(Command.NodeCommand nodeCommand, Collection<NodePropertyUpdate> propertyUpdates, Map<Pair<Long, Integer>, NodePropertyUpdate> propertyLookup) {
        long nodeId = nodeCommand.getKey();
        long[] labelsBefore = NodeLabelsField.parseLabelsField(nodeCommand.getBefore()).get(this.nodeStore);
        long[] labelsAfter = NodeLabelsField.parseLabelsField(nodeCommand.getAfter()).get(this.nodeStore);
        if (nodeCommand.getMode() == Command.Mode.DELETE) {
            return;
        }
        LabelChangeSummary summary = new LabelChangeSummary(labelsBefore, labelsAfter);
        if (!summary.hasAddedLabels() && !summary.hasRemovedLabels()) {
            return;
        }
        Iterator<DefinedProperty> properties = this.nodeFullyLoadProperties(nodeId);
        while (properties.hasNext()) {
            DefinedProperty property = properties.next();
            int propertyKeyId = property.propertyKeyId();
            if (summary.hasAddedLabels()) {
                Object value = property.value();
                propertyUpdates.add(NodePropertyUpdate.add(nodeId, propertyKeyId, value, summary.getAddedLabels()));
            }
            if (!summary.hasRemovedLabels()) continue;
            NodePropertyUpdate propertyChange = propertyLookup.get(Pair.of(nodeId, propertyKeyId));
            Object value = propertyChange == null ? property.value() : propertyChange.getValueBefore();
            propertyUpdates.add(NodePropertyUpdate.remove(nodeId, propertyKeyId, value, summary.getRemovedLabels()));
        }
    }

    private Iterator<DefinedProperty> nodeFullyLoadProperties(long nodeId) {
        Command.NodeCommand nodeCommand = this.nodeCommands.get(nodeId);
        NodeRecord nodeRecord = nodeCommand == null ? this.nodeStore.getRecord(nodeId) : nodeCommand.getAfter();
        IteratingPropertyReceiver receiver = new IteratingPropertyReceiver();
        PrimitiveLongObjectMap<PropertyRecord> propertiesById = this.propertiesFromCommandsForNode(nodeRecord.getId());
        this.propertyLoader.nodeLoadProperties(nodeRecord, propertiesById, receiver);
        return receiver;
    }

    private PrimitiveLongObjectMap<PropertyRecord> propertiesFromCommandsForNode(long nodeId) {
        List<Command.PropertyCommand> propertyCommands = this.propCommands.get(nodeId);
        if (propertyCommands == null) {
            return PrimitiveLongCollections.emptyObjectMap();
        }
        PrimitiveLongObjectMap<PropertyRecord> result = Primitive.longObjectMap(propertyCommands.size());
        for (Command.PropertyCommand command : propertyCommands) {
            PropertyRecord after = command.getAfter();
            if (!after.inUse() || !after.isNodeSet()) continue;
            result.put(after.getId(), after);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LazyIndexUpdates that = (LazyIndexUpdates)o;
        if (this.nodeCommands != null ? !this.nodeCommands.equals(that.nodeCommands) : that.nodeCommands != null) {
            return false;
        }
        if (this.nodeStore != null ? !this.nodeStore.equals(that.nodeStore) : that.nodeStore != null) {
            return false;
        }
        if (this.propCommands != null ? !this.propCommands.equals(that.propCommands) : that.propCommands != null) {
            return false;
        }
        if (this.propertyLoader != null ? !this.propertyLoader.equals(that.propertyLoader) : that.propertyLoader != null) {
            return false;
        }
        if (this.propertyStore != null ? !this.propertyStore.equals(that.propertyStore) : that.propertyStore != null) {
            return false;
        }
        return !(this.updates != null ? !this.updates.equals(that.updates) : that.updates != null);
    }

    public int hashCode() {
        int result = this.nodeStore != null ? this.nodeStore.hashCode() : 0;
        result = 31 * result + (this.propertyStore != null ? this.propertyStore.hashCode() : 0);
        result = 31 * result + (this.propCommands != null ? this.propCommands.hashCode() : 0);
        result = 31 * result + (this.nodeCommands != null ? this.nodeCommands.hashCode() : 0);
        result = 31 * result + (this.updates != null ? this.updates.hashCode() : 0);
        result = 31 * result + (this.propertyLoader != null ? this.propertyLoader.hashCode() : 0);
        return result;
    }
}

