/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.DeferredIndexedConflictResolution;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.DuplicateCluster;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.DuplicatePropertyRemover;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.IndexLookup;

class IndexedConflictsResolver
implements Visitor<NodeRecord, IOException>,
AutoCloseable {
    private final PrimitiveLongObjectMap<List<DuplicateCluster>> duplicateClusters;
    private final NodeStore nodeStore;
    private final PropertyStore propertyStore;
    private final DuplicatePropertyRemover propertyRemover;
    private final List<DeferredIndexedConflictResolution> deferredResolutions;
    private final IndexLookup indexLookup;

    public IndexedConflictsResolver(PrimitiveLongObjectMap<List<DuplicateCluster>> duplicateClusters, IndexLookup indexLookup, NodeStore nodeStore, PropertyStore propertyStore) {
        this.duplicateClusters = duplicateClusters;
        this.indexLookup = indexLookup;
        this.nodeStore = nodeStore;
        this.propertyStore = propertyStore;
        this.propertyRemover = new DuplicatePropertyRemover(nodeStore, propertyStore);
        this.deferredResolutions = new ArrayList<DeferredIndexedConflictResolution>();
    }

    @Override
    public boolean visit(NodeRecord record) throws IOException {
        List<DuplicateCluster> duplicateClusterList = this.duplicateClusters.get(record.getNextProp());
        if (duplicateClusterList != null) {
            this.deferredResolutions.add(new DeferredIndexedConflictResolution(record.clone(), duplicateClusterList, this.nodeStore, this.indexLookup, this.propertyStore, this.propertyRemover));
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        for (DeferredIndexedConflictResolution deferredResolution : this.deferredResolutions) {
            deferredResolution.resolve();
        }
    }
}

