/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import org.neo4j.function.Predicate;
import org.neo4j.helpers.CloneableInPublic;

public abstract class AbstractBaseRecord
implements CloneableInPublic {
    private boolean inUse = false;
    private boolean created = false;
    private static final Predicate IN_USE_FILTER = new Predicate<AbstractBaseRecord>(){

        @Override
        public boolean test(AbstractBaseRecord item) {
            return item.inUse();
        }
    };
    private static final Predicate NOT_IN_USE_FILTER = new Predicate<AbstractBaseRecord>(){

        @Override
        public boolean test(AbstractBaseRecord item) {
            return !item.inUse();
        }
    };

    public abstract long getLongId();

    public final boolean inUse() {
        return this.inUse;
    }

    public void setInUse(boolean inUse) {
        this.inUse = inUse;
    }

    public final void setCreated() {
        this.created = true;
    }

    public final boolean isCreated() {
        return this.created;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long id = this.getLongId();
        result = 31 * result + (int)(id ^ id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractBaseRecord other = (AbstractBaseRecord)obj;
        return this.getLongId() == other.getLongId();
    }

    @Override
    public AbstractBaseRecord clone() {
        throw new UnsupportedOperationException();
    }

    public static <RECORD extends AbstractBaseRecord> Predicate<RECORD> inUseFilter() {
        return IN_USE_FILTER;
    }

    public static <RECORD extends AbstractBaseRecord> Predicate<RECORD> notInUseFilter() {
        return NOT_IN_USE_FILTER;
    }
}

