/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.OpenOption;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.store.kvstore.BigEndianByteArrayBuffer;
import org.neo4j.kernel.impl.store.kvstore.KeyValueStoreFile;
import org.neo4j.kernel.impl.store.kvstore.Metadata;
import org.neo4j.kernel.impl.store.kvstore.MetadataCollector;
import org.neo4j.unsafe.impl.internal.dragons.FeatureToggles;

class KeyValueWriter
implements Closeable {
    private final MetadataCollector metadata;
    private final Writer writer;
    private int keySize;
    private int valueSize;
    private State state = State.expecting_format_specifier;

    public static KeyValueWriter create(MetadataCollector metadata, FileSystemAbstraction fs, PageCache pages, File path, int pageSize) throws IOException {
        return new KeyValueWriter(metadata, Writer.create(fs, pages, path, pageSize));
    }

    KeyValueWriter(MetadataCollector metadata, Writer writer) {
        this.metadata = metadata;
        this.writer = writer;
    }

    public boolean writeHeader(BigEndianByteArrayBuffer key, BigEndianByteArrayBuffer value) throws IOException {
        boolean result = this.state.header(this, value.allZeroes());
        this.doWrite(key, value, State.done);
        return result;
    }

    public void writeData(BigEndianByteArrayBuffer key, BigEndianByteArrayBuffer value) throws IOException {
        this.state.data(this);
        assert (key.size() == this.keySize);
        assert (value.size() == this.valueSize);
        if (key.allZeroes()) {
            this.state = State.in_error;
            throw new IllegalArgumentException("All-zero keys are not allowed.");
        }
        if (!this.write(key, value)) {
            this.state = State.in_error;
            throw new IllegalStateException("MetadataCollector stopped on data field.");
        }
    }

    private void doWrite(BigEndianByteArrayBuffer key, BigEndianByteArrayBuffer value, State expectedNextState) throws IOException {
        this.keySize = key.size();
        this.valueSize = value.size();
        assert (key.allZeroes()) : "key should have been cleared by previous call";
        if (!this.write(key, value) && this.state != expectedNextState) {
            this.state = State.in_error;
            throw new IllegalStateException("MetadataCollector stopped before " + (Object)((Object)expectedNextState) + " reached.");
        }
    }

    private boolean write(BigEndianByteArrayBuffer key, BigEndianByteArrayBuffer value) throws IOException {
        boolean result = this.metadata.visit(key, value);
        this.writer.write(key.buffer);
        this.writer.write(value.buffer);
        key.clear();
        value.clear();
        return result;
    }

    public KeyValueStoreFile openStoreFile() throws IOException {
        this.state.open(this);
        return this.writer.open(this.metadata, this.keySize, this.valueSize);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private static class PageWriter
    extends Writer {
        private final PagedFile file;
        private PageCursor cursor;
        private boolean opened;

        PageWriter(PagedFile file) throws IOException {
            this.file = file;
            this.cursor = file.io(0L, 2);
            this.cursor.next();
        }

        @Override
        void write(byte[] data) throws IOException {
            if (this.cursor.getOffset() == this.file.pageSize()) {
                this.cursor.next();
            }
            this.cursor.putBytes(data);
        }

        @Override
        KeyValueStoreFile open(Metadata metadata, int keySize, int valueSize) throws IOException {
            KeyValueStoreFile result = new KeyValueStoreFile(this.file, keySize, valueSize, metadata);
            this.opened = true;
            return result;
        }

        @Override
        void close() throws IOException {
            this.cursor.close();
            this.cursor = null;
            if (this.opened) {
                this.file.flushAndForce();
            } else {
                this.file.close();
            }
        }
    }

    private static class OpeningStreamWriter
    extends StreamWriter {
        private final PageCache pages;
        private final File path;
        private final int pageSize;

        OpeningStreamWriter(OutputStream out, PageCache pages, File path, int pageSize) {
            super(out);
            this.pages = pages;
            this.path = path;
            this.pageSize = pageSize;
        }

        @Override
        KeyValueStoreFile open(Metadata metadata, int keySize, int valueSize) throws IOException {
            return new KeyValueStoreFile(this.pages.map(this.path, this.pageSize, new OpenOption[0]), keySize, valueSize, metadata);
        }
    }

    private static class StreamWriter
    extends Writer {
        private final OutputStream out;

        StreamWriter(OutputStream out) {
            this.out = out;
        }

        @Override
        void write(byte[] data) throws IOException {
            this.out.write(data);
        }

        @Override
        KeyValueStoreFile open(Metadata metadata, int keySize, int valueSize) throws IOException {
            return null;
        }

        @Override
        void close() throws IOException {
            this.out.flush();
            this.out.close();
        }
    }

    static abstract class Writer {
        private static final boolean WRITE_TO_PAGE_CACHE = FeatureToggles.flag(KeyValueWriter.class, "WRITE_TO_PAGE_CACHE", false);

        Writer() {
        }

        abstract void write(byte[] var1) throws IOException;

        abstract KeyValueStoreFile open(Metadata var1, int var2, int var3) throws IOException;

        abstract void close() throws IOException;

        static Writer create(FileSystemAbstraction fs, PageCache pages, File path, int pageSize) throws IOException {
            if (pages == null) {
                return new StreamWriter(fs.openAsOutputStream(path, false));
            }
            if (WRITE_TO_PAGE_CACHE) {
                return new PageWriter(pages.map(path, pageSize, new OpenOption[0]));
            }
            return new OpeningStreamWriter(fs.openAsOutputStream(path, false), pages, path, pageSize);
        }
    }

    private static enum State {
        expecting_format_specifier{

            @Override
            boolean header(KeyValueWriter writer, boolean zeroValue) {
                if (zeroValue) {
                    writer.state = 1.in_error;
                    return false;
                }
                writer.state = 1.expecting_header;
                return true;
            }
        }
        ,
        expecting_header{

            @Override
            boolean header(KeyValueWriter writer, boolean zeroValue) {
                writer.state = zeroValue ? 2.expecting_data : 2.writing_header;
                return true;
            }
        }
        ,
        writing_header{

            @Override
            boolean header(KeyValueWriter writer, boolean zeroValue) {
                if (zeroValue) {
                    writer.state = 3.done;
                }
                return true;
            }

            @Override
            void data(KeyValueWriter writer) {
                writer.state = 3.writing_data;
            }
        }
        ,
        expecting_data{

            @Override
            boolean header(KeyValueWriter writer, boolean zeroValue) {
                if (zeroValue) {
                    writer.state = 4.done;
                    return true;
                }
                writer.state = 4.in_error;
                return false;
            }

            @Override
            void data(KeyValueWriter writer) {
                writer.state = 4.writing_data;
            }
        }
        ,
        writing_data{

            @Override
            boolean header(KeyValueWriter writer, boolean zeroValue) {
                if (zeroValue) {
                    writer.state = 5.in_error;
                    return false;
                }
                writer.state = 5.done;
                return true;
            }

            @Override
            void data(KeyValueWriter writer) {
            }
        }
        ,
        done{

            @Override
            void open(KeyValueWriter writer) {
            }
        }
        ,
        in_error;


        boolean header(KeyValueWriter writer, boolean zeroValue) {
            throw this.illegalState(writer, "write header");
        }

        void data(KeyValueWriter writer) {
            throw this.illegalState(writer, "write data");
        }

        boolean trailer(KeyValueWriter writer, boolean zeroValue) {
            throw this.illegalState(writer, "write trailer");
        }

        void open(KeyValueWriter writer) {
            throw this.illegalState(writer, "open store file");
        }

        private IllegalStateException illegalState(KeyValueWriter writer, String what) {
            writer.state = State.in_error;
            return new IllegalStateException("Cannot " + what + " when " + this.name().replace('_', ' ') + ".");
        }
    }
}

