/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.neo4j.function.Consumer;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.locking.LockWrapper;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.kvstore.BigEndianByteArrayBuffer;
import org.neo4j.kernel.impl.store.kvstore.DataInitializer;
import org.neo4j.kernel.impl.store.kvstore.DataProvider;
import org.neo4j.kernel.impl.store.kvstore.DeadState;
import org.neo4j.kernel.impl.store.kvstore.EntryUpdater;
import org.neo4j.kernel.impl.store.kvstore.EntryVisitor;
import org.neo4j.kernel.impl.store.kvstore.HeaderField;
import org.neo4j.kernel.impl.store.kvstore.Headers;
import org.neo4j.kernel.impl.store.kvstore.KeyFormat;
import org.neo4j.kernel.impl.store.kvstore.KeyValueStoreFile;
import org.neo4j.kernel.impl.store.kvstore.KeyValueVisitor;
import org.neo4j.kernel.impl.store.kvstore.MetadataVisitor;
import org.neo4j.kernel.impl.store.kvstore.PreparedRotation;
import org.neo4j.kernel.impl.store.kvstore.ProgressiveFormat;
import org.neo4j.kernel.impl.store.kvstore.ProgressiveState;
import org.neo4j.kernel.impl.store.kvstore.ReadableBuffer;
import org.neo4j.kernel.impl.store.kvstore.Rotation;
import org.neo4j.kernel.impl.store.kvstore.RotationMonitor;
import org.neo4j.kernel.impl.store.kvstore.RotationState;
import org.neo4j.kernel.impl.store.kvstore.RotationStrategy;
import org.neo4j.kernel.impl.store.kvstore.RotationTimerFactory;
import org.neo4j.kernel.impl.store.kvstore.State;
import org.neo4j.kernel.impl.store.kvstore.UnknownKey;
import org.neo4j.kernel.impl.store.kvstore.ValueLookup;
import org.neo4j.kernel.impl.store.kvstore.WritableBuffer;
import org.neo4j.kernel.impl.util.function.Optional;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

@Rotation(value=Rotation.Strategy.LEFT_RIGHT)
@State(value=State.Strategy.CONCURRENT_HASH_MAP)
public abstract class AbstractKeyValueStore<Key>
extends LifecycleAdapter {
    private final ReadWriteLock updateLock = new ReentrantReadWriteLock(true);
    private final Format format;
    final RotationStrategy rotationStrategy;
    private RotationTimerFactory rotationTimerFactory;
    private volatile ProgressiveState<Key> state;
    private DataInitializer<EntryUpdater<Key>> stateInitializer;
    final int keySize;
    final int valueSize;

    public AbstractKeyValueStore(FileSystemAbstraction fs, PageCache pages, File base, RotationMonitor monitor, RotationTimerFactory timerFactory, int keySize, int valueSize, HeaderField<?> ... headerFields) {
        this.keySize = keySize;
        this.valueSize = valueSize;
        Rotation rotation = this.getClass().getAnnotation(Rotation.class);
        if (monitor == null) {
            monitor = RotationMonitor.NONE;
        }
        this.format = new Format(headerFields);
        this.rotationStrategy = rotation.value().create(fs, pages, this.format, monitor, base, rotation.parameters());
        this.rotationTimerFactory = timerFactory;
        this.state = new DeadState.Stopped(this.format, this.getClass().getAnnotation(State.class).value());
    }

    protected final void setEntryUpdaterInitializer(DataInitializer<EntryUpdater<Key>> stateInitializer) {
        this.stateInitializer = stateInitializer;
    }

    public String toString() {
        return String.format("%s[state=%s, hasChanges=%s]", this.getClass().getSimpleName(), this.state, this.state.hasChanges());
    }

    protected final <Value> Value lookup(Key key, Reader<Value> reader) throws IOException {
        ValueLookup<Value> lookup;
        return lookup.value(!this.state.lookup(key, lookup = new ValueLookup<Value>(reader)));
    }

    protected final void visitAll(Visitor visitor) throws IOException {
        ProgressiveState<Key> state = this.state;
        if (visitor instanceof MetadataVisitor) {
            ((MetadataVisitor)((Object)visitor)).visitMetadata(state.file(), this.headers(), state.storedEntryCount());
        }
        try (DataProvider provider = state.dataProvider();){
            this.transfer(provider, visitor);
        }
    }

    protected final void visitFile(File path, Visitor visitor) throws IOException {
        try (KeyValueStoreFile file = this.rotationStrategy.openStoreFile(path);){
            if (visitor instanceof MetadataVisitor) {
                ((MetadataVisitor)((Object)visitor)).visitMetadata(path, file.headers(), file.entryCount());
            }
            try (DataProvider provider = file.dataProvider();){
                this.transfer(provider, visitor);
            }
        }
    }

    protected abstract Key readKey(ReadableBuffer var1) throws UnknownKey;

    protected abstract void writeKey(Key var1, WritableBuffer var2);

    protected abstract void writeFormatSpecifier(WritableBuffer var1);

    protected abstract Headers initialHeaders(long var1);

    protected abstract int compareHeaders(Headers var1, Headers var2);

    protected boolean include(Key key, ReadableBuffer value) {
        return true;
    }

    protected final Headers headers() {
        return this.state.headers();
    }

    public int totalEntriesStored() {
        return this.state.storedEntryCount();
    }

    public final File currentFile() {
        return this.state.file();
    }

    @Override
    public final void init() throws IOException {
        try (LockWrapper ignored = LockWrapper.writeLock(this.updateLock);){
            this.state = this.state.initialize(this.rotationStrategy);
        }
    }

    @Override
    public final void start() throws IOException {
        try (LockWrapper ignored = LockWrapper.writeLock(this.updateLock);){
            this.state = this.state.start(this.stateInitializer);
        }
    }

    protected final Optional<EntryUpdater<Key>> updater(long version) {
        try (LockWrapper lock = LockWrapper.readLock(this.updateLock);){
            Optional optional = this.state.optionalUpdater(version, lock.get());
            return optional;
        }
    }

    protected final EntryUpdater<Key> updater() {
        try (LockWrapper lock = LockWrapper.readLock(this.updateLock);){
            EntryUpdater entryUpdater = this.state.unsafeUpdater(lock.get());
            return entryUpdater;
        }
    }

    protected final EntryUpdater<Key> resetter(long version) {
        try (LockWrapper lock = LockWrapper.writeLock(this.updateLock);){
            ProgressiveState<Key> current = this.state;
            EntryUpdater<Key> entryUpdater = current.resetter(lock.get(), new RotationTask(version));
            return entryUpdater;
        }
    }

    protected final PreparedRotation prepareRotation(final long version) {
        try (LockWrapper ignored = LockWrapper.writeLock(this.updateLock);){
            ProgressiveState<Key> prior = this.state;
            if (prior.storedVersion() == version && !prior.hasChanges()) {
                PreparedRotation preparedRotation = new PreparedRotation(){

                    @Override
                    public long rotate() throws IOException {
                        return version;
                    }
                };
                return preparedRotation;
            }
            RotationTask rotationTask = new RotationTask(version);
            return rotationTask;
        }
    }

    protected abstract void updateHeaders(Headers.Builder var1, long var2);

    @Override
    public final void shutdown() throws IOException {
        this.state = this.state.stop();
    }

    private boolean transfer(EntryVisitor<WritableBuffer> producer, EntryVisitor<ReadableBuffer> consumer) throws IOException {
        BigEndianByteArrayBuffer key = new BigEndianByteArrayBuffer(this.keySize);
        BigEndianByteArrayBuffer value = new BigEndianByteArrayBuffer(this.valueSize);
        while (producer.visit(key, value)) {
            if (consumer.visit(key, value)) continue;
            return false;
        }
        return true;
    }

    protected HeaderField<?>[] headerFieldsForFormat(ReadableBuffer formatSpecifier) {
        return this.format.defaultHeaderFieldsForFormat(formatSpecifier);
    }

    protected abstract long version(Headers var1);

    private final class Format
    extends ProgressiveFormat
    implements KeyFormat<Key> {
        Format(HeaderField<?> ... headerFields) {
            super(512, headerFields);
        }

        @Override
        protected void writeFormatSpecifier(WritableBuffer formatSpecifier) {
            AbstractKeyValueStore.this.writeFormatSpecifier(formatSpecifier);
        }

        @Override
        protected HeaderField<?>[] headerFieldsForFormat(ReadableBuffer formatSpecifier) {
            return AbstractKeyValueStore.this.headerFieldsForFormat(formatSpecifier);
        }

        HeaderField<?>[] defaultHeaderFieldsForFormat(ReadableBuffer formatSpecifier) {
            return super.headerFieldsForFormat(formatSpecifier);
        }

        @Override
        public void writeKey(Key key, WritableBuffer buffer) {
            AbstractKeyValueStore.this.writeKey(key, buffer);
        }

        @Override
        public int compareHeaders(Headers lhs, Headers rhs) {
            return AbstractKeyValueStore.this.compareHeaders(lhs, rhs);
        }

        @Override
        public Headers initialHeaders(long version) {
            return AbstractKeyValueStore.this.initialHeaders(version);
        }

        @Override
        public int keySize() {
            return AbstractKeyValueStore.this.keySize;
        }

        @Override
        public long version(Headers headers) {
            return AbstractKeyValueStore.this.version(headers);
        }

        @Override
        public DataProvider filter(final DataProvider provider) {
            return new DataProvider(){

                @Override
                public boolean visit(WritableBuffer key, WritableBuffer value) throws IOException {
                    while (provider.visit(key, value)) {
                        try {
                            if (!AbstractKeyValueStore.this.include(AbstractKeyValueStore.this.readKey(key), value)) continue;
                            return true;
                        }
                        catch (UnknownKey e) {
                            throw new IllegalArgumentException(e.getMessage(), e);
                        }
                    }
                    return false;
                }

                @Override
                public void close() throws IOException {
                    provider.close();
                }
            };
        }

        @Override
        public int valueSize() {
            return AbstractKeyValueStore.this.valueSize;
        }
    }

    public abstract class Visitor
    implements KeyValueVisitor {
        @Override
        public boolean visit(ReadableBuffer key, ReadableBuffer value) {
            try {
                return this.visitKeyValuePair(AbstractKeyValueStore.this.readKey(key), value);
            }
            catch (UnknownKey e) {
                return this.visitUnknownKey(e, key, value);
            }
        }

        protected boolean visitUnknownKey(UnknownKey exception, ReadableBuffer key, ReadableBuffer value) {
            throw new IllegalArgumentException(exception.getMessage(), exception);
        }

        protected abstract boolean visitKeyValuePair(Key var1, ReadableBuffer var2);
    }

    public static abstract class Reader<Value> {
        protected abstract Value parseValue(ReadableBuffer var1);

        protected Value defaultValue() {
            return null;
        }
    }

    private class RotationTask
    implements PreparedRotation,
    Runnable {
        private final RotationState<Key> rotation;

        RotationTask(long version) {
            this.rotation = AbstractKeyValueStore.this.state.prepareRotation(version);
            AbstractKeyValueStore.this.state = this.rotation;
        }

        @Override
        public long rotate() throws IOException {
            return this.rotate(false);
        }

        @Override
        public void run() {
            try (LockWrapper ignored = LockWrapper.writeLock(AbstractKeyValueStore.this.updateLock);){
                this.rotate(true);
            }
            catch (IOException e) {
                throw new UnderlyingStorageException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long rotate(boolean force) throws IOException {
            final long version = this.rotation.rotationVersion();
            ProgressiveState next = this.rotation.rotate(force, AbstractKeyValueStore.this.rotationStrategy, AbstractKeyValueStore.this.rotationTimerFactory, new Consumer<Headers.Builder>(){

                @Override
                public void accept(Headers.Builder value) {
                    AbstractKeyValueStore.this.updateHeaders(value, version);
                }
            });
            try (LockWrapper ignored = LockWrapper.writeLock(AbstractKeyValueStore.this.updateLock);){
                AbstractKeyValueStore.this.state = next;
            }
            finally {
                this.rotation.close();
            }
            return version;
        }
    }
}

