/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.IOCursor;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;

class TransactionStream {
    private final LogFile[] files;
    private final FileSystemAbstraction fs;
    private final boolean isContiguous;
    private final LogFile firstFile;

    public TransactionStream(FileSystemAbstraction fs, File path) throws IOException {
        this.fs = fs;
        ByteBuffer buffer = ByteBuffer.allocateDirect(713);
        File[] files = fs.listFiles(path, new TxFileFilter(fs));
        ArrayList<LogFile> logFiles = new ArrayList<LogFile>(files.length);
        for (File file : files) {
            LogFile logFile = new LogFile(fs, file, buffer);
            if (logFile.lastTxId <= 0L) continue;
            logFiles.add(logFile);
        }
        this.files = logFiles.toArray(new LogFile[logFiles.size()]);
        Arrays.sort(this.files);
        Comparable<File> first = null;
        Comparable<File> last = null;
        boolean isContiguous = true;
        for (Comparable<File> comparable : this.files) {
            if (last == null) {
                first = comparable;
            } else if (((LogFile)last).lastTxId < ((LogFile)comparable).header.lastCommittedTxId) {
                isContiguous = false;
            }
            last = comparable;
        }
        if (first == null) {
            throw new IOException(path + " does not contain any log files");
        }
        this.firstFile = first;
        this.isContiguous = isContiguous;
    }

    public boolean isContiguous() {
        return this.isContiguous;
    }

    public long firstTransactionId() {
        return ((LogFile)this.firstFile).header.lastCommittedTxId;
    }

    public IOCursor<CommittedTransactionRepresentation> cursor() throws IOException {
        return new Cursor();
    }

    public String rangeString(String prefixForEach) {
        StringBuilder result = new StringBuilder();
        for (LogFile file : this.files) {
            file.rangeString(result.append(prefixForEach));
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IOCursor<LogEntry> logEntryCursor(LogFile file, ByteBuffer buffer) throws IOException {
        StoreChannel channel = this.fs.open(file.file, "r");
        try {
            LogHeader header = LogHeaderReader.readLogHeader(buffer, channel, false);
            if (!header.equals(file.header)) {
                throw new IOException("Files have changed on disk.");
            }
        }
        finally {
            buffer.clear();
        }
        return TransactionStream.logEntryCursor(channel, file.header);
    }

    private static IOCursor<LogEntry> logEntryCursor(StoreChannel channel, LogHeader header) throws IOException {
        return new LogEntryCursor(new ReadAheadLogChannel(new PhysicalLogVersionedStoreChannel(channel, header.logVersion, header.logFormatVersion), LogVersionBridge.NO_MORE_CHANNELS, 4096));
    }

    private static class TxFileFilter
    implements FilenameFilter {
        private final FileSystemAbstraction fs;

        TxFileFilter(FileSystemAbstraction fs) {
            this.fs = fs;
        }

        @Override
        public boolean accept(File dir, String name) {
            File file = new File(dir, name);
            return this.fs.fileExists(file) && !this.fs.isDirectory(file) && name.startsWith("neostore.transaction.db") && !name.contains("active");
        }
    }

    private static class LogFile
    implements Comparable<LogFile> {
        private final LogHeader header;
        private final File file;
        private final long lastTxId;
        long cap = Long.MAX_VALUE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LogFile(FileSystemAbstraction fs, File file, ByteBuffer buffer) throws IOException {
            this.file = file;
            try (StoreChannel channel = fs.open(file, "r");){
                this.header = LogHeaderReader.readLogHeader(buffer, channel, false);
                try (IOCursor cursor = TransactionStream.logEntryCursor(channel, this.header);){
                    long txId = this.header.lastCommittedTxId;
                    while (cursor.next()) {
                        LogEntry entry = (LogEntry)cursor.get();
                        if (!(entry instanceof LogEntryCommit)) continue;
                        txId = ((LogEntryCommit)entry).getTxId();
                    }
                    this.lastTxId = txId;
                }
            }
            finally {
                buffer.clear();
            }
        }

        public String toString() {
            return this.rangeString(new StringBuilder()).toString();
        }

        public int hashCode() {
            return this.header.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof LogFile) {
                LogFile that = (LogFile)obj;
                return this.file.equals(that.file) && this.header.equals(that.header);
            }
            return false;
        }

        @Override
        public int compareTo(LogFile that) {
            int cmp = Long.compare(this.header.lastCommittedTxId, that.header.lastCommittedTxId);
            if (cmp == 0) {
                cmp = Long.compare(this.lastTxId, that.lastTxId);
            }
            return cmp;
        }

        StringBuilder rangeString(StringBuilder target) {
            return target.append(']').append(this.header.lastCommittedTxId).append(", ").append(this.lastTxId).append(']');
        }
    }

    private class Cursor
    implements IOCursor<CommittedTransactionRepresentation> {
        private final ByteBuffer buffer = ByteBuffer.allocateDirect(713);
        private int file;
        private CommittedTransactionRepresentation current;
        private IOCursor<LogEntry> entries;

        private Cursor() {
        }

        @Override
        public CommittedTransactionRepresentation get() {
            if (this.current == null) {
                throw new IllegalStateException("Cursor not initialized.");
            }
            return this.current;
        }

        @Override
        public boolean next() throws IOException {
            while (null == (this.current = this.readTransaction(this.entries))) {
                if (this.entries != null) {
                    this.entries.close();
                }
                if (null != (this.entries = this.openNext())) continue;
                return false;
            }
            return true;
        }

        private IOCursor<LogEntry> openNext() throws IOException {
            return this.file >= TransactionStream.this.files.length ? null : TransactionStream.this.logEntryCursor(TransactionStream.this.files[this.file++], this.buffer);
        }

        @Override
        public void close() throws IOException {
            if (this.entries != null) {
                this.entries.close();
            }
            this.file = TransactionStream.this.files.length;
        }

        private CommittedTransactionRepresentation readTransaction(IOCursor<LogEntry> entries) throws IOException {
            if (entries == null) {
                return null;
            }
            LogEntryStart start = null;
            ArrayList<Command> commands = new ArrayList<Command>();
            while (entries.next()) {
                LogEntry entry = entries.get();
                if (entry instanceof LogEntryStart) {
                    start = (LogEntryStart)entry;
                    commands.clear();
                    continue;
                }
                if (entry instanceof LogEntryCommit && start != null) {
                    LogEntryCommit commit = (LogEntryCommit)entry;
                    if (commit.getTxId() > ((TransactionStream)TransactionStream.this).files[this.file].cap) {
                        return null;
                    }
                    PhysicalTransactionRepresentation transaction = new PhysicalTransactionRepresentation(commands);
                    transaction.setHeader(start.getAdditionalHeader(), start.getMasterId(), start.getLocalId(), start.getTimeWritten(), start.getLastCommittedTxWhenTransactionStarted(), commit.getTimeWritten(), -1);
                    return new CommittedTransactionRepresentation(start, transaction, commit);
                }
                commands.add(((LogEntryCommand)entry.as()).getXaCommand());
            }
            return null;
        }
    }
}

