/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Collection;
import java.util.Iterator;
import org.neo4j.function.Function;
import org.neo4j.function.Functions;
import org.neo4j.function.Predicate;
import org.neo4j.function.Predicates;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.api.EntityType;
import org.neo4j.kernel.api.exceptions.schema.DuplicateEntitySchemaRuleException;
import org.neo4j.kernel.api.exceptions.schema.DuplicateSchemaRuleException;
import org.neo4j.kernel.api.exceptions.schema.EntitySchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaRuleAccess;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.NodePropertyConstraintRule;
import org.neo4j.kernel.impl.store.record.NodePropertyExistenceConstraintRule;
import org.neo4j.kernel.impl.store.record.PropertyConstraintRule;
import org.neo4j.kernel.impl.store.record.RelationshipPropertyConstraintRule;
import org.neo4j.kernel.impl.store.record.RelationshipPropertyExistenceConstraintRule;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.store.record.UniquePropertyConstraintRule;

public class SchemaStorage
implements SchemaRuleAccess {
    private final RecordStore<DynamicRecord> schemaStore;

    public SchemaStorage(RecordStore<DynamicRecord> schemaStore) {
        this.schemaStore = schemaStore;
    }

    public IndexRule indexRule(int labelId, int propertyKeyId) {
        return this.indexRule(labelId, propertyKeyId, IndexRuleKind.ALL);
    }

    public IndexRule indexRule(final int labelId, final int propertyKeyId, IndexRuleKind kind) {
        Iterator<IndexRule> rules = this.schemaRules(Functions.cast(IndexRule.class), IndexRule.class, new Predicate<IndexRule>(){

            @Override
            public boolean test(IndexRule rule) {
                return rule.getLabel() == labelId && rule.getPropertyKey() == propertyKeyId;
            }
        });
        IndexRule foundRule = null;
        while (rules.hasNext()) {
            IndexRule candidate = rules.next();
            if (!kind.isOfKind(candidate)) continue;
            if (foundRule != null) {
                throw new ThisShouldNotHappenError("Jake", String.format("Found more than one matching index rule, %s and %s", foundRule, candidate));
            }
            foundRule = candidate;
        }
        return foundRule;
    }

    public Iterator<IndexRule> allIndexRules() {
        return this.schemaRules(IndexRule.class);
    }

    public <R extends NodePropertyConstraintRule, T> Iterator<T> schemaRulesForNodes(Function<? super R, T> conversion, Class<R> type, final int labelId, Predicate<R> predicate) {
        return this.schemaRules(conversion, type, Predicates.all(predicate, new Predicate<R>(){

            @Override
            public boolean test(R rule) {
                return ((NodePropertyConstraintRule)rule).getLabel() == labelId;
            }
        }));
    }

    public <R extends RelationshipPropertyConstraintRule, T> Iterator<T> schemaRulesForRelationships(Function<? super R, T> conversion, Class<R> type, final int typeId, Predicate<R> predicate) {
        return this.schemaRules(conversion, type, Predicates.all(predicate, new Predicate<R>(){

            @Override
            public boolean test(R rule) {
                return ((RelationshipPropertyConstraintRule)rule).getRelationshipType() == typeId;
            }
        }));
    }

    private <R extends SchemaRule, T> Iterator<T> schemaRules(Function<? super R, T> conversion, final Class<R> ruleType, final Predicate<R> predicate) {
        Function<? super R, T> ruleConversion = conversion;
        return Iterables.map(ruleConversion, Iterables.filter(new Predicate<SchemaRule>(){

            @Override
            public boolean test(SchemaRule rule) {
                return ruleType.isAssignableFrom(rule.getKind().getRuleClass()) && predicate.test(rule);
            }
        }, this.loadAllSchemaRules()));
    }

    public <R extends SchemaRule, T> Iterator<T> schemaRules(Function<? super R, T> conversion, final Class<R> ruleClass) {
        Function<? super R, T> ruleConversion = conversion;
        return Iterables.map(ruleConversion, Iterables.filter(new Predicate<SchemaRule>(){

            @Override
            public boolean test(SchemaRule rule) {
                return ruleClass.isInstance(rule);
            }
        }, this.loadAllSchemaRules()));
    }

    public <R extends SchemaRule> Iterator<R> schemaRules(final Class<R> ruleClass) {
        Iterator<SchemaRule> result = Iterables.filter(new Predicate<SchemaRule>(){

            @Override
            public boolean test(SchemaRule rule) {
                return ruleClass.isInstance(rule);
            }
        }, this.loadAllSchemaRules());
        return result;
    }

    public Iterator<SchemaRule> loadAllSchemaRules() {
        return new PrefetchingIterator<SchemaRule>(){
            private final long highestId;
            private long currentId;
            private final byte[] scratchData;
            {
                this.highestId = SchemaStorage.this.schemaStore.getHighestPossibleIdInUse();
                this.currentId = 1L;
                this.scratchData = SchemaStorage.this.newRecordBuffer();
            }

            @Override
            protected SchemaRule fetchNextOrNull() {
                while (this.currentId <= this.highestId) {
                    long id;
                    ++this.currentId;
                    DynamicRecord record = (DynamicRecord)SchemaStorage.this.schemaStore.forceGetRecord(id);
                    if (!record.inUse() || !record.isStartRecord()) continue;
                    try {
                        return SchemaStorage.this.getSchemaRule(id, this.scratchData);
                    }
                    catch (MalformedSchemaRuleException e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            }
        };
    }

    @Override
    public SchemaRule loadSingleSchemaRule(long ruleId) throws MalformedSchemaRuleException {
        return this.getSchemaRule(ruleId, this.newRecordBuffer());
    }

    private byte[] newRecordBuffer() {
        return new byte[this.schemaStore.getRecordSize() * 4];
    }

    private SchemaRule getSchemaRule(long id, byte[] buffer) throws MalformedSchemaRuleException {
        Collection<DynamicRecord> records;
        try {
            records = this.schemaStore.getRecords(id);
        }
        catch (Exception e) {
            throw new MalformedSchemaRuleException(e.getMessage(), e);
        }
        return SchemaStore.readSchemaRule(id, records, buffer);
    }

    public long newRuleId() {
        return this.schemaStore.nextId();
    }

    public NodePropertyExistenceConstraintRule nodePropertyExistenceConstraint(int labelId, int propertyKeyId) throws SchemaRuleNotFoundException, DuplicateSchemaRuleException {
        return this.nodeConstraintRule(NodePropertyExistenceConstraintRule.class, labelId, propertyKeyId);
    }

    public RelationshipPropertyExistenceConstraintRule relationshipPropertyExistenceConstraint(int typeId, int propertyKeyId) throws SchemaRuleNotFoundException, DuplicateSchemaRuleException {
        return this.relationshipConstraintRule(RelationshipPropertyExistenceConstraintRule.class, typeId, propertyKeyId);
    }

    public UniquePropertyConstraintRule uniquenessConstraint(int labelId, int propertyKeyId) throws SchemaRuleNotFoundException, DuplicateSchemaRuleException {
        return this.nodeConstraintRule(UniquePropertyConstraintRule.class, labelId, propertyKeyId);
    }

    private <Rule extends NodePropertyConstraintRule> Rule nodeConstraintRule(Class<Rule> type, final int labelId, final int propertyKeyId) throws SchemaRuleNotFoundException, DuplicateEntitySchemaRuleException {
        Iterator<Rule> rules = this.schemaRules(Functions.cast(type), type, new Predicate<Rule>(){

            @Override
            public boolean test(Rule item) {
                return ((NodePropertyConstraintRule)item).getLabel() == labelId && ((PropertyConstraintRule)item).containsPropertyKeyId(propertyKeyId);
            }
        });
        if (!rules.hasNext()) {
            throw new EntitySchemaRuleNotFoundException(EntityType.NODE, labelId, propertyKeyId);
        }
        NodePropertyConstraintRule rule = (NodePropertyConstraintRule)rules.next();
        if (rules.hasNext()) {
            throw new DuplicateEntitySchemaRuleException(EntityType.NODE, labelId, propertyKeyId);
        }
        return (Rule)rule;
    }

    private <Rule extends RelationshipPropertyConstraintRule> Rule relationshipConstraintRule(Class<Rule> type, final int relationshipTypeId, final int propertyKeyId) throws SchemaRuleNotFoundException, DuplicateEntitySchemaRuleException {
        Iterator<Rule> rules = this.schemaRules(Functions.cast(type), type, new Predicate<Rule>(){

            @Override
            public boolean test(Rule item) {
                return ((RelationshipPropertyConstraintRule)item).getRelationshipType() == relationshipTypeId && ((PropertyConstraintRule)item).containsPropertyKeyId(propertyKeyId);
            }
        });
        if (!rules.hasNext()) {
            throw new EntitySchemaRuleNotFoundException(EntityType.RELATIONSHIP, relationshipTypeId, propertyKeyId);
        }
        RelationshipPropertyConstraintRule rule = (RelationshipPropertyConstraintRule)rules.next();
        if (rules.hasNext()) {
            throw new DuplicateEntitySchemaRuleException(EntityType.RELATIONSHIP, relationshipTypeId, propertyKeyId);
        }
        return (Rule)rule;
    }

    public static enum IndexRuleKind {
        INDEX{

            @Override
            public boolean isOfKind(IndexRule rule) {
                return !rule.isConstraintIndex();
            }
        }
        ,
        CONSTRAINT{

            @Override
            public boolean isOfKind(IndexRule rule) {
                return rule.isConstraintIndex();
            }
        }
        ,
        ALL{

            @Override
            public boolean isOfKind(IndexRule rule) {
                return true;
            }
        };


        public abstract boolean isOfKind(IndexRule var1);
    }
}

