/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.io.IOException;
import org.neo4j.cursor.Cursor;
import org.neo4j.function.Consumer;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.api.cursor.PropertyItem;
import org.neo4j.kernel.impl.api.store.StorePropertyPayloadCursor;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.record.Record;

public class StorePropertyCursor
implements Cursor<PropertyItem>,
PropertyItem {
    private final PropertyStore propertyStore;
    private final Consumer<StorePropertyCursor> instanceCache;
    private final StorePropertyPayloadCursor payload;
    private long nextPropertyRecordId;
    private Lock lock;

    public StorePropertyCursor(PropertyStore propertyStore, Consumer<StorePropertyCursor> instanceCache) {
        this.propertyStore = propertyStore;
        this.instanceCache = instanceCache;
        this.payload = new StorePropertyPayloadCursor(propertyStore.getStringStore(), propertyStore.getArrayStore());
    }

    public StorePropertyCursor init(long firstPropertyId, Lock lock) {
        this.nextPropertyRecordId = firstPropertyId;
        this.lock = lock;
        return this;
    }

    @Override
    public boolean next() {
        if (this.payload.next()) {
            return true;
        }
        if (this.nextPropertyRecordId == (long)Record.NO_NEXT_PROPERTY.intValue()) {
            return false;
        }
        long currentPropertyRecordId = this.nextPropertyRecordId;
        try (PageCursor cursor = this.propertyStore.newReadCursor(currentPropertyRecordId);){
            int offset = cursor.getOffset();
            do {
                cursor.setOffset(offset);
                this.nextPropertyRecordId = StorePropertyCursor.readNextPropertyRecordId(cursor);
                this.payload.clear();
                this.payload.init(cursor);
            } while (cursor.shouldRetry());
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
        if (!this.payload.next()) {
            throw new NotFoundException("Property record with id " + currentPropertyRecordId + " not in use");
        }
        return true;
    }

    @Override
    public int propertyKeyId() {
        return this.payload.propertyKeyId();
    }

    @Override
    public Object value() {
        return StorePropertyCursor.payloadValueAsObject(this.payload);
    }

    @Override
    public PropertyItem get() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.payload.clear();
            this.instanceCache.accept(this);
        }
        finally {
            this.lock.release();
        }
    }

    static Object payloadValueAsObject(StorePropertyPayloadCursor payload) {
        switch (payload.type()) {
            case BOOL: {
                return payload.booleanValue();
            }
            case BYTE: {
                return payload.byteValue();
            }
            case SHORT: {
                return payload.shortValue();
            }
            case CHAR: {
                return Character.valueOf(payload.charValue());
            }
            case INT: {
                return payload.intValue();
            }
            case LONG: {
                return payload.longValue();
            }
            case FLOAT: {
                return Float.valueOf(payload.floatValue());
            }
            case DOUBLE: {
                return payload.doubleValue();
            }
            case SHORT_STRING: {
                return payload.shortStringValue();
            }
            case STRING: {
                return payload.stringValue();
            }
            case SHORT_ARRAY: {
                return payload.shortArrayValue();
            }
            case ARRAY: {
                return payload.arrayValue();
            }
        }
        throw new IllegalStateException("No such type:" + (Object)((Object)payload.type()));
    }

    private static long readNextPropertyRecordId(PageCursor cursor) {
        byte modifiers = cursor.getByte();
        cursor.getUnsignedInt();
        long nextProp = cursor.getUnsignedInt();
        long nextMod = ((long)modifiers & 0xFL) << 32;
        return StorePropertyCursor.longFromIntAndMod(nextProp, nextMod);
    }

    private static long longFromIntAndMod(long base, long modifier) {
        return modifier == 0L && base == 0xFFFFFFFFL ? -1L : base | modifier;
    }
}

