/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.Resource;
import org.neo4j.kernel.impl.api.store.StoreAbstractRelationshipCursor;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.util.InstanceCache;

public class StoreIteratorRelationshipCursor
extends StoreAbstractRelationshipCursor {
    private PrimitiveLongIterator iterator;
    private final InstanceCache<StoreIteratorRelationshipCursor> instanceCache;

    public StoreIteratorRelationshipCursor(RelationshipRecord relationshipRecord, NeoStores neoStores, StoreStatement storeStatement, InstanceCache<StoreIteratorRelationshipCursor> instanceCache, LockService lockService) {
        super(relationshipRecord, neoStores, storeStatement, lockService);
        this.instanceCache = instanceCache;
    }

    public StoreIteratorRelationshipCursor init(PrimitiveLongIterator iterator) {
        this.iterator = iterator;
        return this;
    }

    @Override
    public boolean next() {
        while (this.iterator != null && this.iterator.hasNext()) {
            if (!this.relationshipStore.fillRecord(this.iterator.next(), this.relationshipRecord, RecordLoad.CHECK) || !this.relationshipRecord.inUse()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        if (this.iterator instanceof Resource) {
            ((Resource)((Object)this.iterator)).close();
        }
        this.iterator = null;
        this.instanceCache.accept(this);
    }
}

