/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.cursor.PropertyItem;
import org.neo4j.kernel.impl.api.store.PropertyBlockCursor;
import org.neo4j.kernel.impl.api.store.PropertyRecordCursor;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.util.InstanceCache;

public class LegacyStorePropertyCursor
implements Cursor<PropertyItem>,
PropertyItem {
    private PropertyStore propertyStore;
    private InstanceCache<LegacyStorePropertyCursor> instanceCache;
    private PropertyRecordCursor propertyRecordCursor;
    private PropertyBlockCursor propertyBlockCursor;

    public LegacyStorePropertyCursor(PropertyStore propertyStore, InstanceCache<LegacyStorePropertyCursor> instanceCache) {
        this.propertyStore = propertyStore;
        this.instanceCache = instanceCache;
    }

    public LegacyStorePropertyCursor init(long firstPropertyId) {
        this.propertyRecordCursor = this.propertyStore.getPropertyRecordCursor(this.propertyRecordCursor, firstPropertyId);
        this.propertyBlockCursor = null;
        return this;
    }

    @Override
    public PropertyItem get() {
        return this;
    }

    @Override
    public boolean next() {
        if (this.propertyBlockCursor != null && this.propertyBlockCursor.next()) {
            return true;
        }
        if (this.propertyRecordCursor.next()) {
            this.propertyBlockCursor = this.propertyRecordCursor.getPropertyBlockCursor(this.propertyBlockCursor);
            return this.propertyBlockCursor.next();
        }
        return false;
    }

    public boolean seek(int keyId) {
        while (this.next()) {
            if (this.propertyBlockCursor.getPropertyBlock().getKeyIndexId() != keyId) continue;
            return true;
        }
        return false;
    }

    @Override
    public int propertyKeyId() {
        return this.propertyBlockCursor.getPropertyBlock().getKeyIndexId();
    }

    @Override
    public Object value() {
        return this.propertyBlockCursor.getProperty().value();
    }

    @Override
    public void close() {
        this.instanceCache.accept(this);
    }
}

