/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Iterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.function.Predicate;
import org.neo4j.function.Supplier;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.CombiningIterator;
import org.neo4j.helpers.collection.FilteringIterator;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.EntityType;
import org.neo4j.kernel.api.cursor.PropertyItem;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.api.cursor.TxAllPropertyCursor;
import org.neo4j.kernel.impl.api.cursor.TxSinglePropertyCursor;
import org.neo4j.kernel.impl.util.VersionedHashMap;

public interface PropertyContainerState {
    public Iterator<DefinedProperty> addedProperties();

    public Iterator<DefinedProperty> changedProperties();

    public Iterator<Integer> removedProperties();

    public Iterator<DefinedProperty> addedAndChangedProperties();

    public Iterator<DefinedProperty> augmentProperties(Iterator<DefinedProperty> var1);

    public void accept(Visitor var1) throws ConstraintValidationKernelException;

    public Cursor<PropertyItem> augmentPropertyCursor(Supplier<TxAllPropertyCursor> var1, Cursor<PropertyItem> var2);

    public Cursor<PropertyItem> augmentSinglePropertyCursor(Supplier<TxSinglePropertyCursor> var1, Cursor<PropertyItem> var2, int var3);

    public static class Mutable
    implements PropertyContainerState {
        private final long id;
        private final EntityType entityType;
        private static final ResourceIterator<DefinedProperty> NO_PROPERTIES = IteratorUtil.emptyIterator();
        private VersionedHashMap<Integer, DefinedProperty> addedProperties;
        private VersionedHashMap<Integer, DefinedProperty> changedProperties;
        private VersionedHashMap<Integer, DefinedProperty> removedProperties;
        private final Predicate<DefinedProperty> excludePropertiesWeKnowAbout = new Predicate<DefinedProperty>(){

            @Override
            public boolean test(DefinedProperty item) {
                return !(Mutable.this.removedProperties != null && Mutable.this.removedProperties.containsKey(item.propertyKeyId()) || Mutable.this.addedProperties != null && Mutable.this.addedProperties.containsKey(item.propertyKeyId()) || Mutable.this.changedProperties != null && Mutable.this.changedProperties.containsKey(item.propertyKeyId()));
            }
        };

        Mutable(long id, EntityType entityType) {
            this.id = id;
            this.entityType = entityType;
        }

        public long getId() {
            return this.id;
        }

        public void clear() {
            if (this.changedProperties != null) {
                this.changedProperties.clear();
            }
            if (this.addedProperties != null) {
                this.addedProperties.clear();
            }
            if (this.removedProperties != null) {
                this.removedProperties.clear();
            }
        }

        public void changeProperty(DefinedProperty property) {
            if (this.addedProperties != null && this.addedProperties.containsKey(property.propertyKeyId())) {
                this.addedProperties.put(property.propertyKeyId(), property);
                return;
            }
            if (this.changedProperties == null) {
                this.changedProperties = new VersionedHashMap();
            }
            this.changedProperties.put(property.propertyKeyId(), property);
            if (this.removedProperties != null) {
                this.removedProperties.remove(property.propertyKeyId());
            }
        }

        public void addProperty(DefinedProperty property) {
            DefinedProperty removed;
            if (this.removedProperties != null && (removed = this.removedProperties.remove(property.propertyKeyId())) != null) {
                this.changeProperty(property);
                return;
            }
            if (this.addedProperties == null) {
                this.addedProperties = new VersionedHashMap();
            }
            this.addedProperties.put(property.propertyKeyId(), property);
        }

        public void removeProperty(DefinedProperty property) {
            if (this.addedProperties != null && this.addedProperties.remove(property.propertyKeyId()) != null) {
                return;
            }
            if (this.removedProperties == null) {
                this.removedProperties = new VersionedHashMap();
            }
            this.removedProperties.put(property.propertyKeyId(), property);
            if (this.changedProperties != null) {
                this.changedProperties.remove(property.propertyKeyId());
            }
        }

        @Override
        public Iterator<DefinedProperty> addedProperties() {
            return this.addedProperties != null ? this.addedProperties.values().iterator() : NO_PROPERTIES;
        }

        @Override
        public Iterator<DefinedProperty> changedProperties() {
            return this.changedProperties != null ? this.changedProperties.values().iterator() : NO_PROPERTIES;
        }

        @Override
        public Iterator<Integer> removedProperties() {
            return this.removedProperties != null ? this.removedProperties.keySet().iterator() : IteratorUtil.emptyIterator();
        }

        @Override
        public Iterator<DefinedProperty> addedAndChangedProperties() {
            Iterator<DefinedProperty> out = null;
            if (this.addedProperties != null) {
                out = this.addedProperties.values().iterator();
            }
            if (this.changedProperties != null) {
                out = out != null ? new CombiningIterator<DefinedProperty>(IteratorUtil.iterator(out, this.changedProperties.values().iterator())) : this.changedProperties.values().iterator();
            }
            return out != null ? out : NO_PROPERTIES;
        }

        @Override
        public Cursor<PropertyItem> augmentPropertyCursor(Supplier<TxAllPropertyCursor> propertyCursorCache, Cursor<PropertyItem> cursor) {
            if (this.removedProperties != null || this.addedProperties != null || this.changedProperties != null) {
                return propertyCursorCache.get().init(cursor, this.addedProperties, this.changedProperties, this.removedProperties);
            }
            return cursor;
        }

        @Override
        public Cursor<PropertyItem> augmentSinglePropertyCursor(Supplier<TxSinglePropertyCursor> propertyCursorCache, Cursor<PropertyItem> cursor, int propertyKeyId) {
            if (this.removedProperties != null || this.addedProperties != null || this.changedProperties != null) {
                return propertyCursorCache.get().init(cursor, this.addedProperties, this.changedProperties, this.removedProperties, propertyKeyId);
            }
            return cursor;
        }

        @Override
        public Iterator<DefinedProperty> augmentProperties(Iterator<DefinedProperty> iterator) {
            if (this.removedProperties != null || this.addedProperties != null || this.changedProperties != null) {
                iterator = new FilteringIterator<DefinedProperty>(iterator, this.excludePropertiesWeKnowAbout);
                if (this.addedProperties != null && !this.addedProperties.isEmpty()) {
                    iterator = new CombiningIterator<DefinedProperty>(IteratorUtil.iterator(iterator, this.addedProperties.values().iterator()));
                }
                if (this.changedProperties != null && !this.changedProperties.isEmpty()) {
                    iterator = new CombiningIterator<DefinedProperty>(IteratorUtil.iterator(iterator, this.changedProperties.values().iterator()));
                }
            }
            return iterator;
        }

        @Override
        public void accept(Visitor visitor) throws ConstraintValidationKernelException {
            if (this.addedProperties != null || this.removedProperties != null || this.changedProperties != null) {
                visitor.visitPropertyChanges(this.id, this.addedProperties(), this.changedProperties(), this.removedProperties());
            }
        }
    }

    public static interface Visitor {
        public void visitPropertyChanges(long var1, Iterator<DefinedProperty> var3, Iterator<DefinedProperty> var4, Iterator<Integer> var5) throws ConstraintValidationKernelException;
    }
}

