/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Collections;
import org.neo4j.function.Supplier;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintVerificationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.UniquenessConstraintVerificationFailedKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.store.SchemaStorage;

public class ConstraintIndexCreator {
    private final IndexingService indexingService;
    private final Supplier<KernelAPI> kernelSupplier;

    public ConstraintIndexCreator(Supplier<KernelAPI> kernelSupplier, IndexingService indexingService) {
        this.kernelSupplier = kernelSupplier;
        this.indexingService = indexingService;
    }

    public long createUniquenessConstraintIndex(KernelStatement state, SchemaReadOperations schema, int labelId, int propertyKeyId) throws ConstraintVerificationFailedKernelException, TransactionFailureException, CreateConstraintFailureException, DropIndexFailureException {
        IndexDescriptor descriptor = this.createConstraintIndex(labelId, propertyKeyId);
        UniquenessConstraint constraint = new UniquenessConstraint(labelId, propertyKeyId);
        boolean success = false;
        try {
            long indexId = schema.indexGetCommittedId(state, descriptor, SchemaStorage.IndexRuleKind.CONSTRAINT);
            this.awaitIndexPopulation(constraint, indexId);
            success = true;
            long l = indexId;
            return l;
        }
        catch (SchemaRuleNotFoundException e) {
            throw new IllegalStateException(String.format("Index (%s) that we just created does not exist.", descriptor));
        }
        catch (InterruptedException e) {
            throw new CreateConstraintFailureException(constraint, (Throwable)e);
        }
        finally {
            if (!success) {
                this.dropUniquenessConstraintIndex(descriptor);
            }
        }
    }

    public void dropUniquenessConstraintIndex(IndexDescriptor descriptor) throws TransactionFailureException, DropIndexFailureException {
        try (KernelTransaction transaction = this.kernelSupplier.get().newTransaction();
             Statement statement = transaction.acquireStatement();){
            ((KernelStatement)statement).txState().constraintIndexDoDrop(descriptor);
            transaction.success();
        }
    }

    private void awaitIndexPopulation(UniquenessConstraint constraint, long indexId) throws InterruptedException, ConstraintVerificationFailedKernelException {
        try {
            this.indexingService.getIndexProxy(indexId).awaitStoreScanCompleted();
        }
        catch (IndexNotFoundKernelException e) {
            throw new IllegalStateException(String.format("Index (indexId=%d) that we just created does not exist.", indexId));
        }
        catch (IndexPopulationFailedKernelException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IndexEntryConflictException) {
                throw new UniquenessConstraintVerificationFailedKernelException(constraint, Collections.singleton((IndexEntryConflictException)cause));
            }
            throw new UniquenessConstraintVerificationFailedKernelException(constraint, cause);
        }
    }

    /*
     * Exception decompiling
     */
    public IndexDescriptor createConstraintIndex(int labelId, int propertyKeyId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

