/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.cursor;

import org.neo4j.cursor.Cursor;
import org.neo4j.function.Consumer;
import org.neo4j.kernel.api.cursor.NodeItem;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.cursor.TxAbstractNodeCursor;

public class TxSingleNodeCursor
extends TxAbstractNodeCursor {
    public TxSingleNodeCursor(TransactionState state, Consumer<TxSingleNodeCursor> cache) {
        super(state, cache);
    }

    public TxSingleNodeCursor init(Cursor<NodeItem> nodeCursor, long nodeId) {
        this.id = nodeId;
        super.init(nodeCursor);
        return this;
    }

    @Override
    public boolean next() {
        if (this.id == -1L) {
            return false;
        }
        boolean exists = this.cursor.next();
        if (this.state.nodeIsDeletedInThisTx(this.id)) {
            this.id = -1L;
            return false;
        }
        this.nodeIsAddedInThisTx = this.state.nodeIsAddedInThisTx(this.id);
        if (exists || this.nodeIsAddedInThisTx) {
            this.nodeState = this.state.getNodeState(this.id);
            return true;
        }
        this.id = -1L;
        this.nodeState = null;
        return false;
    }
}

