/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.cursor;

import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.function.Consumer;
import org.neo4j.kernel.api.cursor.RelationshipItem;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.cursor.TxAbstractRelationshipCursor;

public class TxIteratorRelationshipCursor
extends TxAbstractRelationshipCursor {
    private PrimitiveLongIterator added;
    private PrimitiveLongIterator addedRelationshipIterator;

    public TxIteratorRelationshipCursor(TransactionState state, Consumer<TxIteratorRelationshipCursor> instanceCache) {
        super(state, instanceCache);
    }

    public TxIteratorRelationshipCursor init(Cursor<RelationshipItem> cursor, PrimitiveLongIterator addedRelationshipIterator) {
        super.init(cursor);
        this.relationshipIsAddedInThisTx = false;
        this.addedRelationshipIterator = addedRelationshipIterator;
        this.added = null;
        return this;
    }

    @Override
    public boolean next() {
        if (this.added == null) {
            while (this.cursor.next()) {
                RelationshipItem relationshipItem = (RelationshipItem)this.cursor.get();
                long id = relationshipItem.id();
                if (this.state.relationshipIsDeletedInThisTx(id)) continue;
                this.visit(id, relationshipItem.type(), relationshipItem.startNode(), relationshipItem.endNode());
                this.relationshipState = this.state.getRelationshipState(relationshipItem.id());
                return true;
            }
            this.added = this.addedRelationshipIterator;
            this.relationshipIsAddedInThisTx = true;
        }
        if (this.added.hasNext()) {
            this.relationshipState = this.state.getRelationshipState(this.added.next());
            this.relationshipState.accept(this);
            return true;
        }
        this.visit(-1L, -1, -1L, -1L);
        this.relationshipState = null;
        return false;
    }

    @Override
    public void close() {
        super.close();
        this.addedRelationshipIterator = null;
        this.added = null;
    }
}

