/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import org.neo4j.function.Function;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.CommandHandler;

public class CountsStoreApplier
extends CommandHandler.Adapter {
    static final Function<CountsAccessor.Updater, CommandHandler> FACTORY = new Function<CountsAccessor.Updater, CommandHandler>(){

        @Override
        public CommandHandler apply(CountsAccessor.Updater updater) {
            return new CountsStoreApplier(updater);
        }
    };
    private final CountsAccessor.Updater countsUpdater;

    public CountsStoreApplier(CountsAccessor.Updater countsUpdater) {
        this.countsUpdater = countsUpdater;
    }

    @Override
    public void close() {
        this.countsUpdater.close();
    }

    @Override
    public boolean visitNodeCountsCommand(Command.NodeCountsCommand command) {
        this.countsUpdater.incrementNodeCount(command.labelId(), command.delta());
        return false;
    }

    @Override
    public boolean visitRelationshipCountsCommand(Command.RelationshipCountsCommand command) throws IOException {
        this.countsUpdater.incrementRelationshipCount(command.startLabelId(), command.typeId(), command.endLabelId(), command.delta());
        return false;
    }
}

