/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.annotations;

import java.io.IOException;
import java.util.Map;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.kernel.impl.annotations.AnnotationProcessor;

@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
@SupportedAnnotationTypes(value={"org.neo4j.kernel.impl.annotations.Documented"})
public class DocumentationProcessor
extends AnnotationProcessor {
    @Override
    protected void process(TypeElement annotationType, Element annotated, AnnotationMirror annotation, Map<? extends ExecutableElement, ? extends AnnotationValue> values) throws IOException {
        if (values.size() != 1) {
            this.error(annotated, annotation, "Annotation values don't match the expectation");
            return;
        }
        String value = (String)values.values().iterator().next().getValue();
        if (StringUtils.isBlank(value)) {
            this.error(annotated, annotation, "Documentation not available for " + annotated);
        }
    }
}

