/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.tracing;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.SwitchPoint;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.EvictionRunEvent;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.FlushEventOpportunity;
import org.neo4j.io.pagecache.tracing.MajorFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.io.pagecache.tracing.PinEvent;
import org.neo4j.unsafe.impl.internal.dragons.FeatureToggles;

public class DefaultPageCacheTracer
implements PageCacheTracer {
    private static final MethodHandle beginPinMH;
    private static final SwitchPoint beginPinSwitchPoint;
    protected final AtomicLong faults = new AtomicLong();
    protected final AtomicLong evictions = new AtomicLong();
    protected final AtomicLong pins = new AtomicLong();
    protected final AtomicLong unpins = new AtomicLong();
    protected final AtomicLong flushes = new AtomicLong();
    protected final AtomicLong bytesRead = new AtomicLong();
    protected final AtomicLong bytesWritten = new AtomicLong();
    protected final AtomicLong filesMapped = new AtomicLong();
    protected final AtomicLong filesUnmapped = new AtomicLong();
    protected final AtomicLong evictionExceptions = new AtomicLong();
    private final FlushEvent flushEvent = new FlushEvent(){

        @Override
        public void addBytesWritten(long bytes) {
            DefaultPageCacheTracer.this.bytesWritten.getAndAdd(bytes);
        }

        @Override
        public void done() {
            DefaultPageCacheTracer.this.flushes.getAndIncrement();
        }

        @Override
        public void done(IOException exception) {
            this.done();
        }

        @Override
        public void addPagesFlushed(int pageCount) {
        }
    };
    private final FlushEventOpportunity flushEventOpportunity = new FlushEventOpportunity(){

        @Override
        public FlushEvent beginFlush(long filePageId, int cachePageId, PageSwapper swapper) {
            return DefaultPageCacheTracer.this.flushEvent;
        }
    };
    private final EvictionEvent evictionEvent = new EvictionEvent(){

        @Override
        public void setFilePageId(long filePageId) {
        }

        @Override
        public void setSwapper(PageSwapper swapper) {
        }

        @Override
        public FlushEventOpportunity flushEventOpportunity() {
            return DefaultPageCacheTracer.this.flushEventOpportunity;
        }

        @Override
        public void threwException(IOException exception) {
            DefaultPageCacheTracer.this.evictionExceptions.getAndIncrement();
        }

        @Override
        public void setCachePageId(int cachePageId) {
        }

        @Override
        public void close() {
            DefaultPageCacheTracer.this.evictions.getAndIncrement();
        }
    };
    private final EvictionRunEvent evictionRunEvent = new EvictionRunEvent(){

        @Override
        public EvictionEvent beginEviction() {
            return DefaultPageCacheTracer.this.evictionEvent;
        }

        @Override
        public void close() {
        }
    };
    private final PageFaultEvent pageFaultEvent = new PageFaultEvent(){

        @Override
        public void addBytesRead(long bytes) {
            DefaultPageCacheTracer.this.bytesRead.getAndAdd(bytes);
        }

        @Override
        public void done() {
            DefaultPageCacheTracer.this.faults.getAndIncrement();
        }

        @Override
        public void done(Throwable throwable) {
            this.done();
        }

        @Override
        public EvictionEvent beginEviction() {
            return DefaultPageCacheTracer.this.evictionEvent;
        }

        @Override
        public void setCachePageId(int cachePageId) {
        }
    };
    private final PinEvent pinTracingEvent = new PinEvent(){

        @Override
        public void setCachePageId(int cachePageId) {
        }

        @Override
        public PageFaultEvent beginPageFault() {
            return DefaultPageCacheTracer.this.pageFaultEvent;
        }

        @Override
        public void done() {
            DefaultPageCacheTracer.this.unpins.getAndIncrement();
        }
    };
    private final PinEvent nullPinEvent = new PinEvent(){

        @Override
        public void setCachePageId(int cachePageId) {
        }

        @Override
        public PageFaultEvent beginPageFault() {
            return DefaultPageCacheTracer.this.pageFaultEvent;
        }

        @Override
        public void done() {
        }
    };
    private final MajorFlushEvent majorFlushEvent = new MajorFlushEvent(){

        @Override
        public FlushEventOpportunity flushEventOpportunity() {
            return DefaultPageCacheTracer.this.flushEventOpportunity;
        }

        @Override
        public void close() {
        }
    };

    public static void enablePinUnpinTracing() {
        if (beginPinSwitchPoint != null && !beginPinSwitchPoint.hasBeenInvalidated()) {
            SwitchPoint.invalidateAll(new SwitchPoint[]{beginPinSwitchPoint});
        }
    }

    @Override
    public void mappedFile(File file) {
        this.filesMapped.getAndIncrement();
    }

    @Override
    public void unmappedFile(File file) {
        this.filesUnmapped.getAndIncrement();
    }

    @Override
    public EvictionRunEvent beginPageEvictions(int pageCountToEvict) {
        return this.evictionRunEvent;
    }

    @Override
    public PinEvent beginPin(boolean exclusiveLock, long filePageId, PageSwapper swapper) {
        try {
            return beginPinMH.invokeExact(this);
        }
        catch (Throwable throwable) {
            throw new AssertionError("Unexpected MethodHandle error", throwable);
        }
    }

    private PinEvent beginNullPin() {
        return this.nullPinEvent;
    }

    private PinEvent beginTracingPin() {
        this.pins.getAndIncrement();
        return this.pinTracingEvent;
    }

    @Override
    public MajorFlushEvent beginFileFlush(PageSwapper swapper) {
        return this.majorFlushEvent;
    }

    @Override
    public MajorFlushEvent beginCacheFlush() {
        return this.majorFlushEvent;
    }

    @Override
    public long countFaults() {
        return this.faults.get();
    }

    @Override
    public long countEvictions() {
        return this.evictions.get();
    }

    @Override
    public long countPins() {
        return this.pins.get();
    }

    @Override
    public long countUnpins() {
        return this.unpins.get();
    }

    @Override
    public long countFlushes() {
        return this.flushes.get();
    }

    @Override
    public long countBytesRead() {
        return this.bytesRead.get();
    }

    @Override
    public long countBytesWritten() {
        return this.bytesWritten.get();
    }

    @Override
    public long countFilesMapped() {
        return this.filesMapped.get();
    }

    @Override
    public long countFilesUnmapped() {
        return this.filesUnmapped.get();
    }

    @Override
    public long countEvictionExceptions() {
        return this.evictionExceptions.get();
    }

    static {
        try {
            boolean alwaysEnabled = FeatureToggles.packageFlag(DefaultPageCacheTracer.class, "tracePinUnpin", false);
            MethodType type = MethodType.methodType(PinEvent.class);
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle monitoredPinMH = lookup.findVirtual(DefaultPageCacheTracer.class, "beginTracingPin", type);
            if (alwaysEnabled) {
                beginPinMH = monitoredPinMH;
                beginPinSwitchPoint = null;
            } else {
                MethodHandle nullPinMH = lookup.findVirtual(DefaultPageCacheTracer.class, "beginNullPin", type);
                beginPinSwitchPoint = new SwitchPoint();
                beginPinMH = beginPinSwitchPoint.guardWithTest(nullPinMH, monitoredPinMH);
            }
        }
        catch (Exception e) {
            throw new AssertionError("Unexpected MethodHandle initiation error", e);
        }
    }
}

