/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import org.neo4j.concurrent.jsr166e.StampedLock;
import org.neo4j.io.pagecache.Page;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.FlushEventOpportunity;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.unsafe.impl.internal.dragons.MemoryManager;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

final class MuninnPage
extends StampedLock
implements Page {
    private static final long usageStampOffset = UnsafeUtil.getFieldOffset(MuninnPage.class, "usageStamp");
    private byte cachePageHeader;
    private final MemoryManager memoryManager;
    private long pointer;
    private volatile byte usageStamp;
    public Object nextFree;
    private PageSwapper swapper;
    private long filePageId = -1L;

    public MuninnPage(int cachePageSize, MemoryManager memoryManager) {
        this.cachePageHeader = (byte)(31 - Integer.numberOfLeadingZeros(cachePageSize));
        this.memoryManager = memoryManager;
        this.getCachePageId();
    }

    private void checkBounds(int position) {
        if (position > this.size()) {
            String msg = "Position " + position + " is greater than the upper " + "page size bound of " + this.size();
            throw new IndexOutOfBoundsException(msg);
        }
    }

    public int getCachePageId() {
        return System.identityHashCode(this);
    }

    @Override
    public int size() {
        return 1 << (this.cachePageHeader & 0x7F);
    }

    @Override
    public long address() {
        return this.pointer;
    }

    boolean isDirty() {
        return (this.cachePageHeader & 0xFFFFFF80) != 0;
    }

    public void markAsDirty() {
        this.cachePageHeader = (byte)(this.cachePageHeader | 0xFFFFFF80);
    }

    public void markAsClean() {
        this.cachePageHeader = (byte)(this.cachePageHeader & 0x7F);
    }

    public void incrementUsage() {
        byte usage = UnsafeUtil.getByteVolatile(this, usageStampOffset);
        if (usage < 4) {
            usage = (byte)(usage << 1);
            usage = (byte)(usage + 1);
            usage = (byte)(usage & 0xF);
            UnsafeUtil.putByteVolatile(this, usageStampOffset, usage);
        }
    }

    public boolean decrementUsage() {
        byte usage = UnsafeUtil.getByteVolatile(this, usageStampOffset);
        usage = (byte)(usage >>> 1);
        UnsafeUtil.putByteVolatile(this, usageStampOffset, usage);
        return usage == 0;
    }

    public byte getByte(int offset) {
        this.checkBounds(offset + 1);
        return UnsafeUtil.getByte(this.pointer + (long)offset);
    }

    public void putByte(byte value, int offset) {
        this.checkBounds(offset + 1);
        UnsafeUtil.putByte(this.pointer + (long)offset, value);
    }

    public long getLong(int offset) {
        this.checkBounds(offset + 8);
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            long x = UnsafeUtil.getLong(this.pointer + (long)offset);
            return UnsafeUtil.storeByteOrderIsNative ? x : Long.reverseBytes(x);
        }
        return this.getLongBigEndian(offset);
    }

    private long getLongBigEndian(int offset) {
        long p = this.pointer + (long)offset;
        long a = UnsafeUtil.getByte(p) & 0xFF;
        long b = UnsafeUtil.getByte(p + 1L) & 0xFF;
        long c = UnsafeUtil.getByte(p + 2L) & 0xFF;
        long d = UnsafeUtil.getByte(p + 3L) & 0xFF;
        long e = UnsafeUtil.getByte(p + 4L) & 0xFF;
        long f = UnsafeUtil.getByte(p + 5L) & 0xFF;
        long g = UnsafeUtil.getByte(p + 6L) & 0xFF;
        long h = UnsafeUtil.getByte(p + 7L) & 0xFF;
        return a << 56 | b << 48 | c << 40 | d << 32 | e << 24 | f << 16 | g << 8 | h;
    }

    public void putLong(long value, int offset) {
        this.checkBounds(offset + 8);
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            long p = this.pointer + (long)offset;
            UnsafeUtil.putLong(p, UnsafeUtil.storeByteOrderIsNative ? value : Long.reverseBytes(value));
        } else {
            this.putLongBigEndian(value, offset);
        }
    }

    private void putLongBigEndian(long value, int offset) {
        long p = this.pointer + (long)offset;
        UnsafeUtil.putByte(p, (byte)(value >> 56));
        UnsafeUtil.putByte(p + 1L, (byte)(value >> 48));
        UnsafeUtil.putByte(p + 2L, (byte)(value >> 40));
        UnsafeUtil.putByte(p + 3L, (byte)(value >> 32));
        UnsafeUtil.putByte(p + 4L, (byte)(value >> 24));
        UnsafeUtil.putByte(p + 5L, (byte)(value >> 16));
        UnsafeUtil.putByte(p + 6L, (byte)(value >> 8));
        UnsafeUtil.putByte(p + 7L, (byte)value);
    }

    public int getInt(int offset) {
        this.checkBounds(offset + 4);
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            int x = UnsafeUtil.getInt(this.pointer + (long)offset);
            return UnsafeUtil.storeByteOrderIsNative ? x : Integer.reverseBytes(x);
        }
        return this.getIntBigEndian(offset);
    }

    private int getIntBigEndian(int offset) {
        long p = this.pointer + (long)offset;
        int a = UnsafeUtil.getByte(p) & 0xFF;
        int b = UnsafeUtil.getByte(p + 1L) & 0xFF;
        int c = UnsafeUtil.getByte(p + 2L) & 0xFF;
        int d = UnsafeUtil.getByte(p + 3L) & 0xFF;
        return a << 24 | b << 16 | c << 8 | d;
    }

    public void putInt(int value, int offset) {
        this.checkBounds(offset + 4);
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            long p = this.pointer + (long)offset;
            UnsafeUtil.putInt(p, UnsafeUtil.storeByteOrderIsNative ? value : Integer.reverseBytes(value));
        } else {
            this.putIntBigEndian(value, offset);
        }
    }

    private void putIntBigEndian(int value, int offset) {
        long p = this.pointer + (long)offset;
        UnsafeUtil.putByte(p, (byte)(value >> 24));
        UnsafeUtil.putByte(p + 1L, (byte)(value >> 16));
        UnsafeUtil.putByte(p + 2L, (byte)(value >> 8));
        UnsafeUtil.putByte(p + 3L, (byte)value);
    }

    public short getShort(int offset) {
        this.checkBounds(offset + 2);
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            short x = UnsafeUtil.getShort(this.pointer + (long)offset);
            return UnsafeUtil.storeByteOrderIsNative ? x : Short.reverseBytes(x);
        }
        return this.getShortBigEndian(offset);
    }

    private short getShortBigEndian(int offset) {
        long p = this.pointer + (long)offset;
        short a = (short)(UnsafeUtil.getByte(p) & 0xFF);
        short b = (short)(UnsafeUtil.getByte(p + 1L) & 0xFF);
        return (short)(a << 8 | b);
    }

    public void putShort(short value, int offset) {
        this.checkBounds(offset + 2);
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            long p = this.pointer + (long)offset;
            UnsafeUtil.putShort(p, UnsafeUtil.storeByteOrderIsNative ? value : Short.reverseBytes(value));
        } else {
            this.putShortBigEndian(value, offset);
        }
    }

    private void putShortBigEndian(short value, int offset) {
        long p = this.pointer + (long)offset;
        UnsafeUtil.putByte(p, (byte)(value >> 8));
        UnsafeUtil.putByte(p + 1L, (byte)value);
    }

    public void getBytes(byte[] data, int pageOffset, int arrayOffset, int length) {
        this.checkBounds(pageOffset + length);
        long address = this.pointer + (long)pageOffset;
        for (int i = 0; i < length; ++i) {
            data[arrayOffset + i] = UnsafeUtil.getByte(address + (long)i);
        }
    }

    public void putBytes(byte[] data, int pageOffset, int arrayOffset, int length) {
        this.checkBounds(pageOffset + length);
        long address = this.pointer + (long)pageOffset;
        for (int i = 0; i < length; ++i) {
            byte b = data[arrayOffset + i];
            UnsafeUtil.putByte(address + (long)i, b);
        }
    }

    public void flush(FlushEventOpportunity flushOpportunity) throws IOException {
        if (this.swapper != null && this.isDirty()) {
            this.doFlush(this.swapper, this.filePageId, flushOpportunity);
        }
    }

    private void doFlush(PageSwapper swapper, long filePageId, FlushEventOpportunity flushOpportunity) throws IOException {
        assert (this.isReadLocked() || this.isWriteLocked()) : "doFlush requires lock";
        FlushEvent event = flushOpportunity.beginFlush(filePageId, this.getCachePageId(), swapper);
        try {
            long bytesWritten = swapper.write(filePageId, this);
            this.markAsClean();
            event.addBytesWritten(bytesWritten);
            event.done();
        }
        catch (IOException e) {
            event.done(e);
            throw e;
        }
    }

    public void fault(PageSwapper swapper, long filePageId, PageFaultEvent faultEvent) throws IOException {
        assert (this.isWriteLocked()) : "Cannot fault page without write-lock";
        if (this.swapper != null || this.filePageId != -1L) {
            String msg = String.format("Cannot fault page {filePageId = %s, swapper = %s} into cache page %s. Already bound to {filePageId = %s, swapper = %s}.", filePageId, swapper, this.getCachePageId(), this.filePageId, this.swapper);
            throw new IllegalStateException(msg);
        }
        this.filePageId = filePageId;
        long bytesRead = swapper.read(filePageId, this);
        faultEvent.addBytesRead(bytesRead);
        faultEvent.setCachePageId(this.getCachePageId());
        this.swapper = swapper;
    }

    public void evict(EvictionEvent evictionEvent) throws IOException {
        assert (this.isWriteLocked()) : "Cannot evict page without write-lock";
        long filePageId = this.filePageId;
        evictionEvent.setCachePageId(this.getCachePageId());
        evictionEvent.setFilePageId(filePageId);
        PageSwapper swapper = this.swapper;
        evictionEvent.setSwapper(swapper);
        this.flush(evictionEvent.flushEventOpportunity());
        this.filePageId = -1L;
        this.swapper = null;
        if (swapper != null) {
            swapper.evicted(filePageId, this);
        }
    }

    public boolean isLoaded() {
        return this.filePageId != -1L;
    }

    public boolean isBoundTo(PageSwapper swapper, long filePageId) {
        return this.swapper == swapper && this.filePageId == filePageId;
    }

    public void initBuffer() {
        assert (this.isWriteLocked()) : "Cannot initBuffer without write-lock";
        if (this.pointer == 0L) {
            this.pointer = this.memoryManager.allocateAligned(this.size());
        }
    }

    public long getFilePageId() {
        return this.filePageId;
    }

    @Override
    public String toString() {
        return String.format("MuninnPage@%x[%s -> %x, filePageId = %s%s, swapper = %s]%s", this.hashCode(), this.getCachePageId(), this.pointer, this.filePageId, this.isDirty() ? ", dirty" : "", this.swapper, this.getLockStateString());
    }
}

