/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.io.IOException;
import java.util.Arrays;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.ThisShouldNotHappenError;

public final class Strings {
    public static final String TAB = "\t";
    public static final Function<String, String> decamelize = new Function<String, String>(){

        @Override
        public String apply(String name) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (Character.isUpperCase(c)) {
                    if (i > 0) {
                        result.append('_');
                    }
                    result.append(Character.toLowerCase(c));
                    continue;
                }
                result.append(c);
            }
            return result.toString();
        }
    };

    private Strings() {
    }

    public static boolean isBlank(String str) {
        if (str == null || str.isEmpty()) {
            return true;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String defaultIfBlank(String str, String defaultStr) {
        return Strings.isBlank(str) ? defaultStr : str;
    }

    public static String prettyPrint(Object o) {
        if (o == null) {
            return "null";
        }
        Class<?> clazz = o.getClass();
        if (clazz.isArray()) {
            if (clazz == byte[].class) {
                return Arrays.toString((byte[])o);
            }
            if (clazz == short[].class) {
                return Arrays.toString((short[])o);
            }
            if (clazz == int[].class) {
                return Arrays.toString((int[])o);
            }
            if (clazz == long[].class) {
                return Arrays.toString((long[])o);
            }
            if (clazz == float[].class) {
                return Arrays.toString((float[])o);
            }
            if (clazz == double[].class) {
                return Arrays.toString((double[])o);
            }
            if (clazz == char[].class) {
                return Arrays.toString((char[])o);
            }
            if (clazz == boolean[].class) {
                return Arrays.toString((boolean[])o);
            }
            return Arrays.deepToString((Object[])o);
        }
        return String.valueOf(o);
    }

    public static String escape(String arg) {
        StringBuilder builder = new StringBuilder(arg.length());
        try {
            Strings.escape(builder, arg);
        }
        catch (IOException e) {
            throw new ThisShouldNotHappenError("Stefan", "IOException from using StringBuilder", e);
        }
        return builder.toString();
    }

    public static String joinAsLines(String ... elements) {
        StringBuilder result = new StringBuilder();
        for (String line : elements) {
            result.append(line).append(System.lineSeparator());
        }
        return result.toString();
    }

    public static void escape(Appendable output, String arg) throws IOException {
        int len = arg.length();
        block10: for (int i = 0; i < len; ++i) {
            char ch = arg.charAt(i);
            switch (ch) {
                case '\"': {
                    output.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    output.append("\\'");
                    continue block10;
                }
                case '\\': {
                    output.append("\\\\");
                    continue block10;
                }
                case '\n': {
                    output.append("\\n");
                    continue block10;
                }
                case '\t': {
                    output.append("\\t");
                    continue block10;
                }
                case '\r': {
                    output.append("\\r");
                    continue block10;
                }
                case '\b': {
                    output.append("\\b");
                    continue block10;
                }
                case '\f': {
                    output.append("\\f");
                    continue block10;
                }
                default: {
                    output.append(ch);
                }
            }
        }
    }

    public static String ljust(String str, int columnWidth) {
        return String.format("%-" + columnWidth + "s", str);
    }

    public static String rjust(String str, int columnWidth) {
        return String.format("%" + columnWidth + "s", str);
    }
}

